/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_config.h,v 1.4 2001/05/31 05:57:56 glass Exp $
 */

#ifndef IC_CONFIG_H
#define IC_CONFIG_H

typedef unsigned char      BYTE;
typedef unsigned short int UINT16;
typedef unsigned long int  UINT32;
typedef short int          INT16;
typedef int                INT32;

#if defined(__EMX__) || defined(__IBMCPP__) || defined(__BORLANDC__)
  #define IC_OPEN_BIN_WRITE "wb"
  #define IC_OPEN_BIN_READ  "rb"
#else
  #define IC_OPEN_BIN_WRITE "w"
  #define IC_OPEN_BIN_READ  "r"
#endif

#if defined(__TOS_OS2__) || defined(__TOS_WIN__)
  #define PC '\\'
  #define PS "\\"
#else
  #define PC '/'
  #define PS "/"
#endif

enum icon_type { unknown, /* Unknown format           */
                 os2_v12, /* OS/2 v1.2  icons format  */
                 os2_v20, /* OS/2 v2.0  icons format  */
                 win_ico, /* MS Windows icons format  */
                 win_icl  /* MS Windows icons library */
               };

extern int load_dump;
extern int maps_dump;
#endif
