/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.util;

import java.util.Enumeration;
import java.util.Vector;

public final class ThreadCollection {
    private Vector threads = new Vector(128, 256);

    public final int activeCount() {
        Vector vector = this.threads;
        synchronized (vector) {
            int n = 0;
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread = (Thread)enumeration.nextElement();
                if (thread == null || !thread.isAlive()) continue;
                ++n;
            }
            return n;
        }
    }

    public final int add(Thread thread) {
        if (thread == null) {
            new NullPointerException("thread == null");
        }
        Vector vector = this.threads;
        synchronized (vector) {
            boolean bl = false;
            int n = 0;
            while (n < this.threads.size()) {
                Thread thread2 = (Thread)this.threads.elementAt(n);
                if (thread2 == null) {
                    this.threads.setElementAt(thread, n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.threads.addElement(thread);
            }
        }
        return this.count();
    }

    public final int count() {
        Vector vector = this.threads;
        synchronized (vector) {
            int n = 0;
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() == null) continue;
                ++n;
            }
            return n;
        }
    }

    public final void done() {
        this.gc();
        this.interrupt();
    }

    public final void gc() {
        Vector vector = this.threads;
        synchronized (vector) {
            int n = 0;
            while (n < this.threads.size()) {
                Thread thread = (Thread)this.threads.elementAt(n);
                if (thread != null && !thread.isAlive()) {
                    this.threads.setElementAt(null, n);
                }
                ++n;
            }
        }
    }

    public final Thread getThread(String string) {
        Vector vector = this.threads;
        synchronized (vector) {
            if (string == null) {
                return null;
            }
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread = (Thread)enumeration.nextElement();
                if (thread == null || !thread.getName().equals(string)) continue;
                return thread;
            }
        }
        return null;
    }

    public final void interrupt() {
        Vector vector = this.threads;
        synchronized (vector) {
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread = (Thread)enumeration.nextElement();
                if (thread == null || !thread.isAlive()) continue;
                thread.interrupt();
            }
        }
    }
}

