/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.process;

import com.vyx.process.ExtInputStreamThread;
import com.vyx.util.IAddLine;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class Exec
extends Thread {
    public static final int RC_EX = -999;
    private Runtime rt = Runtime.getRuntime();
    private static final String NEW_LINE = System.getProperty("line.separator");
    private volatile boolean runned;
    private int RC;
    private String exMsg;
    private StreamBuf stdoutBuf = null;
    private String encoding = "Cp866";
    private StreamBuf stderrBuf = null;
    private ExtInputStreamThread stdout = null;
    private ExtInputStreamThread stderr = null;
    private Process p = null;
    private OutputStream stdin = null;

    public Exec() {
        this.init();
    }

    public Exec(Runnable runnable) {
        super(runnable);
        this.init();
    }

    public Exec(Runnable runnable, String string) {
        super(runnable, string);
        this.init();
    }

    public Exec(String string) {
        super(string);
        this.init();
    }

    public Exec(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        this.init();
    }

    public Exec(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
        this.init();
    }

    public Exec(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        this.init();
    }

    public void clearAll() {
        this.stderrBuf.clear();
        this.stdoutBuf.clear();
        this.RC = 0;
        this.exMsg = "";
    }

    public void doIt(String string) {
        try {
            this.execute(string);
        }
        catch (Exception exception) {
            this.RC = -999;
            this.exMsg = exception.getMessage();
            exception.printStackTrace();
        }
    }

    public void doItWait(String string) {
        try {
            this.execute(string);
            this.join();
        }
        catch (Exception exception) {
            this.RC = -999;
            this.exMsg = exception.getMessage();
        }
    }

    private void execute(String string) throws IOException {
        this.clearAll();
        this.p = this.rt.exec(string);
        this.stdout = new ExtInputStreamThread(this.stdoutBuf);
        this.stderr = new ExtInputStreamThread(this.stderrBuf);
        this.stderr.setEncoding(this.encoding);
        this.stdout.setEncoding(this.encoding);
        this.stdout.setStream(this.p.getInputStream());
        this.stderr.setStream(this.p.getErrorStream());
        this.stdin = this.p.getOutputStream();
        this.start();
        this.stdout.start();
        this.stderr.start();
    }

    public String getExceptionMsg() {
        return this.exMsg;
    }

    public String getLastStdErrLine() {
        return this.stderrBuf.screen.size() == 0 ? "" : this.stderrBuf.screen.elementAt(this.stderrBuf.screen.size() - 1).toString();
    }

    public String getLastStdOutLine() {
        return this.stdoutBuf.screen.size() == 0 ? "" : this.stdoutBuf.screen.elementAt(this.stdoutBuf.screen.size() - 1).toString();
    }

    public int getRC() {
        return this.RC;
    }

    public Vector getStdErr() {
        return this.stderrBuf.screen;
    }

    public Vector getStdOut() {
        return this.stdoutBuf.screen;
    }

    private void init() {
        this.stdoutBuf = new StreamBuf(this);
        this.stderrBuf = new StreamBuf(this);
    }

    public boolean isRunned() {
        return this.runned;
    }

    public void kill() {
        if (this.isRunned()) {
            this.p.destroy();
            this.setRunned(false);
        }
    }

    public void run() {
        this.setRunned(false);
        this.exMsg = "";
        try {
            try {
                this.setRunned(true);
                this.RC = this.p.waitFor();
                this.stdout.join();
                this.stderr.join();
            }
            catch (Exception exception) {
                this.RC = this.p.exitValue();
                this.exMsg = exception.getMessage();
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.setRunned(false);
            throw throwable;
        }
        Object var1_4 = null;
        this.setRunned(false);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    private void setRunned(boolean bl) {
        this.runned = bl;
    }

    public void write(String string) {
        try {
            if (!(string != null && this.stdin != null || this.runned)) {
                return;
            }
            if (!string.endsWith(NEW_LINE)) {
                string = String.valueOf(string) + NEW_LINE;
            }
            this.stdin.write(string.getBytes(this.encoding));
            this.stdin.flush();
        }
        catch (Exception exception) {}
    }

    class StreamBuf
    implements IAddLine {
        /* synthetic */ Exec this$0;
        public Vector screen = new Vector(200, 200);

        public void addLine(String string) {
            Vector vector = this.screen;
            synchronized (vector) {
                this.screen.addElement(string);
            }
        }

        public void clear() {
            Vector vector = this.screen;
            synchronized (vector) {
                this.screen.removeAllElements();
            }
        }

        StreamBuf(Exec exec) {
            this.this$0 = exec;
        }
    }
}

