/*
 * Created on 12.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.ssfuture.tools.jfonttools.comparison.FontPrinter;
import de.ssfuture.tools.jfonttools.comparison.FontWindow;

/**
 * @author Sebastian Schleemilch
 */
public class FontComparisonDialog extends JDialog implements ChangeListener, ActionListener {
	JLabel lblfonts[];
	Font[] f;
	Box fontlist;
	JSlider fontsize = new JSlider(1, 250);
	JToggleButton fontstyle_bold = new JToggleButton("bold");
	JToggleButton fontstyle_italic = new JToggleButton("italic");
	JButton bgcolor = new JButton("BG");
	JButton fgcolor = new JButton("FG");
	JTextArea previewLabel = new JTextArea("Example Text for font comparison");
	JButton screenPreview_btn = new JButton("View on screen");
	JButton print_btn = new JButton("Print comparision");
	
	public FontComparisonDialog(Frame parent, Font[] fonts) {
		super(parent, "Font comparison dialog -- Options", true);
		f = fonts;
		setSize(400, 330);
		WindowPositionTools.center(this);
		
		fontlist = Box.createVerticalBox();
		lblfonts = new JLabel[fonts.length];
		for(int i = 0; i < fonts.length; i++) {
			lblfonts[i] = new JLabel(fonts[i].getName());
			lblfonts[i].setFont(fonts[i]);
			lblfonts[i].setToolTipText(fonts[i].getName());
			fontlist.add(lblfonts[i]);
		}
		
		getContentPane().setLayout(new BorderLayout());
		JScrollPane lblfonts_scroll = new JScrollPane(
				fontlist, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, 
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		getContentPane().add(lblfonts_scroll, BorderLayout.WEST);
		
		getContentPane().add(new JScrollPane(previewLabel), BorderLayout.CENTER);
		previewLabel.setBackground(Color.white);
		previewLabel.setForeground(Color.black);
		previewLabel.setFont(fonts[0]);
		
		bgcolor.setToolTipText("Background color");
		bgcolor.setForeground(Color.white);
		bgcolor.setBackground(invert(Color.white));
		bgcolor.addActionListener(this);
		fgcolor.setToolTipText("Foreground color");
		fgcolor.setForeground(Color.black);
		fgcolor.setBackground(invert(Color.black));
		fgcolor.addActionListener(this);
		
		JPanel options = new JPanel();
		options.add(fontstyle_bold); 
		fontstyle_bold.addChangeListener(this);
		options.add(fontstyle_italic);
		fontstyle_italic.addChangeListener(this);
		options.add(bgcolor);
		options.add(fgcolor);
		options.add(fontsize);
		fontsize.addChangeListener(this);
		fontsize.setValue(previewLabel.getFont().getSize());
		getContentPane().add(options, BorderLayout.NORTH);
		
		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		buttons.add(screenPreview_btn);
		screenPreview_btn.addActionListener(this);
		buttons.add(print_btn);
		print_btn.addActionListener(this);
		print_btn.setToolTipText("Accept all settings and generate comparison");
		getContentPane().add(buttons, BorderLayout.SOUTH);
		
		pack();
		setVisible(true);
	}

	public void stateChanged(ChangeEvent e) {
		Object src = e.getSource();
		if(src.equals(fontsize)) {
			previewLabel.setFont( 
					previewLabel.getFont().deriveFont((float)fontsize.getValue())
			);
			fontsize.setToolTipText("Fontsize: " + fontsize.getValue());
		}
		else if(src.equals(fontstyle_bold) || src.equals(fontstyle_italic)) {
			int style = 0;
			if(fontstyle_bold.isSelected())
				style = Font.BOLD;
			if(fontstyle_italic.isSelected())
				style += Font.ITALIC;
			if(style == 0) style = Font.PLAIN;
			previewLabel.setFont(
					previewLabel.getFont().deriveFont(style)
			);
		}
	}
	
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
		if(src.equals(bgcolor)) {
			Color color = JColorChooser.showDialog(
					this, "Select background color", previewLabel.getBackground());
			if(color != null) {
				bgcolor.setForeground(color);
				bgcolor.setBackground(invert(color));
				previewLabel.setBackground(color);
			}
		}
		else if(src.equals(fgcolor)) {
			Color color = JColorChooser.showDialog(
					this, "Select foreground color", previewLabel.getForeground());
			if(color != null) {
				fgcolor.setForeground(color);
				fgcolor.setBackground(invert(color));
				previewLabel.setForeground(color);
			}
		}
		else if(src.equals(print_btn)) {
			new FontPrinter(f, previewLabel.getBackground(), previewLabel.getForeground(), 
					(float)fontsize.getValue(), previewLabel.getFont().getStyle(), 
					previewLabel.getText(), new java.awt.Frame());
		}
		else if(src.equals(screenPreview_btn)) {
			new FontWindow(f, previewLabel.getBackground(), previewLabel.getForeground(), 
					(float)fontsize.getValue(), previewLabel.getFont().getStyle(), 
					previewLabel.getText());
			setVisible(false);
		}
	}
	
	public Color invert(Color origin) {
		return new Color( origin.getRGB() ^ 0xFFFFFF );
	}
}
