/*
 * Created on 01.10.2006
 */
package updater;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.swing.JOptionPane;

import de.ssfuture.tools.updater.ClearTMP;
import de.ssfuture.tools.updater.DefaultConsoleLogging;
import de.ssfuture.tools.updater.Pack;

/**
 * @author Sebastian Schleemilch
 */
public class FinalUpdate {

	public static void main(String[] args) {
		if(args.length != 1)
			System.exit(1);
		try {
			Thread.currentThread().sleep(2000);
		} catch (InterruptedException e1) {}
		TextAreaLogger log = new TextAreaLogger();
		JOptionPane.showMessageDialog(log, 
				"<html>Now the update will be installed.<br>" +
				"This may take a few minutes - please stand by!</html>");
		try {
			log.headlineLog("Updater: Pack " + args[0]);
			Pack pk = new Pack(args[0], "de.ssfuture.tools.jfonttools.JFontTools", 8, log);
			log.headlineLog(">>Finished");
			log.setTitle(">Finished, close window");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(log, "Error! File not found!");
			log.defaultLog(e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(log, "Error! Input/Output error!");
			log.defaultLog(e.getMessage());
		}
		JOptionPane.showMessageDialog(log, 
				"<html><h1>Congratulations!</h1><br>" +
				"Now the update files are installed!<br>" +
				"At the next time of starting the software, the update is already included.</html>");
		log.setDefaultCloseOperation(TextAreaLogger.EXIT_ON_CLOSE);
	}
}
