/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.examples.rmi;

import com.hbworks.dirpane.FileSystem;
import com.hbworks.examples.rmi.RemoteFileSystem;
import java.io.File;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;

public class ClientFileSystem
extends FileSystem {
    private RemoteFileSystem server;
    private static String hostname;

    public static void setHostname(String name) {
        hostname = name;
    }

    public ClientFileSystem() {
        try {
            this.server = (RemoteFileSystem)Naming.lookup("//" + hostname + "/RemoteFileSystem");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public File getHomeDirectory() {
        return this.getFileSystemRoot();
    }

    public File getWorkingDirectory() {
        return this.getFileSystemRoot();
    }

    public void setFileSubType(Class type) {
    }

    public String getFileSeparator() {
        String separator = null;
        try {
            separator = this.server.getFileSeparator();
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return separator;
    }

    public Class getFileSubType() {
        Class type = null;
        try {
            type = this.server.getFileSubType();
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return type;
    }

    public File createFileObject(String path) {
        File file = null;
        try {
            file = this.server.createFileObject(path);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public File createFileObject(String path, String filename) {
        File file = null;
        try {
            file = this.server.createFileObject(path, filename);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public File createFileObject(File dir, String path) {
        File file = null;
        try {
            file = this.server.createFileObject(dir, path);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        File[] files;
        File[] empty = new File[]{};
        try {
            files = this.server.getFiles(dir, useFileHiding);
        }
        catch (RemoteException ex) {
            files = empty;
            System.out.println(ex.toString());
        }
        return files;
    }

    public File getParentDirectory(File dir) {
        File file = null;
        try {
            file = this.server.getParentDirectory(dir);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public boolean isHiddenFile(File f) {
        boolean flag = false;
        try {
            flag = this.server.isHiddenFile(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isFileSystemRoot(File f) {
        boolean flag = false;
        try {
            flag = this.server.isFileSystemRoot(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public File getFileSystemRoot() {
        File file = null;
        try {
            file = this.server.getFileSystemRoot();
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public int getDirectoryType(File dir) {
        int type = 3;
        int serverType = -1;
        try {
            serverType = this.server.getDirectoryType(dir);
            switch (serverType) {
                case 0: {
                    type = 0;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 1;
                    break;
                }
                default: {
                    type = 3;
                    break;
                }
            }
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return type;
    }

    public File loadIntoFileSystem(Object obj, File parentDir, boolean overwritePermissionGranted) throws IOException {
        File file = null;
        try {
            file = this.server.loadIntoFileSystem(obj, parentDir, overwritePermissionGranted);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return file;
    }

    public Object retrieveFromFileSystem(File holder) throws IOException {
        Object obj = null;
        try {
            obj = this.server.retrieveFromFileSystem(holder);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return obj;
    }

    public boolean doesFileExist(File f) {
        boolean flag = false;
        try {
            flag = this.server.doesFileExist(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isReadOnly(File f) {
        boolean flag = false;
        try {
            flag = this.server.isReadOnly(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isProtected(File f) {
        boolean flag = false;
        try {
            flag = this.server.isProtected(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isTraversable(File f) {
        boolean flag = false;
        try {
            flag = this.server.isTraversable(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isRegularFile(File f) {
        boolean flag = false;
        try {
            flag = this.server.isRegularFile(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean isAbsolute(File f) {
        boolean flag = false;
        try {
            flag = this.server.isAbsolute(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public long getLength(File f) {
        long len = 0L;
        try {
            len = this.server.getLength(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return len;
    }

    public String getAbsolutePath(File f) {
        String path = null;
        try {
            path = this.server.getAbsolutePath(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return path;
    }

    public String getCanonicalPath(File f) {
        String path = null;
        try {
            path = this.server.getCanonicalPath(f);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return path;
    }

    public long getLastModifiedTime(File f) {
        long len = 0L;
        try {
            len = this.server.getLastModifiedTime(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return len;
    }

    public boolean createDirectory(File f) {
        boolean flag = false;
        try {
            flag = this.server.createDirectory(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean createDirectories(File f) {
        boolean flag = false;
        try {
            flag = this.server.createDirectories(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean deleteFile(File f) {
        boolean flag = false;
        try {
            flag = this.server.deleteFile(f);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }

    public boolean renameFile(File f, File dest) {
        boolean flag = false;
        try {
            flag = this.server.renameFile(f, dest);
        }
        catch (RemoteException ex) {
            System.out.println(ex.toString());
        }
        return flag;
    }
}

