/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.metal;

import com.hbworks.dirpane.plaf.basic.BasicPaneTreeUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreePath;

public class MetalPaneTreeUI
extends BasicPaneTreeUI {
    private static Color lineColor;
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private PropertyChangeListener lineStyleListener = new LineListener();

    public static ComponentUI createUI(JComponent t) {
        return new MetalPaneTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return 4;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        lineColor = UIManager.getColor("Tree.line");
        Object lineStyleFlag = c.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(lineStyleFlag);
        c.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(c);
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
        if (lineStyleFlag == null || lineStyleFlag.equals(NO_STYLE_STRING)) {
            this.lineStyle = 0;
        } else if (lineStyleFlag.equals(LEG_LINE_STYLE_STRING)) {
            this.lineStyle = 2;
        } else if (lineStyleFlag.equals(HORIZ_STYLE_STRING)) {
            this.lineStyle = 1;
        }
    }

    protected boolean isLocationInExpandControl(int row, int rowLevel, int mouseX, int mouseY) {
        if (this.tree != null && !this.isLeaf(row)) {
            int boxWidth = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() + 6 : 8;
            Insets i = this.tree.getInsets();
            int boxLeftX = i != null ? i.left : 0;
            int boxRightX = (boxLeftX += (rowLevel + this.depthOffset - 1) * this.totalChildIndent + this.getLeftChildIndent() - boxWidth / 2) + boxWidth;
            return mouseX >= boxLeftX && mouseX <= boxRightX;
        }
        return false;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(g, c);
        }
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
        g.setColor(lineColor);
        Rectangle clipBounds = g.getClipBounds();
        int beginRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y));
        int endRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y + clipBounds.height - 1));
        if (beginRow <= -1 || endRow <= -1) {
            return;
        }
        int i = beginRow;
        while (i <= endRow) {
            Rectangle rowBounds;
            TreePath path = this.getPathForRow(this.tree, i);
            if (path != null && path.getPathCount() == 2 && (rowBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) != null) {
                g.drawLine(clipBounds.x, rowBounds.y, clipBounds.x + clipBounds.width, rowBounds.y);
            }
            ++i;
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(MetalPaneTreeUI.LINE_STYLE)) {
                MetalPaneTreeUI.this.decodeLineStyle(e.getNewValue());
            }
        }
    }
}

