/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.TreeDirectoryPane;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TreeFilenameField
extends JTextField
implements TreeSelectionListener {
    static final long serialVersionUID = 7531508663199413172L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    int maxHeight = 22;
    TreeDirectoryPane pane;
    String name;
    File[] selectedFiles;
    String multipleFileDelimiter = "\"";

    public TreeFilenameField() {
        this((TreeDirectoryPane)null);
    }

    public TreeFilenameField(TreeDirectoryPane pane) {
        if (pane != null) {
            this.pane = pane;
            pane.addTreeSelectionListener(this);
            pane.addPropertyChangeListener(new DirectoryChangedListener());
        }
    }

    public void setDirectoryPane(TreeDirectoryPane newpane) {
        TreeDirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        if (!(newpane instanceof TreeDirectoryPane)) {
            throw new IllegalArgumentException("Wrong type : new pane must be a TreeDirectoryPane");
        }
        TreeDirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.pane.addTreeSelectionListener(this);
        this.pane.addPropertyChangeListener(new DirectoryChangedListener());
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public TreeDirectoryPane getDirectoryPane() {
        return this.pane;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, this.maxHeight);
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        return new Dimension(d.width, this.maxHeight);
    }

    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        return new Dimension(d.width, this.maxHeight);
    }

    public String getMultipleFileDelimiter() {
        return this.multipleFileDelimiter;
    }

    public void setMultipleFileDelimiter(String delimiter) {
        this.multipleFileDelimiter = delimiter;
    }

    public void setSelectedFiles(File[] files) {
        if (files == null) {
            this.selectedFiles = new File[0];
            this.setText("");
        } else {
            Vector<File> v = new Vector<File>();
            StringBuffer buf = new StringBuffer();
            String delim = this.multipleFileDelimiter + " " + this.multipleFileDelimiter;
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (this.pane.getFileSelectionMode() == 1 && this.pane.isTraversable(f)) {
                    v.addElement(f);
                    buf.append(this.pane.getName(f) + delim);
                } else if (!this.pane.isTraversable(f)) {
                    v.addElement(f);
                    buf.append(this.pane.getName(f) + delim);
                }
                ++i;
            }
            int l = buf.length() - delim.length();
            buf.setLength(l < 0 ? 0 : l);
            Object[] filesBuf = new File[v.size()];
            v.copyInto(filesBuf);
            this.selectedFiles = filesBuf;
            this.setText(new String(buf));
        }
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return this.selectedFiles;
    }

    public void valueChanged(TreeSelectionEvent ignored) {
        this.setSelectedFiles(this.pane.getSelectedFiles());
    }

    class DirectoryChangedListener
    implements PropertyChangeListener {
        DirectoryChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "directoryChanged" || name == "syncSlaveDirectory") {
                TreeFilenameField.this.setSelectedFiles(null);
            }
        }
    }
}

