/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.AcceptAllFileFilter;
import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.FileFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class FilterComboBox
extends JComboBox {
    static final long serialVersionUID = 7258789538782540667L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    DirectoryPane pane;
    FilterComboBoxModel model;

    public FilterComboBox() {
        this((DirectoryPane)null);
    }

    public FilterComboBox(DirectoryPane pane) {
        this.setRenderer(new FilterComboBoxRenderer());
        this.setMaximumRowCount(7);
        if (pane != null) {
            this.pane = pane;
            this.model = new FilterComboBoxModel();
            this.setModel(this.model);
            this.addActionListener(new ComboActionListener());
            pane.addPropertyChangeListener(this.model);
            this.model.setSelectedItem(pane.getFileFilter());
        }
    }

    public void setDirectoryPane(DirectoryPane newpane) {
        DirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        DirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.model = new FilterComboBoxModel();
        this.setModel(this.model);
        this.addActionListener(new ComboActionListener());
        this.pane.addPropertyChangeListener(this.model);
        this.model.setSelectedItem(this.pane.getFileFilter());
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public DirectoryPane getDirectoryPane() {
        return this.pane;
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        public void actionPerformed(ActionEvent ignored) {
            FileFilter filter = (FileFilter)FilterComboBox.this.model.getSelectedItem();
            if (filter != null) {
                FilterComboBox.this.pane.setFileFilter(filter);
            }
        }
    }

    class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private FileFilter[] filters;
        private FileFilter selection;

        public FilterComboBoxModel() {
            FileFilter[] f = FilterComboBox.this.pane.getChoosableFileFilters();
            this.orderFilters(f);
        }

        private void orderFilters(FileFilter[] f) {
            Vector<FileFilter> v = new Vector<FileFilter>();
            v.addElement(FilterComboBox.this.pane.getAcceptAllFileFilter());
            int i = 0;
            while (i < f.length) {
                if (!(f[i] instanceof AcceptAllFileFilter)) {
                    v.addElement(f[i]);
                }
                ++i;
            }
            this.filters = new FileFilter[v.size()];
            v.copyInto(this.filters);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "choosableFileFilterChangedProperty") {
                FileFilter[] f = (FileFilter[])e.getNewValue();
                this.orderFilters(f);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object selection) {
            this.selection = (FileFilter)selection;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return FilterComboBox.this.pane.getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        FilterComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            if (filter != null) {
                this.setText(filter.getDescription());
            }
            return this;
        }
    }
}

