import java.io.*;
import java.net.*;
import java.util.zip.*;
import java.applet.*;

public class filecopy {

 public static void main(String[] args) {
// Test if parameters have been specified
   filecopy f = new filecopy();
   String infilename=new String("InputFile");
   int argoff=0;
   for (int i=0;i<args.length;i++) {
     if (args[i].equalsIgnoreCase("-help")||args[i].equalsIgnoreCase("-h")||args[i].equalsIgnoreCase("-?")) {
     System.out.println("Usage: filecopy [-skip <bytes>] [-byte <value>] [-q] [-qq] InputFile OutputFile");
     System.out.println("");
     System.out.println("-skip <bytes> Defines how many bytes should be skipped if a read error occurs.");
     System.out.println("-byte <value> Defines the value to be inserted where the read error occurs.");
     System.out.println("-q            Quiet. Does not show pregress indicator.");
     System.out.println("-qq           Extra Quiet. Does not show pregress indicator or errors.");
     System.out.println("InputFile     The filename of the file to be read.");
     System.out.println("OutputFile    The filename to write the result to.");
     System.out.println("");
     System.out.println("Filecopy was written in 1999 by Klaus Post, aka sh0dan of VoxPod.");
     System.out.println("email: sh0dan@voxpod.dk");
     System.out.println("");
     System.exit(0);
     }
     System.out.println("");
     if (args[i].equalsIgnoreCase("-skip")) {
       if (i==(args.length-1)) {
         System.out.println("Error: -skip must be followed by a value");
         System.out.println("Setting skip to 128 bytes");
         argoff++;
       } else {
         try {
           defskip=Integer.parseInt(args[argoff+1]);
         } catch (NumberFormatException n) {
           System.out.println("Error: -skip must be followed by a value");
           System.out.println("Setting skip to 128 bytes");
           defskip=128;
           argoff--;
         }
         if (defskip<=0) {
            System.out.println("Warning: -skip must have a value bigger than 0.");
            System.out.println("Setting skip to 128 bytes");
            defskip=128;
         }
         argoff+=2;
       }
     }
     if (args[i].equalsIgnoreCase("-byte")) {
       if (i==(args.length-1)) {
         System.out.println("Error: -byte must be followed by a value");
         argoff++;
       } else {
         try {
           defbyte=Integer.parseInt(args[argoff+1]);
         } catch (NumberFormatException n) {
            System.out.println("Error: -byte must be followed by a value");
            argoff--;
            defbyte=0;
         }
         if (defbyte<0 || defbyte>255) {
            System.out.println("Error: -byte must have a value bigger than 0 and less than 255.");
            System.exit(1);
         }
         argoff+=2;
       }
     }
     if (args[i].equalsIgnoreCase("-q")) {
       quiet=1;
       argoff++;
     }
     if (args[i].equalsIgnoreCase("-qq")) {
       quiet=2;
       argoff++;
     }
   }
   if (args.length>argoff) {
     infilename=new String(args[argoff]);
     argoff++;
   } else {
     System.out.println("You must specify an InputFile");
     System.exit(1);
   }
   String outfilename=new String(infilename+"_out");
   if (args.length>argoff) {
     outfilename=new String(args[argoff]);
     argoff++;
   }
   f.doit(infilename,outfilename);
 }
   static int quiet=0;
   File ifile;
   File ofile;
   File dofile;
   File lfile;
   FileInputStream fis;
   FileInputStream lfis;
   FileInputStream raf;
   BufferedInputStream bis;
   BufferedInputStream lbis;
   FileOutputStream fos;
   FileOutputStream dfos;
   BufferedOutputStream bos;
   BufferedOutputStream dbos;
   StringBuffer name;
   StringBuffer chars;
   int files;
   int out;
   static int defbyte=0;
   static int defskip=128;

 public void doit(String infile, String outfile) {
   try {
   System.out.println("Engaging sh0/filecopy v0.02y+  by sh0dan/VoxPod 1999.");
   System.out.println("");
// Everything should be OK now! Create Inputstreams

     lfile = new File(infile);

     File datafile = new File(outfile);

     dfos = new FileOutputStream(datafile);
     dbos = new BufferedOutputStream(dfos);
     raf = new FileInputStream(lfile);
     bis = new BufferedInputStream(raf);
     data=bis.read();
     out=1;
     if (quiet <2) {
       System.out.println("Copying data.");
     }
     do {
       dbos.write(data);
       out++;
       if (out%1024==0)  {
         if (quiet <1) System.out.print("#");
         if (out%(32*1024)==0)  {
           System.gc();
         }
       }
       try {
         data=bis.read();
       } catch (IOException ex) {
         data=defbyte;
         if (quiet <2)
           System.out.println("Read failed at byte "+out+"; Reopening file with offset "+defskip+"!");
         skipread(lfile,dbos,out);
         out+=defskip;
       }
     } while (data!=-1);

     dbos.flush();
     dfos.flush();
     dbos.close();
     dfos.close();

   } catch (IOException ex) {
     System.out.println("Unexpected IO-exception in main:"+ex);
     ex.printStackTrace();
     System.exit(2);
   }

 }

   static int data;

 private void skipread(File infile, OutputStream out, int offset) throws IOException {
   raf = new FileInputStream(lfile);
   raf.skip((long)(offset+defskip));
   bis = new BufferedInputStream(raf);
   try {
     data=bis.read();
     if (quiet <2)
      System.out.println("Read succesful after skip - reading bytes indiviudally!");
   } catch (IOException ex) {
     if (quiet <2)
       System.out.println("Read failed after skip - filling with default bytes!");
      for (int i=0;i<defskip;i++) {
         dbos.write(defbyte);
      }
      return;
   }
   for (int i=0;i<defskip;i++) {
      raf = new FileInputStream(lfile);
      raf.skip((long)(offset+i));
      bis = new BufferedInputStream(raf);
      try {
        data=bis.read();
        if (data==-1) return;
        if (quiet <1)
          System.out.print("+");
        dbos.write(data);
      } catch (IOException ex) {
       if (quiet <1)
           System.out.print("-");
         dbos.write(defbyte);
      }
   }
 }
}

