/*
 * Decompiled with CFR 0.152.
 */
package JDiskCat;

import JDiskCat.Main;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SearchWindow
extends JFrame {
    private String selected;
    private DefaultTableModel tableModel;
    private Vector columns;
    private Vector data;
    private DocumentBuilder loader;
    private Document document;
    private Node root;
    private String pattern;
    private Boolean allDisks = false;
    private Vector diskList;
    private String sizeRestrictMode = "Any";
    private String dateRestrictMode = "Any";
    private long size1 = 0L;
    private long size2 = 0L;
    private Date sqlDate1;
    private Date sqlDate2;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JComboBox jComboBox5;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPopupMenu jPopupMenu1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane2;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private static JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;

    public SearchWindow() {
        this.initComponents();
        this.columns = new Vector(3);
        this.columns.add("Name");
        this.columns.add("Size");
        this.columns.add("Date");
        this.columns.add("Volume");
        this.columns.add("Location");
        this.tableModel = new DefaultTableModel();
        jTable1.setModel(this.tableModel);
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.diskList = new Vector();
        this.refreshDiskList();
        Dimension dialogSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.height = screenSize.width;
        }
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jButton1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        jTable1 = new JTable();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jComboBox1 = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jComboBox2 = new JComboBox();
        this.jTextField2 = new JTextField();
        this.jComboBox4 = new JComboBox();
        this.jTextField3 = new JTextField();
        this.jComboBox5 = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jSpinner2 = new JSpinner();
        this.jSpinner1 = new JSpinner();
        this.jComboBox3 = new JComboBox();
        this.jPopupMenu1.setEnabled(false);
        this.jMenuItem1.setText("Open");
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchWindow.this.jMenuItem1MouseReleased(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Open containing folder");
        this.jMenuItem2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchWindow.this.jMenuItem2MouseReleased(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem2);
        this.setTitle("Search");
        this.jButton1.setFont(new Font("Tahoma", 1, 11));
        this.jButton1.setText("Search");
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchWindow.this.jButton1MouseReleased(evt);
            }
        });
        this.jButton1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchWindow.this.jButton1KeyReleased(evt);
            }
        });
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setDoubleBuffered(true);
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[3]}, new String[]{"Nazwa", "Wielko\u015b\u0107", "Data"}));
        jTable1.setAutoResizeMode(1);
        jTable1.setComponentPopupMenu(this.jPopupMenu1);
        jTable1.setDoubleBuffered(true);
        jTable1.setEditingColumn(0);
        jTable1.setEditingRow(0);
        jTable1.setFillsViewportHeight(true);
        jTable1.setFocusable(false);
        jTable1.setGridColor(new Color(255, 255, 255));
        jTable1.setIntercellSpacing(new Dimension(0, 0));
        jTable1.setShowHorizontalLines(false);
        jTable1.setShowVerticalLines(false);
        jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SearchWindow.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(jTable1);
        this.jButton2.setText("Close");
        this.jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchWindow.this.jButton2MouseReleased(evt);
            }
        });
        this.jButton2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchWindow.this.jButton2KeyReleased(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Phrase"));
        this.jTextField1.setToolTipText("<html>Search phrase should be at least 2 characters long. Case is ignored. You may leave this field empty if you want to search by size or date.<br>Literal search (using quotes): \"search phrase\"<br>Search using keywords (separated by spaces): keyword1 keyword2</html>");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchWindow.this.jTextField1KeyReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextField1, -2, 20, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Search locations"));
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Volume");
        this.jRadioButton1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SearchWindow.this.jRadioButton1StateChanged(evt);
            }
        });
        this.jRadioButton2.setText("All volumes");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jRadioButton2, GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButton1).addGap(3, 3, 3).addComponent(this.jComboBox1, -2, 140, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Size"));
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Any", "<", "<=", "=", ">=", ">", "Between"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setPreferredSize(new Dimension(50, 19));
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"B", "kB", "MB", "GB"}));
        this.jComboBox4.setEnabled(false);
        this.jTextField3.setEditable(false);
        this.jTextField3.setPreferredSize(new Dimension(50, 19));
        this.jComboBox5.setModel(new DefaultComboBoxModel<String>(new String[]{"B", "kB", "MB", "GB"}));
        this.jComboBox5.setEnabled(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox2, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextField3, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox5, -2, -1, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jComboBox5, -2, -1, -2)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Date"));
        this.jSpinner2.setModel(new SpinnerDateModel());
        this.jSpinner2.setToolTipText("Date in DD-MM-YY HH-MM format");
        this.jSpinner2.setEnabled(false);
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setToolTipText("Date in DD-MM-YY HH-MM format");
        this.jSpinner1.setEnabled(false);
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"Any", "<", "<=", "=", ">=", ">", "Between"}));
        this.jComboBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.jComboBox3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox3, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSpinner2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jSpinner1, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -2, 100, -2).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -2, 100, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel4, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 386, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.prepareSearch();
        }
    }

    private void jButton2MouseReleased(MouseEvent evt) {
        this.setVisible(false);
    }

    private void jRadioButton1StateChanged(ChangeEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            this.allDisks = false;
            this.jComboBox1.setEnabled(true);
        } else {
            this.allDisks = true;
            this.jComboBox1.setEnabled(false);
        }
    }

    private void jButton2KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setVisible(false);
        }
    }

    private void jButton1KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.prepareSearch();
        }
    }

    private void jButton1MouseReleased(MouseEvent evt) {
        this.prepareSearch();
    }

    private void jMenuItem1MouseReleased(MouseEvent evt) {
        int row = jTable1.getSelectedRow();
        System.out.println(row);
        if (row != -1 && jTable1.getValueAt(row, 1).toString().length() > 1) {
            try {
                String filePath;
                this.document = this.loader.parse(String.valueOf(jTable1.getValueAt(row, 3).toString()) + ".xml");
                this.root = this.document.getLastChild();
                Element rootElement = (Element)this.root;
                String rootPath = rootElement.getAttribute("path");
                String fileName = jTable1.getValueAt(row, 0).toString();
                String volumeName = jTable1.getValueAt(row, 3).toString();
                if (rootPath.trim().length() == 3) {
                    filePath = (String)jTable1.getValueAt(row, 4);
                    filePath = String.valueOf(rootPath) + filePath.substring(1) + "\\" + fileName;
                } else {
                    filePath = (String)jTable1.getValueAt(row, 4);
                    if (filePath.equals("\\")) {
                        filePath = "";
                    }
                    filePath = String.valueOf(rootPath) + filePath + "\\" + fileName;
                }
                if (filePath.indexOf("/") != -1) {
                    filePath = filePath.replace('\\', '/');
                }
                System.out.println(filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            desktop.open(file);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog(this, "An error occurred while opening the file. Most likely, no application is associated with that file type.", "Error opening the file.", 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The requested item is not available. Check availability of the volume: \"" + volumeName + "\".", "Error", 0);
                }
            }
            catch (SAXException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jMenuItem2MouseReleased(MouseEvent evt) {
        int row = jTable1.getSelectedRow();
        if (row != -1 && jTable1.getValueAt(row, 1).toString().length() > 1) {
            try {
                String filePath;
                this.document = this.loader.parse(String.valueOf(jTable1.getValueAt(row, 3).toString()) + ".xml");
                this.root = this.document.getLastChild();
                Element rootElement = (Element)this.root;
                String volumeName = jTable1.getValueAt(row, 3).toString();
                String rootPath = rootElement.getAttribute("path");
                if (rootPath.trim().length() == 3) {
                    filePath = (String)jTable1.getValueAt(row, 4);
                    filePath = String.valueOf(rootPath) + filePath.substring(1);
                } else {
                    filePath = (String)jTable1.getValueAt(row, 4);
                    if (filePath.equals("\\")) {
                        filePath = "";
                    }
                    filePath = String.valueOf(rootPath) + filePath;
                }
                if (filePath.indexOf("/") != -1) {
                    filePath = filePath.replace('\\', '/');
                }
                System.out.println(filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            desktop.open(file);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog(this, "An error occurred while opening the folder.", "Error opening folder.", 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The requested folder is not available. Check availability of the volume: \"" + volumeName + "\".", "Error opening folder.", 0);
                }
            }
            catch (SAXException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jTable1MousePressed(MouseEvent evt) {
        Point p = evt.getPoint();
        int row = jTable1.rowAtPoint(p);
        if (row != -1) {
            ListSelectionModel model = jTable1.getSelectionModel();
            model.setSelectionInterval(row, row);
            jTable1.setComponentPopupMenu(this.jPopupMenu1);
        } else {
            ListSelectionModel model = jTable1.getSelectionModel();
            model.clearSelection();
            jTable1.setComponentPopupMenu(null);
        }
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.sizeRestrictMode = this.jComboBox2.getSelectedItem().toString().trim();
        System.out.println(this.sizeRestrictMode);
        if (this.sizeRestrictMode.equals("Any")) {
            this.jTextField2.setEditable(false);
            this.jComboBox4.setEnabled(false);
            this.jTextField3.setEditable(false);
            this.jComboBox5.setEnabled(false);
        } else if (this.sizeRestrictMode.equals("Between")) {
            this.jTextField2.setEditable(true);
            this.jComboBox4.setEnabled(true);
            this.jTextField3.setEditable(true);
            this.jComboBox5.setEnabled(true);
        } else {
            this.jTextField2.setEditable(true);
            this.jComboBox4.setEnabled(true);
            this.jTextField3.setEditable(false);
            this.jComboBox5.setEnabled(false);
        }
    }

    private void jComboBox3ActionPerformed(ActionEvent evt) {
        this.dateRestrictMode = this.jComboBox3.getSelectedItem().toString().trim();
        System.out.println(this.dateRestrictMode);
        if (this.dateRestrictMode.equals("Any")) {
            this.jSpinner1.setEnabled(false);
            this.jSpinner2.setEnabled(false);
        } else if (this.dateRestrictMode.equals("Between")) {
            this.jSpinner1.setEnabled(true);
            this.jSpinner2.setEnabled(true);
        } else {
            this.jSpinner1.setEnabled(true);
            this.jSpinner2.setEnabled(false);
        }
    }

    private void readDisk(String filename) {
        try {
            this.document = this.loader.parse(filename);
            this.root = this.document.getLastChild();
            this.search(this.root, "\\");
        }
        catch (SAXException ex) {
            Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void search(Node dir, String path) {
        NodeList list = dir.getChildNodes();
        Vector<String> row = new Vector<String>(3);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element) {
                int j;
                String[] patterns;
                String noQuotes;
                Element child = (Element)node;
                String attribName = child.getAttribute("name");
                String attribDate = child.getAttribute("date");
                String attribSize = child.getAttribute("size");
                Boolean itemFound = false;
                Boolean itemFoundByName = false;
                Boolean itemFoundBySize = false;
                Boolean itemFoundByDate = false;
                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                }
                if (this.pattern.length() > 1 && this.sizeRestrictMode.equals("Any") && this.dateRestrictMode.equals("Any")) {
                    if (this.pattern.startsWith("\"") && this.pattern.endsWith("\"")) {
                        noQuotes = this.pattern.substring(1, this.pattern.length() - 1);
                        patterns = new String[]{noQuotes};
                    } else {
                        patterns = this.pattern.split(" ");
                    }
                    itemFound = true;
                    j = 0;
                    while (j < patterns.length) {
                        if (attribName.toLowerCase().indexOf(patterns[j].toLowerCase()) == -1) {
                            itemFound = false;
                        }
                        ++j;
                    }
                }
                if (!this.sizeRestrictMode.equals("Any") && !attribSize.equals("<DIR>")) {
                    if (this.pattern.length() > 1) {
                        if (this.pattern.startsWith("\"") && this.pattern.endsWith("\"")) {
                            noQuotes = this.pattern.substring(1, this.pattern.length() - 1);
                            patterns = new String[]{noQuotes};
                        } else {
                            patterns = this.pattern.split(" ");
                        }
                        itemFoundByName = true;
                        j = 0;
                        while (j < patterns.length) {
                            if (attribName.toLowerCase().indexOf(patterns[j].toLowerCase()) == -1) {
                                itemFoundByName = false;
                            }
                            ++j;
                        }
                    }
                    Long itemSize = Long.parseLong(attribSize);
                    if (this.sizeRestrictMode.equals("<")) {
                        itemFoundBySize = itemSize < this.size1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.sizeRestrictMode.equals("<=")) {
                        itemFoundBySize = itemSize <= this.size1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.sizeRestrictMode.equals("=")) {
                        itemFoundBySize = itemSize == this.size1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.sizeRestrictMode.equals(">=")) {
                        itemFoundBySize = itemSize >= this.size1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.sizeRestrictMode.equals(">")) {
                        itemFoundBySize = itemSize > this.size1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.sizeRestrictMode.equals("Between")) {
                        itemFoundBySize = itemSize >= this.size1 && itemSize <= this.size2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                }
                if (!this.dateRestrictMode.equals("Any")) {
                    if (this.pattern.length() > 1) {
                        if (this.pattern.startsWith("\"") && this.pattern.endsWith("\"")) {
                            noQuotes = this.pattern.substring(1, this.pattern.length() - 1);
                            patterns = new String[]{noQuotes};
                        } else {
                            patterns = this.pattern.split(" ");
                        }
                        itemFoundByName = true;
                        int j2 = 0;
                        while (j2 < patterns.length) {
                            if (attribName.toLowerCase().indexOf(patterns[j2].toLowerCase()) == -1) {
                                itemFoundByName = false;
                            }
                            ++j2;
                        }
                    }
                    Date itemDate = this.toSqlDate(attribDate);
                    if (this.dateRestrictMode.equals("<")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) < 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.dateRestrictMode.equals("<=")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) <= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.dateRestrictMode.equals("=")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.dateRestrictMode.equals(">=")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) >= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.dateRestrictMode.equals(">")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (this.dateRestrictMode.equals("Between")) {
                        itemFoundByDate = itemDate.compareTo(this.sqlDate1) >= 0 && itemDate.compareTo(this.sqlDate2) <= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                }
                if (!this.sizeRestrictMode.equals("Any") && !this.dateRestrictMode.equals("Any")) {
                    if (this.pattern.length() > 1) {
                        if (itemFoundByName.booleanValue() && itemFoundBySize.booleanValue() && itemFoundByDate.booleanValue()) {
                            itemFound = true;
                        }
                    } else if (itemFoundBySize.booleanValue() && itemFoundByDate.booleanValue()) {
                        itemFound = true;
                    }
                }
                if (!this.sizeRestrictMode.equals("Any") && this.dateRestrictMode.equals("Any")) {
                    if (this.pattern.length() > 1) {
                        if (itemFoundByName.booleanValue() && itemFoundBySize.booleanValue()) {
                            itemFound = true;
                        }
                    } else if (itemFoundBySize.booleanValue()) {
                        itemFound = true;
                    }
                }
                if (this.sizeRestrictMode.equals("Any") && !this.dateRestrictMode.equals("Any")) {
                    if (this.pattern.length() > 1) {
                        if (itemFoundByName.booleanValue() && itemFoundByDate.booleanValue()) {
                            itemFound = true;
                        }
                    } else if (itemFoundByDate.booleanValue()) {
                        itemFound = true;
                    }
                }
                if (itemFound.booleanValue()) {
                    row = new Vector(3);
                    if (!attribSize.equals("<DIR>")) {
                        long size = Long.parseLong(attribSize);
                        attribSize = Main.sizeFormat(size);
                    }
                    if (attribSize.equals("<DIR>")) {
                        row.add(attribName);
                    } else {
                        row.add(attribName);
                    }
                    row.add(attribSize);
                    row.add(attribDate);
                    row.add(this.selected);
                    row.add(path);
                    this.data.add(row);
                }
                if (attribSize.equals("<DIR>")) {
                    if (path.equals("\\")) {
                        this.search(node, String.valueOf(path) + attribName);
                    } else {
                        this.search(node, String.valueOf(path) + "\\" + attribName);
                    }
                }
            }
            ++i;
        }
    }

    private void refreshDiskList() {
        this.jComboBox1.removeAllItems();
        int i = 0;
        while (i < Main.getDiskList().getSize()) {
            String name = Main.getDiskList().getElementAt(i).toString();
            this.jComboBox1.addItem(name);
            this.diskList.add(name);
            ++i;
        }
        if (Main.getSelectedIndex() != -1) {
            i = 0;
            while (i < this.jComboBox1.getItemCount()) {
                if (this.jComboBox1.getItemAt(i).toString().equals(Main.getSelected())) {
                    this.jComboBox1.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    private void prepareSearch() {
        this.selected = this.jComboBox1.getSelectedItem().toString();
        this.pattern = this.jTextField1.getText().trim();
        this.jTextField1.setText(this.pattern);
        Boolean ready = true;
        if (!this.sizeRestrictMode.equals("Any")) {
            try {
                this.size1 = Long.parseLong(this.jTextField2.getText().trim());
            }
            catch (Exception e) {
                this.jTextField2.setText("");
                ready = false;
                JOptionPane.showMessageDialog(this, "Enter valid size value.", "Size field 1", 0);
            }
            if (this.jComboBox4.getSelectedItem().equals("kB")) {
                this.size1 *= 1024L;
            }
            if (this.jComboBox4.getSelectedItem().equals("MB")) {
                this.size1 = this.size1 * 1024L * 1024L;
            }
            if (this.jComboBox4.getSelectedItem().equals("GB")) {
                this.size1 = this.size1 * 1024L * 1024L * 1024L;
            }
            System.out.println(this.size1);
            if (this.sizeRestrictMode.equals("Between")) {
                try {
                    this.size2 = Long.parseLong(this.jTextField3.getText().trim());
                }
                catch (Exception e) {
                    this.jTextField3.setText("");
                    ready = false;
                    JOptionPane.showMessageDialog(this, "Enter valid size value.", "Size field 2", 0);
                }
                if (this.jComboBox5.getSelectedItem().equals("kB")) {
                    this.size2 *= 1024L;
                }
                if (this.jComboBox5.getSelectedItem().equals("MB")) {
                    this.size2 = this.size2 * 1024L * 1024L;
                }
                if (this.jComboBox5.getSelectedItem().equals("GB")) {
                    this.size2 = this.size2 * 1024L * 1024L * 1024L;
                }
                System.out.println(this.size2);
            }
        }
        if (!this.dateRestrictMode.equals("Any")) {
            java.util.Date Date1 = (java.util.Date)this.jSpinner1.getValue();
            System.out.println(Date1);
            this.sqlDate1 = new Date(Date1.getTime());
            System.out.println(this.sqlDate1);
            java.util.Date Date2 = (java.util.Date)this.jSpinner2.getValue();
            System.out.println(Date2);
            this.sqlDate2 = new Date(Date2.getTime());
            System.out.println(this.sqlDate2);
        }
        if (!(!ready.booleanValue() || this.selected == null || this.selected.isEmpty() || this.pattern.length() <= 1 && this.sizeRestrictMode.equals("Any") && this.dateRestrictMode.equals("Any"))) {
            try {
                this.data = new Vector(3);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.loader = factory.newDocumentBuilder();
                if (!this.allDisks.booleanValue()) {
                    this.readDisk(String.valueOf(this.selected) + ".xml");
                } else {
                    int i = 0;
                    while (i < this.diskList.size()) {
                        this.selected = this.diskList.get(i).toString();
                        this.readDisk(String.valueOf(this.selected) + ".xml");
                        ++i;
                    }
                }
                if (!this.data.isEmpty()) {
                    this.tableModel = new DefaultTableModel(this.data, this.columns);
                    jTable1.setModel(this.tableModel);
                } else {
                    jTable1.setModel(new DefaultTableModel());
                }
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Date toSqlDate(String strDate) {
        Date sqlDate;
        SimpleDateFormat dateFrm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            java.util.Date myDate = dateFrm.parse(strDate);
            sqlDate = new Date(myDate.getTime());
        }
        catch (Exception e) {
            sqlDate = null;
            System.out.println("String to Date conversion error.");
        }
        return sqlDate;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SearchWindow().setVisible(true);
            }
        });
    }
}

