/*
 * Decompiled with CFR 0.152.
 */
package shared.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class JPicButton
extends JComponent {
    public static final int MOUSEBUTTON1 = 1;
    public static final int MOUSEBUTTON2 = 2;
    public static final int MOUSEBUTTON3 = 4;
    private ArrayList<ActionListener> m_actionListenersArray = new ArrayList();
    protected Image m_uImg;
    protected Image m_dImg;
    protected Image m_xuImg;
    protected Image m_xdImg;
    private boolean m_bEnabled;
    private boolean m_bDown;
    private boolean m_bLastDown;
    private boolean m_bToggleMode;
    private int m_buttonMask;
    private String m_actionCommand;
    private boolean m_bMouseDown = false;
    private String m_upPicFile;
    private String m_downPicFile;
    private String m_xupPicFile;
    private String m_xdownPicFile;
    private Object m_data = null;
    private Object m_interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;

    public JPicButton() {
        this.doInit(false);
    }

    public JPicButton(boolean bl) {
        this.doInit(bl);
    }

    private void doInit(boolean bl) {
        this.m_bEnabled = true;
        this.m_bDown = false;
        this.m_bLastDown = false;
        this.m_bToggleMode = bl;
        this.m_buttonMask = 1;
        this.m_bMouseDown = false;
        JPicButton jPicButton = this;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (JPicButton.this.m_bEnabled && (1 << mouseEvent.getButton() - 1 & JPicButton.this.m_buttonMask) != 0) {
                    JPicButton.this.m_bLastDown = JPicButton.this.m_bDown;
                    JPicButton.this.m_bDown = true;
                    JPicButton.this.m_bMouseDown = true;
                    JPicButton.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (JPicButton.this.m_bEnabled && JPicButton.this.m_bMouseDown) {
                    boolean bl = false;
                    Point point = mouseEvent.getPoint();
                    if (point.x >= 0 && point.x <= JPicButton.this.getWidth() && point.y >= 0 && point.y <= JPicButton.this.getHeight()) {
                        bl = true;
                    }
                    if ((1 << mouseEvent.getButton() - 1 & JPicButton.this.m_buttonMask) != 0) {
                        JPicButton.this.m_bDown = bl ? (JPicButton.this.m_bToggleMode ? !JPicButton.this.m_bLastDown : false) : JPicButton.this.m_bLastDown;
                        JPicButton.this.m_bMouseDown = false;
                        JPicButton.this.repaint();
                        if (bl) {
                            JPicButton.this.fireActionPerformed();
                        }
                    }
                }
            }
        });
    }

    public void setActionCommand(String string) {
        this.m_actionCommand = string;
    }

    public String getActionCommand() {
        return this.m_actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_actionListenersArray == null) {
            this.m_actionListenersArray = new ArrayList();
        }
        this.m_actionListenersArray.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.m_actionListenersArray != null) {
            int n = 0;
            for (ActionListener actionListener2 : this.m_actionListenersArray) {
                if (actionListener2.equals(actionListener)) {
                    this.m_actionListenersArray.remove(n);
                    return;
                }
                ++n;
            }
        }
    }

    protected void fireActionPerformed() {
        if (this.m_actionListenersArray != null && !this.m_actionListenersArray.isEmpty()) {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            int n = 0;
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            } else assert (false);
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.m_actionCommand, EventQueue.getMostRecentEventTime(), n);
            for (ActionListener actionListener : this.m_actionListenersArray) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public Image getUPic(boolean bl) {
        return bl ? this.m_uImg : this.m_xuImg;
    }

    public Image getDPic(boolean bl) {
        return bl ? this.m_dImg : this.m_xdImg;
    }

    public void setUPic(Image image, boolean bl) {
        if (bl) {
            this.m_uImg = image;
        } else {
            this.m_xuImg = image;
        }
    }

    public void setDPic(Image image, boolean bl) {
        if (bl) {
            this.m_dImg = image;
        } else {
            this.m_xdImg = image;
        }
    }

    public void setUPic(Image image) {
        this.setUPic(image, true);
    }

    public void setDPic(Image image) {
        this.m_dImg = image;
    }

    public void setXPic(Image image) {
        this.m_xuImg = this.m_xdImg = image;
    }

    public void setEnabledUpPicture(String string) {
        this.m_upPicFile = string;
        this.setUPic(Toolkit.getDefaultToolkit().createImage(this.m_upPicFile), true);
    }

    public Image getEnabledUpPicture() {
        return this.m_uImg;
    }

    public void setEnabledDownPicture(String string) {
        this.m_downPicFile = string;
        this.setDPic(Toolkit.getDefaultToolkit().createImage(this.m_downPicFile), true);
    }

    public Image getEnabledDownPicture() {
        return this.m_dImg;
    }

    public void setDisabledUpPicture(String string) {
        this.m_xupPicFile = string;
        this.setUPic(Toolkit.getDefaultToolkit().createImage(this.m_xupPicFile), false);
    }

    public Image getDisabledUpPicture() {
        return this.m_xuImg;
    }

    public void setDisabledDownPicture(String string) {
        this.m_xdownPicFile = string;
        this.setDPic(Toolkit.getDefaultToolkit().createImage(this.m_xdownPicFile), false);
    }

    public Image getDisabledDownPicture() {
        return this.m_xdImg;
    }

    public void waitForAllPictures() {
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.m_uImg != null) {
            mediaTracker.addImage(this.m_uImg, 1);
        }
        if (this.m_dImg != null) {
            mediaTracker.addImage(this.m_dImg, 2);
        }
        if (this.m_xuImg != null) {
            mediaTracker.addImage(this.m_xuImg, 3);
        }
        if (this.m_xdImg != null) {
            mediaTracker.addImage(this.m_xdImg, 4);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isDown() {
        return this.m_bDown;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean bl) {
        this.m_bEnabled = bl;
        this.m_bMouseDown = false;
        this.repaint();
    }

    public void setDown(boolean bl) {
        this.m_bDown = bl;
        this.m_bMouseDown = false;
        this.repaint();
    }

    public void setToggleMode(boolean bl) {
        this.m_bToggleMode = bl;
    }

    public boolean getToggleMode() {
        return this.m_bToggleMode;
    }

    public void setButtonMask(int n) {
        this.m_buttonMask = n;
    }

    public int getButtonMask() {
        return this.m_buttonMask;
    }

    public void paintComponent(Graphics graphics) {
        Image image = null;
        image = this.m_bEnabled ? (this.m_bDown ? this.m_dImg : this.m_uImg) : (this.m_bDown ? this.m_xdImg : this.m_xuImg);
        Rectangle rectangle = this.getBounds();
        Insets insets = this.getInsets();
        rectangle = new Rectangle(insets.left, insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.bottom - insets.top);
        if (image != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.m_interpolation);
            if (rectangle != null) {
                int n = image.getWidth(this);
                int n2 = image.getHeight(this);
                if (n >= 0 && n2 >= 0) {
                    graphics2D.drawImage(image, 0, 0, rectangle.width, rectangle.height, 0, 0, n, n2, this);
                }
            }
        }
    }

    public boolean getMouseDown() {
        return this.m_bMouseDown;
    }

    public void setMouseDown(boolean bl) {
        this.m_bMouseDown = bl;
    }

    public void setData(Object object) {
        this.m_data = object;
    }

    public Object getData() {
        return this.m_data;
    }
}

