/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.IOException;
import java.io.RandomAccessFile;
import shared.cvshelper.Cvs;
import shared.dataformathelper.JDataFormatHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JJPEGHelper.java,v 1.4 2010/04/02 12:12:13 reiner Exp $")
public final class JJPEGHelper {
    public static final int SOI = 65496;
    public static final int JFIF = 65504;
    public static final int COM = 65534;
    public static final int COP = 65518;
    public static final int APP1 = 65505;
    public static final int APP2 = 65506;
    public static final int DQT = 65499;
    public static final int DHT = 65476;
    public static final int DRI = 65501;
    public static final int SOF = 65472;
    public static final int SOS = 65498;
    public static final int EOI = 65497;
    private int m_size;
    private int m_offset;

    public int getSize() {
        return this.m_size;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public boolean isJpegFile(RandomAccessFile randomAccessFile) {
        boolean bl = false;
        byte[] byArray = new byte[2];
        try {
            long l = randomAccessFile.getFilePointer();
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray);
            if (this.isMarker(byArray, 65496)) {
                bl = true;
            }
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public boolean findMarker(RandomAccessFile randomAccessFile, int n) {
        byte[] byArray = new byte[2];
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            while (true) {
                randomAccessFile.read(byArray);
                if (this.isMarker(byArray, n)) {
                    if (this.isMarker(byArray, 65496)) {
                        n3 = 2;
                    } else if (this.isMarker(byArray, 65497)) {
                        n3 = 2;
                    } else {
                        randomAccessFile.read(byArray);
                        n3 = JDataFormatHelper.buf2ToIntBE(byArray, 0);
                    }
                    bl = true;
                    break;
                }
                if (this.isMarker(byArray, 65496)) {
                    n2 += 2;
                    continue;
                }
                if (this.isMarker(byArray, 65497)) {
                    n2 += 2;
                    continue;
                }
                if (this.isMarker(byArray, 65498)) {
                    bl = false;
                    break;
                }
                if (byArray[0] != -1) {
                    return false;
                }
                randomAccessFile.read(byArray);
                n3 = JDataFormatHelper.buf2ToIntBE(byArray, 0);
                randomAccessFile.skipBytes(n3 - 2);
                n2 += n3 + 2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.m_size = n3;
            this.m_offset = n2;
        }
        return bl;
    }

    protected boolean isMarker(byte[] byArray, int n) {
        return JDataFormatHelper.byteToInt(byArray[0]) == (n >> 8 & 0xFF) && JDataFormatHelper.byteToInt(byArray[1]) == (n & 0xFF);
    }
}

