/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import jexifviewer.JExifDataModel;
import jexifviewer.JExifTag;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.dataformathelper.JDataFormatHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JIfd.java,v 1.8 2010/04/02 12:12:13 reiner Exp $")
public class JIfd {
    private long m_offset;
    private int m_count;
    private long m_nextIfdOffset;
    private boolean m_bIsIntel;
    public ArrayList<JExifTag> m_tagArray;
    public static final float GRAD_INVALID = 999.0f;

    public static Date getDateFromString(String string) {
        Date date = null;
        if (string != null && string.length() == 19) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (string.substring(4, 5).equals(":")) {
                n = Integer.parseInt(string.substring(0, 4));
                n2 = Integer.parseInt(string.substring(5, 7));
                n3 = Integer.parseInt(string.substring(8, 10));
                n4 = Integer.parseInt(string.substring(11, 13));
                n5 = Integer.parseInt(string.substring(14, 16));
                n6 = Integer.parseInt(string.substring(17, 19));
            } else if (string.substring(2, 3).equals("/")) {
                n2 = Integer.parseInt(string.substring(0, 2));
                n3 = Integer.parseInt(string.substring(3, 5));
                n = Integer.parseInt(string.substring(6, 10));
                n4 = Integer.parseInt(string.substring(11, 13));
                n5 = Integer.parseInt(string.substring(14, 16));
                n6 = Integer.parseInt(string.substring(17, 19));
            } else assert (false);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
            date = gregorianCalendar.getTime();
        }
        return date;
    }

    public boolean isTagPresent(int n) {
        if (n == 0 || n == 4 || n == 5) {
            return true;
        }
        if (n == 3) {
            return this.findTag(41486) != null && this.findTag(41487) != null && this.findTag(41488) != null;
        }
        if (n == 2) {
            return this.findTag(282) != null && this.findTag(283) != null;
        }
        if (n == 1) {
            return this.findTag(40962) != null && this.findTag(40963) != null;
        }
        if (n == 65538) {
            return this.findTag(65538) != null && this.findTag(65537) != null;
        }
        if (n == 65540) {
            return this.findTag(65540) != null && this.findTag(65539) != null;
        }
        if (n == 65542) {
            return this.findTag(65542) != null && this.findTag(65541) != null;
        }
        if (n == 69632) {
            return this.isTagPresent(65538) && this.isTagPresent(65540);
        }
        if (n == 65536) {
            JExifTag jExifTag = this.findTag(n);
            return jExifTag != null && jExifTag.getByteArray() != null;
        }
        return this.findTag(n) != null;
    }

    public String getMake() {
        String string = "";
        JExifTag jExifTag = this.findTag(271);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getArtist() {
        String string = "";
        JExifTag jExifTag = this.findTag(315);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getDescription() {
        String string = "";
        JExifTag jExifTag = this.findTag(270);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getModel() {
        String string = "";
        JExifTag jExifTag = this.findTag(272);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public int getOrientation() {
        int n = 0;
        JExifTag jExifTag = this.findTag(274);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public float getXResolution() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(282);
        if (jExifTag != null) {
            assert (jExifTag.getLong2() != 0L);
            f = jExifTag.getLong2() != 0L ? (float)jExifTag.getLong1() / (float)jExifTag.getLong2() : (float)jExifTag.getLong1();
        }
        return f;
    }

    public float getYResolution() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(283);
        if (jExifTag != null) {
            assert (jExifTag.getLong2() != 0L);
            f = jExifTag.getLong2() != 0L ? (float)jExifTag.getLong1() / (float)jExifTag.getLong2() : (float)jExifTag.getLong1();
        }
        return f;
    }

    public int getResolutionUnit() {
        int n = 0;
        JExifTag jExifTag = this.findTag(296);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public String getSoftware() {
        String string = "";
        JExifTag jExifTag = this.findTag(305);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getChangeDateTime() {
        String string = "";
        JExifTag jExifTag = this.findTag(306);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public int getYCbCrPosition() {
        int n = 0;
        JExifTag jExifTag = this.findTag(531);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public String getCopyright() {
        String string = "";
        JExifTag jExifTag = this.findTag(33432);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public int getExposureTime(String[] stringArray) {
        int n = 0;
        JExifTag jExifTag = this.findTag(33434);
        if (jExifTag != null) {
            long l = jExifTag.getLong1();
            long l2 = jExifTag.getLong2();
            long l3 = l;
            int n2 = 0;
            int n3 = 0;
            if (l > 0L) {
                while (l3 / 10L * 10L == l3) {
                    l3 /= 10L;
                    ++n2;
                }
            }
            l3 = l2;
            if (l2 > 0L) {
                while (l3 / 10L * 10L == l3) {
                    l3 /= 10L;
                    ++n3;
                }
            }
            n = Math.min(n2, n3);
            while (n-- > 0) {
                l /= 10L;
                l2 /= 10L;
            }
            if (stringArray != null) {
                stringArray[0] = l > l2 && l2 != 0L ? (l / l2 * l2 == l ? String.format("1/%1$d", l / l2) : String.format("%1$d/%2$d", l, l2)) : (l < l2 && l != 0L ? (l2 / l * l == l2 ? String.format("1/%1$d", l2 / l) : String.format("%1$d/%2$d", l, l2)) : "1");
            }
            n = (int)(l * 1000000L / l2);
        }
        return n;
    }

    public float getFNumber(String[] stringArray) {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(33437);
        if (jExifTag != null) {
            long l = jExifTag.getLong1();
            long l2 = jExifTag.getLong2();
            f = (float)l / (float)l2;
            if (stringArray != null) {
                stringArray[0] = String.format("f/%1$.1f", Float.valueOf(f));
            }
        }
        return f;
    }

    public int getExposureProgram() {
        int n = 0;
        JExifTag jExifTag = this.findTag(34850);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getISOSpeedRatings() {
        int n = 0;
        JExifTag jExifTag = this.findTag(34855);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public String getExifVersion() {
        String string = "";
        JExifTag jExifTag = this.findTag(36864);
        if (jExifTag != null) {
            string = jExifTag.getString();
            if ((string = string.substring(0, 2) + "." + string.substring(2, string.length())).charAt(0) == '0') {
                string = string.substring(1);
            }
            if (string.charAt(string.length() - 1) == '0') {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public String getOriginalDateTime() {
        String string = "";
        JExifTag jExifTag = this.findTag(36867);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getDigitizedDateTime() {
        String string = "";
        JExifTag jExifTag = this.findTag(36868);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getComponentsConfig() {
        String string = "";
        JExifTag jExifTag = this.findTag(37121);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public float getCompressedBitsPerPixel() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37122);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public float getShuterSpeedValue() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37377);
        if (jExifTag != null) {
            f = (float)jExifTag.getInteger1() / (float)jExifTag.getInteger2();
        }
        return f;
    }

    public float getApertureValue() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37378);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public float getBrightnessValue() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37379);
        if (jExifTag != null && jExifTag.getInteger1() != -1) {
            f = (float)jExifTag.getInteger1() / (float)jExifTag.getInteger2();
        }
        return f;
    }

    public float getExposureBiasValue() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37380);
        if (jExifTag != null) {
            f = (float)jExifTag.getInteger1() / (float)jExifTag.getInteger2();
        }
        return f;
    }

    public float getMaxApertureValue() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37381);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public int getMeteringMode() {
        int n = 0;
        JExifTag jExifTag = this.findTag(37383);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getLightSource() {
        int n = 0;
        JExifTag jExifTag = this.findTag(37384);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getFlash() {
        int n = 0;
        JExifTag jExifTag = this.findTag(37385);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public float getFocalLength() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(37386);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public int getColorSpace() {
        int n = 0;
        JExifTag jExifTag = this.findTag(40961);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getPixelXDimension() {
        int n = 0;
        JExifTag jExifTag = this.findTag(40962);
        if (jExifTag != null) {
            n = jExifTag.getInteger();
        }
        return n;
    }

    public int getPixelYDimension() {
        int n = 0;
        JExifTag jExifTag = this.findTag(40963);
        if (jExifTag != null) {
            n = jExifTag.getInteger();
        }
        return n;
    }

    public float getFocalPlaneXResolution() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(41486);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public float getFocalPlaneYResolution() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(41487);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public int getFocalPlaneResolutionUnit() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41488);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getSensingMode() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41495);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getCustomRendered() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41985);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getExposureMode() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41986);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getWhiteBalance() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41987);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public float getDigitalZoomRatio() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(41988);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public int getSceneType() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41729);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getSceneCaptureType() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41990);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getSharpness() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41994);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getSubjectDistanceRange() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41996);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getFocalLength35mm() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41989);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getGainControl() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41991);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getContrast() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41992);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getSaturation() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41993);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public int getFileSource() {
        int n = 0;
        JExifTag jExifTag = this.findTag(41728);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public String getGPSVersionID() {
        byte[] byArray;
        String string = "";
        JExifTag jExifTag = this.findTag(65536);
        if (jExifTag != null && (byArray = jExifTag.getByteArray()) != null && byArray.length == 4) {
            string = String.format("%d.%d.%d.%d", byArray[0], (int)byArray[1], (int)byArray[2], (int)byArray[3]);
        }
        return string;
    }

    public String getGPSLatitudeRef() {
        String string = "";
        JExifTag jExifTag = this.findTag(65537);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    private float getGradFromExifTag(JExifTag jExifTag) {
        float f = 999.0f;
        long[] lArray = jExifTag.getLongArray1();
        long[] lArray2 = jExifTag.getLongArray2();
        assert (lArray != null && lArray != null && lArray.length == 3 && lArray2.length == 3);
        if (lArray != null && lArray != null && lArray.length == 3 && lArray2.length == 3) {
            float f2 = (float)lArray[0] / (float)lArray2[0];
            float f3 = (float)lArray[1] / (float)lArray2[1];
            float f4 = (float)lArray[2] / (float)lArray2[2];
            f = f2 + (f3 + f4 / 60.0f) / 60.0f;
        }
        return f;
    }

    public float getGPSLatitude() {
        float f = 999.0f;
        JExifTag jExifTag = this.findTag(65538);
        if (jExifTag != null) {
            f = this.getGradFromExifTag(jExifTag);
        }
        return f;
    }

    public String getGPSLongitudeRef() {
        String string = "";
        JExifTag jExifTag = this.findTag(65539);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public float getGPSLongitude() {
        float f = 999.0f;
        JExifTag jExifTag = this.findTag(65540);
        if (jExifTag != null) {
            f = this.getGradFromExifTag(jExifTag);
        }
        return f;
    }

    public int getGPSAltitudeRef() {
        int n = -1;
        JExifTag jExifTag = this.findTag(65541);
        if (jExifTag != null) {
            n = jExifTag.getInteger1();
        }
        return n;
    }

    public float getGPSAltitude() {
        float f = 0.0f;
        JExifTag jExifTag = this.findTag(65542);
        if (jExifTag != null) {
            f = (float)jExifTag.getLong1() / (float)jExifTag.getLong2();
        }
        return f;
    }

    public String getGPSSatellites() {
        String string = "";
        JExifTag jExifTag = this.findTag(65544);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getGPSStatus() {
        String string = "";
        JExifTag jExifTag = this.findTag(65545);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public String getGPSMeasureMode() {
        String string = "";
        JExifTag jExifTag = this.findTag(65546);
        if (jExifTag != null) {
            string = jExifTag.getString();
        }
        return string;
    }

    public Date getGPSTimestamp() {
        Date date = null;
        JExifTag jExifTag = this.findTag(65543);
        if (jExifTag != null) {
            long[] lArray = jExifTag.getLongArray1();
            long[] lArray2 = jExifTag.getLongArray2();
            assert (lArray != null && lArray2 != null && lArray.length == 3 && lArray2.length == 3);
            if (lArray != null && lArray2 != null && lArray.length == 3 && lArray2.length == 3) {
                float f = (float)lArray[0] / (float)lArray2[0];
                float f2 = (float)lArray[1] / (float)lArray2[1];
                float f3 = (float)lArray[2] / (float)lArray2[2];
                date = new Date((long)((f * 60.0f + f2) * 60.0f + f3) * 1000L);
            }
        }
        return date;
    }

    public JExifTag findTag(int n) {
        if (this.m_tagArray != null) {
            for (JExifTag jExifTag : this.m_tagArray) {
                if (jExifTag.getTag() != n) continue;
                return jExifTag;
            }
        }
        return null;
    }

    public int getCount() {
        return this.m_count;
    }

    public boolean read(RandomAccessFile randomAccessFile, boolean bl, long l) {
        boolean bl2 = false;
        if (this.readIFDTag(randomAccessFile, bl, l, 0)) {
            bl2 = true;
            try {
                JIfd jIfd;
                byte[] byArray = new byte[4];
                randomAccessFile.read(byArray);
                this.m_nextIfdOffset = JDataFormatHelper.buf4ToLong(byArray, 0, bl);
                for (JExifTag jExifTag : this.m_tagArray) {
                    if (jExifTag.getTag() != 34665) continue;
                    randomAccessFile.seek(l + jExifTag.getValueOffset());
                    jIfd = new JIfd();
                    jIfd.readIFDTag(randomAccessFile, bl, l, 0);
                    this.m_tagArray.addAll(jIfd.m_tagArray);
                    break;
                }
                for (JExifTag jExifTag : this.m_tagArray) {
                    if (jExifTag.getTag() != 34853) continue;
                    randomAccessFile.seek(l + jExifTag.getValueOffset());
                    jIfd = new JIfd();
                    jIfd.readIFDTag(randomAccessFile, bl, l, 65536);
                    this.m_tagArray.addAll(jIfd.m_tagArray);
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl2;
    }

    public boolean readIFDTag(RandomAccessFile randomAccessFile, boolean bl, long l, int n) {
        boolean bl2 = false;
        try {
            this.m_bIsIntel = bl;
            this.m_offset = randomAccessFile.getFilePointer();
            byte[] byArray = new byte[2];
            randomAccessFile.read(byArray, 0, 2);
            this.m_count = JDataFormatHelper.buf2ToInt(byArray, 0, bl);
            this.m_tagArray = new ArrayList();
            for (int i = 0; i < this.m_count; ++i) {
                JExifTag jExifTag = new JExifTag(n);
                if (!jExifTag.read(randomAccessFile, bl, l)) continue;
                this.m_tagArray.add(jExifTag);
                if (!Main.m_settings.isDebug()) continue;
                System.err.println(jExifTag.getTag());
                boolean bl3 = false;
                if (JExifTag.isTagUsedByGeneric(jExifTag.getTag())) {
                    bl3 = true;
                } else {
                    for (int j = 0; j < JExifDataModel.m_colTag.length; ++j) {
                        if (JExifDataModel.m_colTag[j] != jExifTag.getTag()) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (bl3) continue;
                System.err.println("!!! UNKOWN TAG FOUND !!!");
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl2;
    }

    public boolean updateTag(RandomAccessFile randomAccessFile, int n, int n2) {
        boolean bl = false;
        try {
            JExifTag jExifTag = this.findTag(n);
            if (jExifTag != null) {
                long l = jExifTag.getFileOffset();
                assert (l != 0L && jExifTag.getType() == 3);
                if (l != 0L && jExifTag.getType() == 3) {
                    randomAccessFile.seek(l);
                    byte[] byArray = new byte[4];
                    JDataFormatHelper.IntToBuf4(n2, byArray, 0, this.m_bIsIntel);
                    randomAccessFile.write(byArray);
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }
}

