/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import jexifviewer.JBatchData;
import jexifviewer.JMainFrame;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.dialog.JModalDialog;
import shared.number.JDoubleHelper;
import shared.swing.JSwingHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JBatchDialog.java,v 1.4 2010/04/03 07:59:53 reiner Exp $")
public class JBatchDialog
extends JModalDialog {
    private JMainFrame m_mainFrame;
    private JBatchData m_batchData;
    private JTextField m_ctrl_srcFolder;
    private JCheckBox m_ctrl_recursive;
    private JCheckBox m_ctrl_jpg;
    private JCheckBox m_ctrl_png;
    private JCheckBox m_ctrl_bmp;
    private JComboBox m_ctrl_scale;
    private JComboBox m_ctrl_targetFormat;
    private JComboBox m_ctrl_targetQuality;
    private JCheckBox m_ctrl_optimizedHuffman;
    private JTextField m_ctrl_targetFolder;
    private JTextField m_ctrl_targetTemplate;

    public JBatchDialog(JMainFrame jMainFrame, JBatchData jBatchData) {
        super((JFrame)jMainFrame, Main.getString("batchdialog_caption"), Main.getString("ok"), Main.getString("cancel"), 0);
        this.m_mainFrame = jMainFrame;
        this.m_batchData = jBatchData;
        this.m_batchData.m_bRecursive = Main.m_settings.getBatchRecursive();
        this.m_batchData.m_srcTypes = Main.m_settings.getBatchSrcFormats();
    }

    protected void doInit() {
        double[] dArray;
        JPanel jPanel = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        JLabel jLabel = new JLabel(Main.getString("batchdialog_src_folder"));
        jPanel.add(jLabel);
        springLayout.putConstraint("West", (Component)jLabel, 10, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel, 10, "North", (Component)jPanel);
        this.m_ctrl_srcFolder = new JTextField(this.m_batchData.m_srcFolder, 40);
        jPanel.add(this.m_ctrl_srcFolder);
        springLayout.putConstraint("West", (Component)this.m_ctrl_srcFolder, 0, "West", (Component)jLabel);
        springLayout.putConstraint("North", (Component)this.m_ctrl_srcFolder, 5, "South", (Component)jLabel);
        JButton jButton = new JButton(Main.getString("browse"));
        jPanel.add(jButton);
        springLayout.putConstraint("West", (Component)jButton, 10, "East", (Component)this.m_ctrl_srcFolder);
        springLayout.putConstraint("VerticalCenter", (Component)jButton, 0, "VerticalCenter", (Component)this.m_ctrl_srcFolder);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(JBatchDialog.this.m_ctrl_srcFolder.getText());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle(Main.getString("batchdialog_browse_caption_src_folder"));
                if (jFileChooser.showOpenDialog(JBatchDialog.this.m_mainFrame) == 0) {
                    ((JBatchDialog)JBatchDialog.this).m_batchData.m_srcFolder = jFileChooser.getSelectedFile().getPath();
                    JBatchDialog.this.m_ctrl_srcFolder.setText(((JBatchDialog)JBatchDialog.this).m_batchData.m_srcFolder);
                }
            }
        });
        springLayout.putConstraint("East", (Component)jPanel, 10, "East", (Component)jButton);
        this.m_ctrl_recursive = new JCheckBox(Main.getString("batchdialog_recursive"), this.m_batchData.m_bRecursive);
        jPanel.add(this.m_ctrl_recursive);
        springLayout.putConstraint("West", (Component)this.m_ctrl_recursive, 0, "West", (Component)this.m_ctrl_srcFolder);
        springLayout.putConstraint("North", (Component)this.m_ctrl_recursive, 15, "South", (Component)this.m_ctrl_srcFolder);
        this.m_ctrl_bmp = new JCheckBox(Main.getString("batchdialog_bmp"));
        jPanel.add(this.m_ctrl_bmp);
        if ((this.m_batchData.m_srcTypes & 4) != 0) {
            this.m_ctrl_bmp.setSelected(true);
        }
        springLayout.putConstraint("East", (Component)this.m_ctrl_bmp, 0, "East", (Component)this.m_ctrl_srcFolder);
        springLayout.putConstraint("North", (Component)this.m_ctrl_bmp, 0, "North", (Component)this.m_ctrl_recursive);
        this.m_ctrl_png = new JCheckBox(Main.getString("batchdialog_png"));
        jPanel.add(this.m_ctrl_png);
        if ((this.m_batchData.m_srcTypes & 2) != 0) {
            this.m_ctrl_png.setSelected(true);
        }
        springLayout.putConstraint("East", (Component)this.m_ctrl_png, -10, "West", (Component)this.m_ctrl_bmp);
        springLayout.putConstraint("North", (Component)this.m_ctrl_png, 0, "North", (Component)this.m_ctrl_recursive);
        this.m_ctrl_jpg = new JCheckBox(Main.getString("batchdialog_jpg"));
        jPanel.add(this.m_ctrl_jpg);
        if ((this.m_batchData.m_srcTypes & 1) != 0) {
            this.m_ctrl_jpg.setSelected(true);
        }
        springLayout.putConstraint("East", (Component)this.m_ctrl_jpg, -10, "West", (Component)this.m_ctrl_png);
        springLayout.putConstraint("North", (Component)this.m_ctrl_jpg, 0, "North", (Component)this.m_ctrl_recursive);
        JSeparator jSeparator = new JSeparator(0);
        jPanel.add(jSeparator);
        springLayout.putConstraint("West", (Component)jSeparator, 10, "West", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jSeparator, -10, "East", (Component)jButton);
        springLayout.putConstraint("North", (Component)jSeparator, 30, "South", (Component)this.m_ctrl_recursive);
        jLabel = new JLabel(Main.getString("batchdialog_target_folder"));
        jPanel.add(jLabel);
        springLayout.putConstraint("West", (Component)jLabel, 0, "West", (Component)this.m_ctrl_srcFolder);
        springLayout.putConstraint("North", (Component)jLabel, 30, "South", (Component)jSeparator);
        this.m_ctrl_targetFolder = new JTextField(this.m_batchData.m_targetFolder != null && !this.m_batchData.m_targetFolder.isEmpty() ? this.m_batchData.m_targetFolder : this.m_batchData.m_srcFolder, 40);
        jPanel.add(this.m_ctrl_targetFolder);
        springLayout.putConstraint("West", (Component)this.m_ctrl_targetFolder, 0, "West", (Component)jLabel);
        springLayout.putConstraint("East", (Component)this.m_ctrl_targetFolder, 0, "East", (Component)this.m_ctrl_srcFolder);
        springLayout.putConstraint("North", (Component)this.m_ctrl_targetFolder, 5, "South", (Component)jLabel);
        JButton jButton2 = new JButton(Main.getString("browse"));
        jPanel.add(jButton2);
        springLayout.putConstraint("VerticalCenter", (Component)jButton2, 0, "VerticalCenter", (Component)this.m_ctrl_targetFolder);
        springLayout.putConstraint("West", (Component)jButton2, 10, "East", (Component)this.m_ctrl_targetFolder);
        springLayout.putConstraint("East", (Component)jButton2, 0, "East", (Component)jButton);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(JBatchDialog.this.m_ctrl_targetFolder.getText());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle(Main.getString("batchdialog_browse_caption_target_folder"));
                if (jFileChooser.showOpenDialog(JBatchDialog.this.m_mainFrame) == 0) {
                    ((JBatchDialog)JBatchDialog.this).m_batchData.m_targetFolder = jFileChooser.getSelectedFile().getPath();
                    JBatchDialog.this.m_ctrl_targetFolder.setText(((JBatchDialog)JBatchDialog.this).m_batchData.m_targetFolder);
                }
            }
        });
        jLabel = new JLabel(Main.getString("batchdialog_target_template"));
        jPanel.add(jLabel);
        springLayout.putConstraint("West", (Component)jLabel, 0, "West", (Component)this.m_ctrl_targetFolder);
        springLayout.putConstraint("North", (Component)jLabel, 15, "South", (Component)this.m_ctrl_targetFolder);
        this.m_ctrl_targetTemplate = new JTextField(this.m_batchData.m_targetTemplate, 40);
        jPanel.add(this.m_ctrl_targetTemplate);
        springLayout.putConstraint("West", (Component)this.m_ctrl_targetTemplate, 0, "West", (Component)jLabel);
        springLayout.putConstraint("East", (Component)this.m_ctrl_targetTemplate, 0, "East", (Component)this.m_ctrl_targetFolder);
        springLayout.putConstraint("North", (Component)this.m_ctrl_targetTemplate, 5, "South", (Component)jLabel);
        jLabel = new JLabel(Main.getString("batchdialog_target_format"));
        jPanel.add(jLabel);
        springLayout.putConstraint("West", (Component)jLabel, 0, "West", (Component)this.m_ctrl_targetTemplate);
        springLayout.putConstraint("North", (Component)jLabel, 20, "South", (Component)this.m_ctrl_targetTemplate);
        this.m_ctrl_targetFormat = new JComboBox();
        this.m_ctrl_targetFormat.addItem(Main.getString("batchdialog_select_jpg"));
        this.m_ctrl_targetFormat.addItem(Main.getString("batchdialog_select_png"));
        this.m_ctrl_targetFormat.addItem(Main.getString("batchdialog_select_bmp"));
        jPanel.add(this.m_ctrl_targetFormat);
        springLayout.putConstraint("West", (Component)this.m_ctrl_targetFormat, 0, "West", (Component)jLabel);
        springLayout.putConstraint("North", (Component)this.m_ctrl_targetFormat, 5, "South", (Component)jLabel);
        final JLabel jLabel2 = new JLabel(Main.getString("batchdialog_target_quality"));
        jPanel.add(jLabel2);
        springLayout.putConstraint("West", (Component)jLabel2, 50, "East", (Component)this.m_ctrl_targetFormat);
        springLayout.putConstraint("North", (Component)jLabel2, 0, "North", (Component)jLabel);
        this.m_ctrl_targetQuality = new JComboBox();
        jPanel.add(this.m_ctrl_targetQuality);
        this.m_ctrl_targetQuality.setEditable(true);
        for (double d = 0.0; d <= 1.01; d += 0.05) {
            this.m_ctrl_targetQuality.addItem(String.format("%.2f", d));
        }
        this.m_ctrl_targetQuality.setSelectedItem(String.format("%.2f", this.m_batchData.m_quality));
        springLayout.putConstraint("West", (Component)this.m_ctrl_targetQuality, 0, "West", (Component)jLabel2);
        springLayout.putConstraint("North", (Component)this.m_ctrl_targetQuality, 5, "South", (Component)jLabel2);
        this.m_ctrl_optimizedHuffman = new JCheckBox(Main.getString("batchdialog_target_optimizedhuffman"), this.m_batchData.m_bOptimizedHuffmanTable);
        jPanel.add(this.m_ctrl_optimizedHuffman);
        springLayout.putConstraint("West", (Component)this.m_ctrl_optimizedHuffman, 0, "West", (Component)jLabel2);
        springLayout.putConstraint("North", (Component)this.m_ctrl_optimizedHuffman, 10, "South", (Component)this.m_ctrl_targetQuality);
        JLabel jLabel3 = new JLabel(Main.getString("batchdialog_target_scale"));
        jPanel.add(jLabel3);
        springLayout.putConstraint("West", (Component)jLabel3, 50, "East", (Component)this.m_ctrl_targetQuality);
        springLayout.putConstraint("North", (Component)jLabel3, 0, "North", (Component)jLabel2);
        this.m_ctrl_scale = new JComboBox();
        jPanel.add(this.m_ctrl_scale);
        springLayout.putConstraint("West", (Component)this.m_ctrl_scale, 0, "West", (Component)jLabel3);
        springLayout.putConstraint("North", (Component)this.m_ctrl_scale, 5, "South", (Component)jLabel3);
        this.m_ctrl_scale.setEditable(true);
        for (double d : dArray = new double[]{0.125, 0.25, 0.3333333333333333, 0.5, 0.6666666666666666, 0.75, 0.875, 1.0, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667, 1.75, 2.0}) {
            this.m_ctrl_scale.addItem(String.format("%.3f", d));
        }
        this.m_ctrl_scale.setSelectedItem(String.format("%.3f", this.m_batchData.m_scaleFactor));
        this.m_ctrl_targetFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (JBatchDialog.this.m_ctrl_targetFormat.getSelectedIndex()) {
                    case 0: {
                        JSwingHelper.enableComponent(jLabel2, true);
                        JSwingHelper.enableComponent(JBatchDialog.this.m_ctrl_targetQuality, true);
                        JSwingHelper.enableComponent(JBatchDialog.this.m_ctrl_optimizedHuffman, true);
                        break;
                    }
                    case 1: 
                    case 2: {
                        JSwingHelper.enableComponent(jLabel2, false);
                        JSwingHelper.enableComponent(JBatchDialog.this.m_ctrl_targetQuality, false);
                        JSwingHelper.enableComponent(JBatchDialog.this.m_ctrl_optimizedHuffman, false);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
        });
        switch (this.m_batchData.m_targetFormat) {
            case 1: {
                this.m_ctrl_targetFormat.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.m_ctrl_targetFormat.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.m_ctrl_targetFormat.setSelectedIndex(2);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setPreferredSize(new Dimension(550, 420));
        this.setResizable(false);
        this.addCtrlPanel(jPanel);
    }

    protected boolean doGetData() {
        this.m_batchData.m_srcFolder = this.m_ctrl_srcFolder.getText();
        this.m_batchData.m_bRecursive = this.m_ctrl_recursive.isSelected();
        this.m_batchData.m_srcTypes = 0;
        this.m_batchData.m_srcTypes = this.m_batchData.m_srcTypes | (this.m_ctrl_jpg.isSelected() ? 1 : 0);
        this.m_batchData.m_srcTypes = this.m_batchData.m_srcTypes | (this.m_ctrl_png.isSelected() ? 2 : 0);
        this.m_batchData.m_srcTypes = this.m_batchData.m_srcTypes | (this.m_ctrl_bmp.isSelected() ? 4 : 0);
        if (this.m_batchData.m_srcTypes == 0) {
            JOptionPane.showMessageDialog(this.m_mainFrame, Main.getString("batchdialog_msg_mustgive_srcformat"), Main.getMessageBoxCaption(), 2, Main.m_icon16);
            return false;
        }
        this.m_batchData.m_targetFolder = this.m_ctrl_targetFolder.getText();
        this.m_batchData.m_targetTemplate = this.m_ctrl_targetTemplate.getText();
        switch (this.m_ctrl_targetFormat.getSelectedIndex()) {
            case 0: {
                this.m_batchData.m_targetFormat = 1;
                break;
            }
            case 1: {
                this.m_batchData.m_targetFormat = 2;
                break;
            }
            case 2: {
                this.m_batchData.m_targetFormat = 4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        String string = (String)this.m_ctrl_targetQuality.getSelectedItem();
        if (string != null) {
            try {
                this.m_batchData.m_quality = JDoubleHelper.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_batchData.m_bOptimizedHuffmanTable = this.m_ctrl_optimizedHuffman.isSelected();
        string = (String)this.m_ctrl_scale.getSelectedItem();
        if (string != null) {
            try {
                this.m_batchData.m_scaleFactor = JDoubleHelper.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Main.m_settings.setBatchRecursive(this.m_batchData.m_bRecursive);
        Main.m_settings.setBatchSrcFormats(this.m_batchData.m_srcTypes);
        Main.m_settings.setBatchTargetFormat(this.m_batchData.m_targetFormat);
        Main.m_settings.setBatchJpgQuality((float)this.m_batchData.m_quality);
        Main.m_settings.setBatchJpgOptHuf(this.m_batchData.m_bOptimizedHuffmanTable);
        Main.m_settings.setBatchScale((float)this.m_batchData.m_scaleFactor);
        return true;
    }
}

