/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.comm;

import com.ibm.comm.OS2SerialPort;
import java.io.IOException;
import java.io.InputStream;

public class OS2SerialInputStream
extends InputStream {
    private int handle;
    private OS2SerialPort sPort;

    public OS2SerialInputStream(OS2SerialPort oS2SerialPort, int n) {
        this.handle = n;
        this.sPort = oS2SerialPort;
    }

    public int read() throws IOException {
        int n = this._ReadByteSerial(this.handle);
        if (n == -2) {
            throw new IOException();
        }
        if (n == -1) {
            this.sPort.SetNewData(true);
        } else {
            this.sPort.SetNewData(false);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this._ReadByteArraySerial(this.handle, byArray, 0, byArray.length);
        if (n == -2) {
            throw new IOException();
        }
        if (n == -1) {
            this.sPort.SetNewData(true);
        } else {
            this.sPort.SetNewData(false);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this._ReadByteArraySerial(this.handle, byArray, n, n2);
        if (n3 == -2) {
            throw new IOException();
        }
        if (n3 == -1) {
            this.sPort.SetNewData(true);
        } else {
            this.sPort.SetNewData(false);
        }
        return n3;
    }

    public int available() throws IOException {
        int n = this._ReadSerialAvailable(this.handle);
        if (n == -2) {
            throw new IOException();
        }
        if (n == 0) {
            this.sPort.SetNewData(true);
        }
        return n;
    }

    public void close() throws IOException {
    }

    public long skip(long l) throws IOException {
        return 0L;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    private native int _ReadByteSerial(int var1);

    private native int _ReadByteArraySerial(int var1, byte[] var2, int var3, int var4);

    private native int _ReadSerialAvailable(int var1);
}

