/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.HelperExtract;

public class HelperValidate {
    public static final boolean isIP(String str) {
        int hitDots = 0;
        char[] data = str.toCharArray();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return false;
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return false;
            }
            ++hitDots;
            ++i;
        }
        return hitDots == 4 && !str.endsWith(".");
    }

    public static boolean isNumeric(char c) {
        return Character.isDigit(c) || c == '.';
    }

    public static boolean isNumeric(String strToTest) {
        if (strToTest == null || strToTest.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < strToTest.length()) {
            if (!HelperValidate.isNumeric(strToTest.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean patternMatch(String string, String string2) {
        String str = string.toLowerCase();
        String strPattern = string2.toLowerCase();
        int wildPos = strPattern.indexOf(42);
        if (wildPos == -1) {
            return str.equals(strPattern);
        }
        int templLen = strPattern.length();
        int strLen = str.length();
        int templIndex = 0;
        int strIndex = 0;
        boolean wildCard = false;
        while (templIndex < templLen) {
            if (strPattern.charAt(templIndex) == '*') {
                wildCard = true;
                ++templIndex;
                continue;
            }
            int nextWild = strPattern.indexOf(42, templIndex);
            if (nextWild == -1) {
                nextWild = templLen;
            }
            String templPart = strPattern.substring(templIndex, nextWild);
            templIndex = nextWild;
            if (wildCard) {
                int pos = str.indexOf(templPart);
                if (pos == -1) {
                    return false;
                }
                strIndex = pos + templPart.length();
            } else {
                if (!str.regionMatches(false, 0, templPart, 0, templPart.length())) {
                    return false;
                }
                strIndex += templPart.length();
            }
            wildCard = false;
        }
        return wildCard ? true : strIndex == strLen;
    }

    public static final String validateFileName(String string) {
        String strName = string.trim();
        if (strName.length() == 0) {
            return null;
        }
        boolean blnValid = true;
        int i = 0;
        while (i < strName.length() && blnValid) {
            char ch = strName.charAt(i);
            if (ch < ' ') {
                return null;
            }
            if (ch > '~') {
                return null;
            }
            ++i;
        }
        return strName;
    }

    public static final String validateRFC822_Domain(String string) {
        String strOrg = string;
        String strDomain = string.toLowerCase().trim();
        if (strDomain.startsWith("[") && strDomain.endsWith("]")) {
            strDomain = strDomain.substring(1);
            if (HelperValidate.isIP(strDomain = strDomain.substring(0, strDomain.length() - 1))) {
                return strOrg;
            }
            return null;
        }
        int i = 0;
        while (i < strDomain.length()) {
            char ch = strDomain.charAt(i);
            if (ch < '0' && ch != '-' && ch != '.') {
                return null;
            }
            if (ch > '9' && ch < 'a') {
                return null;
            }
            if (ch > 'z') {
                return null;
            }
            ++i;
        }
        int pp = strDomain.indexOf(".");
        if (pp == -1) {
            return null;
        }
        if (strDomain.length() - pp < 3) {
            return null;
        }
        if (pp < 1) {
            return null;
        }
        return strDomain;
    }

    public static final String validateRFC822_User(String string) {
        String strDom;
        String strUser = string.toLowerCase().trim();
        int pp1 = strUser.indexOf("%");
        int pp2 = strUser.indexOf("@");
        if (pp1 != -1 && pp2 == -1) {
            strUser = strUser.replace('%', '@');
        }
        if ((strDom = HelperValidate.validateRFC822_Domain(HelperExtract.splitUserName_getDomain(strUser))) == null) {
            return null;
        }
        String strUsr = HelperExtract.splitUserName_getUser(strUser);
        int i = 0;
        while (i < strUsr.length()) {
            char ch = strUsr.charAt(i);
            if (ch < ' ') {
                return null;
            }
            if (ch > 'z') {
                return null;
            }
            ++i;
        }
        return String.valueOf(strUsr) + "@" + strDom;
    }
}

