/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.lang.reflect.Constructor;

public abstract class Encoding {
    private static final String BASECLASS = "de.zwanzigeins.util.";
    protected byte[] bytBuffer = null;
    protected int intBufferSize = 0;
    protected int intBufferIndex = 0;
    protected int intBufferEnd = 0;
    protected boolean blnFinish = false;
    protected boolean blnDecodeMode = false;
    protected boolean blnIsBinary = false;

    protected Encoding() {
        this(8192);
    }

    protected Encoding(int bufferSize) {
        this.intBufferSize = bufferSize;
    }

    private String codeString(String strInput, boolean blnDecode) {
        if (blnDecode) {
            this.startDecode(true);
        } else {
            this.startEncode(true);
        }
        byte[] bytBuffer = new byte[1024];
        this.setInput(strInput.getBytes(), 0, strInput.length());
        this.finish();
        int i = this.convert(bytBuffer, 0, bytBuffer.length);
        return new String(bytBuffer, 0, i);
    }

    public abstract int convert(byte[] var1, int var2, int var3);

    public static Encoding createEncodingInstance(String encoding) {
        return Encoding.createEncodingInstance(encoding, 0);
    }

    public static Encoding createEncodingInstance(String string, int bufferSize) {
        String encoding = string.toLowerCase();
        if (encoding.indexOf(45) > -1) {
            encoding = encoding.replace('-', '_');
        }
        try {
            Class<?> c = Class.forName(BASECLASS + encoding);
            if (bufferSize < 1024) {
                return (Encoding)Class.forName(BASECLASS + encoding).newInstance();
            }
            Class[] p = new Class[]{Integer.TYPE};
            Constructor<?> con = c.getConstructor(p);
            return (Encoding)con.newInstance(new Integer(bufferSize));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String decodeString(String strInput) {
        return this.codeString(strInput, true);
    }

    public void dispose() {
        this.bytBuffer = null;
        this.intBufferSize = 0;
        this.intBufferIndex = 0;
        this.intBufferEnd = 0;
        this.blnFinish = false;
        this.blnDecodeMode = false;
        this.blnIsBinary = false;
    }

    public String encodeString(String strInput) {
        return this.codeString(strInput, false);
    }

    public final void finish() {
        this.blnFinish = true;
    }

    protected final void init() {
        if (this.bytBuffer == null) {
            this.bytBuffer = new byte[this.intBufferSize];
        }
        this.intBufferIndex = 0;
        this.intBufferEnd = 0;
        this.blnIsBinary = false;
        this.blnFinish = false;
    }

    public final boolean isBinary() {
        return this.blnIsBinary;
    }

    public final boolean needInput() {
        return this.intBufferIndex == this.intBufferEnd;
    }

    public final void setBinary(boolean bin) {
        this.blnIsBinary = bin;
    }

    public final void setInput(byte[] b, int off, int len) {
        if (off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("off+len > buffer length, data not set (" + off + '+' + len + '>' + b.length + ')');
        }
        if (this.intBufferIndex > 0 && this.intBufferIndex < this.intBufferEnd) {
            System.arraycopy(this.bytBuffer, this.intBufferIndex, this.bytBuffer, 0, this.intBufferEnd - this.intBufferIndex);
        }
        this.intBufferEnd -= this.intBufferIndex;
        this.intBufferIndex = 0;
        if (this.intBufferSize - this.intBufferEnd < len) {
            this.intBufferSize = this.intBufferEnd + len;
            byte[] newBuffer = new byte[this.intBufferSize];
            System.arraycopy(this.bytBuffer, 0, newBuffer, 0, this.intBufferEnd);
            this.bytBuffer = newBuffer;
        }
        System.arraycopy(b, off, this.bytBuffer, this.intBufferEnd, len);
        this.intBufferEnd += len;
    }

    public final void startDecode() {
        this.startDecode(false);
    }

    public void startDecode(boolean binary) {
        this.init();
        this.blnDecodeMode = true;
        this.blnIsBinary = binary;
    }

    public final void startEncode() {
        this.startEncode(false);
    }

    public void startEncode(boolean binary) {
        this.init();
        this.blnDecodeMode = false;
        this.blnIsBinary = binary;
    }
}

