/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperValidate;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class MailingListRecord
extends StorageRecord
implements Serializable {
    public static final String[] COMMANDS = new String[]{"help", "subscribe", "unsubscribe"};
    private String strName = null;
    private String[] strOwner = null;
    private boolean blnModerated = true;
    private String[] strCommands = null;
    private String[] strSubscriber = null;

    public MailingListRecord() {
        this.init();
    }

    public String[] getCommands() {
        return this.strCommands;
    }

    public String getName() {
        return this.strName;
    }

    public String[] getOwner() {
        return this.strOwner;
    }

    public String[] getSubscribers() {
        return this.strSubscriber;
    }

    public void init() {
        this.strName = "";
        this.strOwner = new String[]{""};
        this.blnModerated = true;
        this.strCommands = COMMANDS;
        this.strSubscriber = new String[0];
    }

    public boolean isModerated() {
        return this.blnModerated;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        String LF = System.getProperty("line.separator");
        strb.append("name=");
        strb.append(this.strName);
        strb.append(LF);
        strb.append("owner=");
        int i = 0;
        while (i < this.strCommands.length) {
            strb.append(this.strOwner[i]);
            if (i < this.strCommands.length - 1) {
                strb.append(",");
            }
            ++i;
        }
        strb.append(this.strOwner);
        strb.append(LF);
        strb.append("moderated=");
        strb.append(this.blnModerated ? "1" : "0");
        strb.append(LF);
        strb.append(LF);
        strb.append("commands=");
        i = 0;
        while (i < this.strCommands.length) {
            strb.append(this.strCommands[i]);
            if (i < this.strCommands.length - 1) {
                strb.append(",");
            }
            ++i;
        }
        strb.append(LF);
        i = 0;
        while (i < this.strSubscriber.length) {
            strb.append("subscriber=");
            strb.append(this.strSubscriber[i]);
            strb.append(LF);
            ++i;
        }
        return strb.toString();
    }

    public void recordImport(String str) {
        try {
            Vector<String> vecSubscriber = new Vector<String>(50, 25);
            BufferedReader br = new BufferedReader(new StringReader(str));
            String strBuffer = null;
            while ((strBuffer = br.readLine()) != null) {
                if ((strBuffer = strBuffer.trim()).startsWith("#") || strBuffer.startsWith(";")) continue;
                int pp = strBuffer.indexOf("=");
                String strKey = null;
                String strData = null;
                if (pp > 0) {
                    strKey = strBuffer.substring(0, pp).trim().toLowerCase();
                    strData = strBuffer.substring(pp + 1).trim();
                } else {
                    strKey = strBuffer.toLowerCase();
                    strData = "";
                }
                if (strKey.equals("name")) {
                    this.strName = strData;
                    continue;
                }
                if (strKey.equals("owner")) {
                    this.strOwner = StorageRecord.conv_string2array(strData);
                    continue;
                }
                if (strKey.equals("commands")) {
                    this.strCommands = StorageRecord.conv_string2array(strData);
                    continue;
                }
                if (!strKey.equals("subscriber")) continue;
                vecSubscriber.addElement(strData);
            }
            this.strSubscriber = new String[vecSubscriber.size()];
            vecSubscriber.copyInto(this.strSubscriber);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    public void setCommands(String[] s) {
        this.strCommands = s;
    }

    public void setModerated(boolean b) {
        this.blnModerated = b;
    }

    public void setName(String s) {
        String strTmp = Helper.limit(s.toLowerCase(), 129);
        if ((strTmp = HelperValidate.validateRFC822_User((String)strTmp)) == null) {
            throw new IllegalArgumentException(String.valueOf(s) + " is not a valid user name");
        }
        this.strName = strTmp;
    }

    public void setOwner(String[] s) {
        int i = 0;
        while (i < s.length) {
            String strTmp = Helper.limit(s[i].toLowerCase(), 129);
            if ((strTmp = HelperValidate.validateRFC822_User((String)strTmp)) == null) {
                throw new IllegalArgumentException(s + " is not a valid user name");
            }
            this.strOwner[i] = strTmp;
            ++i;
        }
    }

    public void setSubscribers(String[] s) {
        int i = 0;
        while (i < s.length) {
            String strTmp = Helper.limit(s[i].toLowerCase(), 129);
            if ((strTmp = HelperValidate.validateRFC822_User((String)strTmp)) == null) {
                throw new IllegalArgumentException(String.valueOf(s[i]) + " is not a valid user name");
            }
            ++i;
        }
        this.strSubscriber = new String[s.length];
        i = 0;
        while (i < s.length) {
            this.strSubscriber[i] = s[i];
            ++i;
        }
    }

    public String toString() {
        return this.getName();
    }
}

