/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import java.io.Serializable;
import net.zerotoaster.mta.util.Helper;

public class AccountingRecord
implements Serializable {
    public static final int ACC_LENGTH = 157;
    public static final String ACC_SEPARATOR = ",";
    public static final String ACC_INTERN = "I";
    public static final String ACC_POLL = "P";
    public static final String ACC_RELAY = "R";
    public static final String ACC_FETCH = "F";
    public String strType;
    public String strKey;
    public long lngBytesReceived;
    public long lngBytesSent;

    public AccountingRecord() {
        this.strType = "";
        this.strKey = "";
        this.lngBytesReceived = 0L;
        this.lngBytesSent = 0L;
    }

    public AccountingRecord(String strType, String strKey, long lngBytesReceived, long lngBytesSent) {
        this.strType = strType;
        this.strKey = strKey;
        this.lngBytesReceived = lngBytesReceived;
        this.lngBytesSent = lngBytesSent;
    }

    public void parse(String strRecord) {
        this.strType = strRecord.substring(0, 1).trim();
        this.strKey = strRecord.substring(2, 131).trim();
        String s = strRecord.substring(132, 143).trim();
        this.lngBytesReceived = Long.parseLong(s);
        s = strRecord.substring(144, 155).trim();
        this.lngBytesSent = Long.parseLong(s);
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strType);
        strb.append(ACC_SEPARATOR);
        strb.append(Helper.lset(this.strKey, 129, ' '));
        strb.append(ACC_SEPARATOR);
        strb.append(Helper.rset(this.lngBytesReceived, 11, ' '));
        strb.append(ACC_SEPARATOR);
        strb.append(Helper.rset(this.lngBytesSent, 11, ' '));
        strb.append("\r\n");
        return strb.toString();
    }
}

