/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.UserAlias;

public class ML_Import
extends Thread
implements Constants {
    private LockObject objLock = new LockObject();
    private boolean blnIsRunning = false;
    private StorageManager smManager = null;
    private Configuration cnf = Configuration.getConfig();
    private String TEMPFILE = "MLIMPORT.TMP";

    public ML_Import() throws Throwable {
        super("MAILIMP");
        this.setName("MailImport");
        this.smManager = Configuration.getStorageManager();
        this.start();
    }

    public void dispose() {
        this.blnIsRunning = false;
        this.objLock.lo_notify();
        this.objLock.dispose();
        this.objLock = null;
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
    }

    private boolean import_mail(File flMail) {
        String strUser;
        LineReader lrIn = null;
        try {
            lrIn = new LineReader(new FileInputStream(flMail));
        }
        catch (IOException e) {
            Configuration.logContext.write("? Cannot open importmail " + flMail + ": " + e.getMessage());
            Helper.close(lrIn);
            return false;
        }
        String strUID_Temp = TimeFactory.createUID();
        LineWriter lwOut = this.smManager.tempWrite(strUID_Temp);
        boolean blnHadProblem = false;
        boolean blnInHeader = true;
        String strSender = "";
        Vector<String> vecRecipients = new Vector<String>();
        String strLine = null;
        Object strLastCommand = null;
        boolean blnSND_OverrideRecipients = false;
        boolean blnSND_OverrideSender = false;
        while (true) {
            try {
                int pp;
                strLine = lrIn.readLine();
                if (strLine == null || strLine.equals(".")) {
                    lwOut.println(".");
                    break;
                }
                if (!blnInHeader) {
                    lwOut.println(strLine);
                    continue;
                }
                if (strLine.length() == 0 && blnInHeader) {
                    blnInHeader = false;
                    lwOut.println("");
                    continue;
                }
                if (strLine.charAt(0) == ' ' || strLine.charAt(0) == '\t' && strLastCommand != null) {
                    strLine = String.valueOf(strLastCommand) + " " + strLine.trim();
                }
                if ((pp = strLine.indexOf(":")) == -1) continue;
                String s1 = strLine.substring(0, pp + 1).trim().toLowerCase();
                String s2 = strLine.substring(pp + 1).trim();
                if (s1.equals("snd-recipients:")) {
                    StringTokenizer strt = new StringTokenizer(s2, " ");
                    while (strt.hasMoreTokens()) {
                        strUser = strt.nextToken();
                        vecRecipients.addElement(Helper.getSMTPUser(strUser));
                        Configuration.logContext.write("# Added snd-recipient '" + strUser + "'");
                    }
                    blnSND_OverrideRecipients = true;
                    continue;
                }
                if (s1.equals("snd-sender:")) {
                    strSender = Helper.getSMTPUser(s2);
                    blnSND_OverrideSender = true;
                    continue;
                }
                if (s1.equals("snd-readheader:")) continue;
                if (!blnSND_OverrideRecipients && (s1.equals("to:") || s1.equals("cc:") || s1.equals("bcc:") || s1.equals("x-envelope-to:") || s1.equals("x-delivered-to:"))) {
                    String[] strRecipients = HelperExtract.getRFC822_Recipients((String)s2);
                    int i = 0;
                    while (i < strRecipients.length) {
                        vecRecipients.addElement(strRecipients[i]);
                        Configuration.logContext.write("# Added " + s1 + "-recipient '" + strRecipients[i] + "'");
                        ++i;
                    }
                    if (s1.equals("bcc:")) continue;
                }
                if (!blnSND_OverrideSender && (s1.equals("from:") || s1.equals("x-envelope-from:"))) {
                    strSender = Helper.getSMTPUser(s2);
                }
                lwOut.println(strLine);
            }
            catch (IOException e) {
                blnHadProblem = true;
                Configuration.logContext.write("? Error during import of " + flMail + ": " + e.getMessage());
                break;
            }
        }
        if (vecRecipients.size() == 0) {
            Configuration.logContext.write("? " + flMail + " does not contain any valid recipient");
            blnHadProblem = true;
        }
        Helper.close(lrIn);
        Helper.close(lwOut);
        if (blnHadProblem) {
            this.smManager.tempDelete(strUID_Temp);
            return false;
        }
        Configuration.logContext.write("D Have " + vecRecipients.size() + " recipients before aliasing");
        int intNewSize = (int)((double)vecRecipients.size() * 1.5);
        Vector<String> vecUserNew = new Vector<String>(intNewSize);
        UserAlias uaAlias = new UserAlias(this.cnf.strAliases, Configuration.logContext);
        int i = 0;
        while (i < vecRecipients.size()) {
            strUser = (String)vecRecipients.elementAt(i);
            String[] strUsers = uaAlias.resolve(strUser);
            int j = 0;
            while (j < strUsers.length) {
                vecUserNew.addElement(strUsers[j]);
                ++j;
            }
            ++i;
        }
        Configuration.logContext.write("D Have " + vecUserNew.size() + " recipients after aliasing");
        vecRecipients = vecUserNew;
        vecUserNew = null;
        vecUserNew = new Vector(vecRecipients.size());
        i = 0;
        while (i < vecRecipients.size()) {
            String strUserNew;
            String strUserOld = (String)vecRecipients.elementAt(i);
            if (!strUserOld.equals(strUserNew = Helper.redirectUser(strUserOld, this.smManager))) {
                Configuration.logContext.write("# Redirected " + strUserOld + " -> " + strUserNew);
            }
            ++i;
        }
        long lngTimeStamp = TimeFactory.getTime();
        MailQueueRecord mqr = new MailQueueRecord(vecRecipients.size());
        mqr.blnAVScan = this.cnf.blnMailImportAVSCAN;
        mqr.strUID_Queue = strUID_Temp;
        mqr.strUID_Temp = strUID_Temp;
        int i2 = 0;
        while (i2 < vecRecipients.size()) {
            String strRecipient = (String)vecRecipients.elementAt(i2);
            MailHeaderRecord mhr = new MailHeaderRecord();
            mhr.setEnvelopeFrom_Redirected(strSender);
            mhr.setEnvelopeFrom_Orginal(strSender);
            mhr.addEnvelopeTo_Redirected(strRecipient);
            mhr.addEnvelopeTo_Orginal(strRecipient);
            mhr.setMailSize(lwOut.getBytes());
            mhr.setTimeReceived(lngTimeStamp);
            mhr.setTimeNextRetry(lngTimeStamp);
            mhr.setTimeFetched(0L);
            mhr.setRetryCount(0);
            mhr.setMailDeleted(false);
            mhr.setUID(TimeFactory.createUID());
            mhr.setAccounting(strSender);
            mhr.setHELO("");
            DomainRecord domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)strRecipient));
            this.smManager.userRead(strRecipient);
            if (domReceiver == null) {
                mhr.setExternalMail(true);
                mhr.setIsRelayMail(false);
            } else {
                mhr.setExternalMail(domReceiver == null);
                mhr.setIsRelayMail(false);
                mhr.setIsHubMail(false);
            }
            Configuration.logContext.write("# Created " + mhr);
            mqr.vecMHR.addElement(mhr);
            ++i2;
        }
        this.smManager.mailProcessQueueAdd(mqr);
        this.smManager.commit();
        Configuration.logContext.write("# Mail imported.");
        return true;
    }

    public void run() {
        String strPath;
        File flImport;
        long lngWait = (long)this.cnf.intMailImportRescan * 1000L;
        if (lngWait <= 0L) {
            lngWait = 2000L;
        }
        if (!(flImport = new File(strPath = Helper.platformPath(this.cnf.strMailImportPath))).exists()) {
            flImport.mkdirs();
        }
        if (!flImport.isDirectory()) {
            Configuration.logContext.write("? Cannot create or access mail import directory [" + flImport.getPath() + "]");
            return;
        }
        this.blnIsRunning = true;
        block0: while (this.blnIsRunning) {
            this.objLock.lo_wait(lngWait);
            if (!this.blnIsRunning) break;
            File flTmp = new File(flImport, this.TEMPFILE);
            flTmp.delete();
            if (flTmp.exists()) {
                Configuration.logContext.write("? Cannot delete temporary file, stopping import thread");
                this.blnIsRunning = false;
                break;
            }
            String[] strMails = flImport.list();
            if (strMails.length == 0) continue;
            int i = 0;
            while (i < strMails.length) {
                File flMail = new File(flImport, strMails[i]);
                if (flMail.exists() && flMail.length() != 0L) {
                    int ii = 0;
                    while (ii < 20) {
                        flMail.renameTo(flTmp);
                        if (flTmp.exists()) break;
                        this.objLock.lo_wait(250L);
                        ++ii;
                    }
                    if (!flTmp.exists()) {
                        Configuration.logContext.write("? Cannot rename to temporary file, stopping import thread");
                        this.blnIsRunning = false;
                        continue block0;
                    }
                    this.import_mail(flTmp);
                    flTmp.delete();
                }
                ++i;
            }
        }
        Configuration.logContext.write("# Import thread was shut down");
    }
}

