/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.html;

import de.zwanzigeins.codecs.HTMLFormatCodec;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import net.zerotoaster.httpd.servlet.util.ExtendedHttpServlet;
import net.zerotoaster.mta.admin.html.WA2010_SortMessages;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.CleanupEvent;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.mailfilters.BayesianFilterConfig;
import net.zerotoaster.mta.mailfilters.BayesianFilterRecord;
import net.zerotoaster.mta.mailfilters.BayesianRBLRecord;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FetchmailRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StatisticsRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.RBLCheck;
import net.zerotoaster.mta.whois.Whois;
import net.zerotoaster.mta.whois.WhoisResult;

public class WebFrontend
extends ExtendedHttpServlet {
    private int intAJAX = 0;
    private Configuration cnfConfig = null;
    private StorageManager smManager = null;
    private final String WA2010_SESSION_collected_mails = "COLLECTED_MAILS";

    protected void cb_display() throws IOException {
        this.runtime_statistics();
        this.tpl.setVar("privilege", UserRecord.getPrivilegeString(this.intAccessLevel));
        this.tpl.setVar("zt_mta_version", "2.80");
        this.tpl.setVar("zt_httpd_version", "1.63");
    }

    protected boolean cb_login(String strUSER, String strPASS) throws IOException {
        UserRecord ur;
        this.intAccessLevel = -1;
        if (strUSER.length() == 0 || strPASS.length() == 0) {
            this.tpl.setVar("error", "User/Password empty");
            return false;
        }
        if (strUSER.equalsIgnoreCase(this.cnfConfig.strRemote_Admin_User) && strPASS.equalsIgnoreCase(this.cnfConfig.strRemote_Admin_Pass)) {
            this.intAccessLevel = 5;
        }
        if ((ur = this.smManager.userRead(strUSER)) != null) {
            this.intAccessLevel = ur.getPrivilege();
        }
        if (this.intAccessLevel == -1) {
            this.tpl.setVar("error", "Wrong user/password");
            return false;
        }
        return true;
    }

    protected boolean cb_service() throws IOException, ServletException {
        return true;
    }

    public void destroy() {
        this.smManager.dispose();
        this.smManager = null;
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
        this.strAPPLICATIONNAME = "ZeroToaster::MTA";
        this.cnfConfig = Configuration.getConfig();
        try {
            this.smManager = Configuration.getStorageManager();
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        this.sdfDate.setTimeZone(TimeZone.getTimeZone(this.cnfConfig.strTimeZone));
        this.sdfTime.setTimeZone(TimeZone.getTimeZone(this.cnfConfig.strTimeZone));
    }

    private void runtime_statistics() {
        Date dat = new Date(TimeFactory.getTime());
        this.tpl.setVar("servertime", String.valueOf(this.sdfDate.format(dat)) + " " + this.sdfTime.format(dat));
        StatisticsRecord sr = this.smManager.statsGet();
        long lngRuntimeH = (sr.lngTimeCurrent - sr.lngTimeStarted) / 1000L / 3600L;
        if (lngRuntimeH == 0L) {
            lngRuntimeH = 1L;
        }
        dat = new Date(sr.lngTimeStarted);
        this.tpl.setVar("started", String.valueOf(this.sdfDate.format(dat)) + " " + this.sdfTime.format(dat));
        this.tpl.setVar("running", HelperDT.getRuntimeDHMS((long)(sr.lngTimeCurrent - sr.lngTimeStarted)));
        this.tpl.setVar("mem_avail", HelperFormat.formatMemoryString((long)sr.lngMemory_total));
        this.tpl.setVar("mem_free", HelperFormat.formatMemoryString((long)sr.lngMemory_free));
        this.tpl.setVar("pop3_t_access", sr.lngPOP3_accesses);
        this.tpl.setVar("pop3_t_bytes", HelperFormat.formatMemoryString((long)sr.lngPOP3_bytes));
        this.tpl.setVar("pop3_t_peak", sr.intPOP3_peak);
        this.tpl.setVar("pop3_t_max", this.cnfConfig.intPOP3_Instances);
        this.tpl.setVar("pop3_h_access", sr.lngPOP3_accesses / lngRuntimeH);
        this.tpl.setVar("pop3_h_bytes", HelperFormat.formatMemoryString((long)(sr.lngPOP3_bytes / lngRuntimeH)));
        this.tpl.setVar("smtp_t_access", sr.lngSMTP_accesses);
        this.tpl.setVar("smtp_t_bytes", HelperFormat.formatMemoryString((long)sr.lngSMTP_bytes));
        this.tpl.setVar("smtp_t_peak", sr.intSMTP_peak);
        this.tpl.setVar("smtp_t_max", this.cnfConfig.intSMTP_Instances);
        this.tpl.setVar("smtp_h_access", sr.lngSMTP_accesses / lngRuntimeH);
        this.tpl.setVar("smtp_h_bytes", HelperFormat.formatMemoryString((long)(sr.lngSMTP_bytes / lngRuntimeH)));
        this.tpl.setVar("fwd_t_access", sr.lngFWD_accesses);
        this.tpl.setVar("fwd_t_bytes", HelperFormat.formatMemoryString((long)sr.lngFWD_bytes));
        this.tpl.setVar("fwd_t_peak", sr.intFWD_peak);
        this.tpl.setVar("fwd_t_max", this.cnfConfig.intFWD_Instances);
        this.tpl.setVar("fwd_h_access", sr.lngFWD_accesses / lngRuntimeH);
        this.tpl.setVar("fwd_h_bytes", HelperFormat.formatMemoryString((long)(sr.lngFWD_bytes / lngRuntimeH)));
        this.tpl.setVar("mpa_peak", sr.intMPA_peak);
        this.tpl.setVar("mpa_max", this.cnfConfig.intMPA_Instances);
    }

    public void WA1100(String string) throws IOException {
        String strAction;
        DomainRecord dr = new DomainRecord();
        String strDomain = null;
        strDomain = string.equals("store") ? this.reqGetParameter("domaininput", null) : this.reqGetParameter("domainlist", null);
        if (string.equals("domainlist")) {
            dr = this.smManager.domainRead(strDomain);
        }
        if (string.equals("update") || string.equals("store")) {
            try {
                dr.setDomainName(strDomain);
                dr.setEnable_POP3(this.reqGetParameterBoolean("enable_pop3", false));
                dr.setEnable_SMTP(this.reqGetParameterBoolean("enable_smtp", false));
                dr.setSMTP_after_POP3(this.reqGetParameterBoolean("smtp_after_pop3", false));
                dr.setSessionTimeout(this.reqGetParameterInt("sessiontimeout", 30));
                dr.setCatchAll(this.reqGetParameter("catchall", ""));
                dr.setDomainAlias(this.reqGetParameter("domainalias", ""));
                dr.setAVScan(this.reqGetParameterBoolean("avscan", false));
                dr.setQuota_Days(this.reqGetParameterInt("quota_days", 0));
                dr.setQuota_MB(this.reqGetParameterInt("quota_mb", 0));
                dr.setQuota_Mails(this.reqGetParameterInt("quota_mails", 0));
                dr.setMemo(this.reqGetParameter("memo", ""));
                dr.setIP_Networks(StorageRecord.conv_string2networks(this.reqGetParameter("ip_networks", "")));
                this.smManager.domainWrite(dr);
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        if (string.equals("delete")) {
            try {
                this.smManager.domainDelete(strDomain);
                strAction = "";
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        StringBuffer strb = new StringBuffer();
        Vector vecDomains = this.smManager.domainReadAll();
        if (strAction.length() == 0 && vecDomains.size() > 0) {
            strDomain = (String)vecDomains.elementAt(0);
            dr = this.smManager.domainRead(strDomain);
        }
        int i = 0;
        while (i < vecDomains.size()) {
            String str = (String)vecDomains.elementAt(i);
            strb.append("<option ");
            if (str.equals(strDomain)) {
                strb.append("selected ");
            }
            strb.append("value=\"" + str + "\">" + str + "</option>\r\n");
            ++i;
        }
        this.tpl.setVar("domainlist", (Object)strb);
        this.tpl.setVar("domainname", dr.getDomainName());
        this.tpl.setVar("enable_pop3", dr.getEnable_POP3());
        this.tpl.setVar("enable_smtp", dr.getEnable_SMTP());
        this.tpl.setVar("smtp_after_pop3", dr.getSMTP_after_POP3());
        this.tpl.setVar("sessiontimeout", dr.getSessionTimeout());
        this.tpl.setVar("catchall", dr.getCatchAll());
        this.tpl.setVar("domainalias", dr.getDomainAlias());
        this.tpl.setVar("avscan", dr.getAVScan());
        this.tpl.setVar("quota_days", dr.getQuota_Days());
        this.tpl.setVar("quota_mb", dr.getQuota_MB());
        this.tpl.setVar("quota_mails", dr.getQuota_Mails());
        this.tpl.setVar("memo", dr.getMemo());
        this.tpl.setVar("ip_networks", StorageRecord.conv_networks2string(dr.getIP_Networks()).replace(';', '\n'));
        this.serve_page("wa1100", dr.getDomainName());
    }

    public void WA1101(String strAction) throws IOException {
        Vector vecDomains = this.smManager.domainReadAll();
        int i = 0;
        while (i < vecDomains.size()) {
            DomainRecord dr = this.smManager.domainRead((String)vecDomains.elementAt(i));
            vecDomains.setElementAt(dr, i);
            ++i;
        }
        this.tpl.setVar("dom", (Object)vecDomains);
        this.serve_page("wa1101");
    }

    public void WA1200(String string) throws IOException {
        String strAction;
        String strDomain = this.reqGetParameter("domain_used", "");
        DomainRecord dr = this.smManager.domainRead(strDomain);
        if (dr == null) {
            this.tpl.setVar("alert", "Invalid domain '" + strDomain + "'");
            this.serve_page("wa1200", "User management");
            return;
        }
        String strUser = null;
        UserRecord ur = null;
        if (string.equals("store")) {
            strUser = this.reqGetParameter("userinput", null);
            strUser = String.valueOf(strUser) + "@" + strDomain;
        } else {
            strUser = this.reqGetParameter("userlist", null);
        }
        BayesianFilterConfig bfc = new BayesianFilterConfig();
        String s = this.smManager.keyDataRead("BAYESIAN_FILTER_CONFIG", strUser, "config");
        if (s != null) {
            bfc.recordImport(s);
        }
        if (string.equals("userlist")) {
            ur = this.smManager.userRead(strUser);
        }
        if (string.equals("update") || string.equals("store")) {
            try {
                ur = new UserRecord();
                ur.setUserName(strUser);
                ur.setAllowXREN(this.reqGetParameterBoolean("allowxren", false));
                ur.setCopy(StorageRecord.conv_string2array(this.reqGetParameter("copy", "").replace('\n', ';')));
                ur.setEnabled(this.reqGetParameterBoolean("enabled", false));
                ur.setIP_Networks(StorageRecord.conv_string2networks(this.reqGetParameter("ip_networks", "").replace(';', '\n')));
                ur.setMemo(this.reqGetParameter("memo", ""));
                ur.setPassWord(this.reqGetParameter("password", ""));
                ur.setPrivilege(this.reqGetParameterInt("privilege", 0));
                ur.setQuota_Days(this.reqGetParameterInt("quota_days", 0));
                ur.setQuota_Mails(this.reqGetParameterInt("quota_mails", 0));
                ur.setQuota_MB(this.reqGetParameterInt("quota_mb", 0));
                ur.setQuota_Usage(this.reqGetParameterInt("quota_usage", 0));
                ur.setRedirect(this.reqGetParameter("redirect", ""));
                ur.setRestrictIP_POP3(this.reqGetParameterInt("restrictip_pop3", 0));
                ur.setRestrictIP_SMTP(this.reqGetParameterInt("restrictip_smtp", 0));
                ur.setSessionTimeout(this.reqGetParameterInt("sessiontimeout", 0));
                ur.setSMTP_after_POP3(this.reqGetParameterInt("smtp_after_pop3", 0));
                this.smManager.userWrite(ur);
                bfc.setProbability_1(this.reqGetParameterInt("bayes_prob_1", 100));
                bfc.setAction_1(this.reqGetParameterInt("bayes_action_1", 2));
                bfc.setProbability_2(this.reqGetParameterInt("bayes_prob_2", 100));
                bfc.setAction_2(this.reqGetParameterInt("bayes_action_2", 2));
                bfc.setEMail(this.reqGetParameter("bayes_email", ""));
                bfc.setMarker(this.reqGetParameter("bayes_marker", "**SPAM**"));
                bfc.setWordListSource(this.reqGetParameter("bayes_usefilter", ""));
                this.smManager.keyDataWrite("BAYESIAN_FILTER_CONFIG", strUser, "config", bfc.recordExport());
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        if (string.equals("delete")) {
            try {
                this.smManager.userDelete(strUser);
                strAction = "";
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        StringBuffer strb = new StringBuffer();
        Vector vecUsers = this.smManager.userReadAllByDomain(strDomain);
        if (strAction.length() == 0 && vecUsers.size() > 0) {
            strUser = (String)vecUsers.elementAt(0);
        }
        int i = 0;
        while (i < vecUsers.size()) {
            String str = (String)vecUsers.elementAt(i);
            strb.append("<option ");
            if (str.equals(strUser)) {
                strb.append("selected ");
            }
            strb.append("value=\"" + str + "\">" + HelperExtract.splitUserName_getUser((String)str) + "</option>\r\n");
            ++i;
        }
        ur = vecUsers.size() != 0 ? this.smManager.userRead(strUser) : new UserRecord();
        this.tpl.setVar("userlist", (Object)strb);
        this.tpl.setVar("domain_used", strDomain);
        this.tpl.setVar("username", HelperExtract.splitUserName_getUser((String)ur.getUserName()));
        this.tpl.setVar("allowxren", ur.getAllowXREN());
        this.tpl.setVar("copy", StorageRecord.conv_array2string(ur.getCopy()).replace(';', '\n'));
        this.tpl.setVar("enabled", ur.getEnabled());
        this.tpl.setVar("ip_networks", StorageRecord.conv_networks2string(ur.getIP_Networks()).replace(';', '\n'));
        Date dat = new Date(ur.getLastMailReceived());
        if (dat.getTime() != 0L) {
            this.tpl.setVar("lastmailreceived", String.valueOf(this.sdfDate.format(dat)) + " " + this.sdfTime.format(dat));
        } else {
            this.tpl.setVar("lastmailreceived", "");
        }
        this.tpl.setVar("memo", ur.getMemo());
        this.tpl.setVar("password", ur.getPassWord());
        this.tpl.setVar("pop3_ip", InetAddress.getByName(ur.getPOP3_IP()).toString());
        dat = new Date(ur.getPOP3_Time());
        if (dat.getTime() != 0L) {
            this.tpl.setVar("pop3_time", String.valueOf(this.sdfDate.format(dat)) + " " + this.sdfTime.format(dat));
        } else {
            this.tpl.setVar("pop3_time", "");
        }
        this.tpl.setVar("privilege", ur.getPrivilege());
        this.tpl.setVar("quota_days", ur.getQuota_Days());
        this.tpl.setVar("quota_mails", ur.getQuota_Mails());
        this.tpl.setVar("quota_mb", ur.getQuota_MB());
        this.tpl.setVar("quota_usage", ur.getQuota_Usage());
        this.tpl.setVar("redirect", ur.getRedirect());
        this.tpl.setVar("restrictip_pop3", ur.getRestrictIP_POP3());
        this.tpl.setVar("restrictip_smtp", ur.getRestrictIP_SMTP());
        this.tpl.setVar("sessiontimeout", ur.getSessionTimeout());
        this.tpl.setVar("smtp_after_pop3", ur.getSMTP_after_POP3());
        this.tpl.setVar("bayes_prob_1", bfc.getProbability_1());
        this.tpl.setVar("bayes_action_1", bfc.getAction_1());
        this.tpl.setVar("bayes_prob_2", bfc.getProbability_2());
        this.tpl.setVar("bayes_action_2", bfc.getAction_2());
        this.tpl.setVar("bayes_email", bfc.getEMail());
        this.tpl.setVar("bayes_marker", bfc.getMarker());
        this.tpl.setVar("bayes_usefilter", bfc.getWordListSource());
        this.serve_page("wa1200", "User / " + strDomain);
    }

    public void WA1201(String strAction) throws IOException {
        Vector vecUsers = this.smManager.userReadAllByDomain(this.reqGetParameter("domain", ""));
        int i = 0;
        while (i < vecUsers.size()) {
            UserRecord ur = this.smManager.userRead((String)vecUsers.elementAt(i));
            vecUsers.setElementAt(ur, i);
            ++i;
        }
        this.tpl.setVar("usr", (Object)vecUsers);
        this.serve_page("wa1201");
    }

    public void WA1250(String string) throws IOException {
        String strAction;
        HTMLFormatCodec htmlformat = new HTMLFormatCodec();
        String strTmp = null;
        StringBuffer strb = new StringBuffer();
        String strUser = this.reqGetParameter("user", "");
        this.tpl.setVar("user", strUser);
        strb.setLength(0);
        BayesianRBLRecord brr = new BayesianRBLRecord();
        String strServer = this.reqGetParameter("rbllist", "");
        if (string.equals("del_rbl")) {
            this.smManager.keyDataDelete("BAYESIAN_RBL_RECORD", strUser, strServer);
            strAction = "";
        }
        if (strAction.equals("sto_rbl")) {
            strServer = this.reqGetParameter("rbl_server", "");
            brr.setServer(strServer);
            brr.setUserName(strUser);
            brr.setResponse(this.reqGetParameter("rbl_response", ""));
            brr.setProbability(this.reqGetParameterInt("rbl_probability", 50));
            strServer = String.valueOf(brr.getServer()) + " / " + brr.getResponse();
            this.smManager.keyDataWrite("BAYESIAN_RBL_RECORD", strUser, strServer, brr.recordExport());
        }
        Vector vecServer = this.smManager.keyDataReadAll("BAYESIAN_RBL_RECORD", strUser);
        if (strAction.length() == 0 && vecServer.size() > 0) {
            strServer = (String)vecServer.elementAt(0);
        }
        int i = 0;
        while (i < vecServer.size()) {
            String str = (String)vecServer.elementAt(i);
            strb.append("<option ");
            if (str.equals(strServer)) {
                strb.append("selected ");
            }
            str = htmlformat.encode(str);
            strb.append("value=\"" + str + "\">" + str + "</option>\r\n");
            ++i;
        }
        if (!strAction.equals("new_rbl") && (strTmp = this.smManager.keyDataRead("BAYESIAN_RBL_RECORD", strUser, strServer)) != null) {
            brr.recordImport(strTmp);
        }
        this.tpl.setVar("rbllist", strb.toString());
        this.tpl.setVar("rbl_server", brr.getServer());
        this.tpl.setVar("rbl_response", brr.getResponse());
        this.tpl.setVar("rbl_probability", brr.getProbability());
        strb.setLength(0);
        BayesianFilterRecord bfr = new BayesianFilterRecord();
        String strWord = this.reqGetParameter("wordlist", "");
        if (strAction.equals("del_word")) {
            this.smManager.keyDataDelete("BAYESIAN_FILTER_RECORD", strUser, strWord);
            strAction = "";
        }
        if (strAction.equals("sto_word")) {
            strWord = this.reqGetParameter("word", "");
            bfr.setWord(strWord);
            bfr.setUserName(strUser);
            bfr.setTimesUsed(0L);
            bfr.setLastUsed(0L);
            bfr.setProbability(this.reqGetParameterInt("word_probability", 50));
            bfr.setTestHeader(this.reqGetParameterBoolean("word_testheader", false));
            bfr.setTestBody(this.reqGetParameterBoolean("word_testbody", false));
            this.smManager.keyDataWrite("BAYESIAN_FILTER_RECORD", strUser, strWord, bfr.recordExport());
        }
        Vector vecWords = this.smManager.keyDataReadAll("BAYESIAN_FILTER_RECORD", strUser);
        if (strAction.length() == 0 && vecWords.size() > 0) {
            strWord = (String)vecWords.elementAt(0);
        }
        int i2 = 0;
        while (i2 < vecWords.size()) {
            String str = (String)vecWords.elementAt(i2);
            strb.append("<option ");
            if (str.equals(strWord)) {
                strb.append("selected ");
            }
            str = htmlformat.encode(str);
            strb.append("value=\"" + str + "\">" + str + "</option>\r\n");
            ++i2;
        }
        if (!strAction.equals("new_word") && (strTmp = this.smManager.keyDataRead("BAYESIAN_FILTER_RECORD", strUser, strWord)) != null) {
            bfr.recordImport(strTmp);
        }
        this.tpl.setVar("wordlist", strb.toString());
        this.tpl.setVar("word", htmlformat.encode(bfr.getWord()));
        this.tpl.setVar("word_ref", bfr.getTimesUsed());
        if (bfr.getLastUsed() > 0L) {
            this.tpl.setVar("word_used", String.valueOf(this.sdfDate.format(new Date(bfr.getLastUsed()))) + " / " + this.sdfTime.format(new Date(bfr.getLastUsed())));
        } else {
            this.tpl.setVar("word_used", "--");
        }
        this.tpl.setVar("word_probability", bfr.getProbability());
        this.tpl.setVar("word_testheader", bfr.getTestHeader());
        this.tpl.setVar("word_testbody", bfr.getTestBody());
        this.tpl.setVar("domainpart", HelperExtract.splitUserName_getDomain((String)strUser));
        this.serve_page("wa1250", "Bayes / " + strUser);
    }

    public void WA1300(String string) throws IOException {
        String strAction;
        FetchmailRecord fr = new FetchmailRecord();
        String strUser = null;
        strUser = string.equals("store") ? this.reqGetParameter("userinput", null) : this.reqGetParameter("userlist", null);
        if (string.equals("userlist")) {
            fr.recordImport(this.smManager.keyDataRead("FETCHMAIL_RECORD", strUser, ""));
        }
        if (string.equals("update") || string.equals("store")) {
            try {
                fr.setUserFrom(strUser);
                fr.setHost(this.reqGetParameter("host", ""));
                fr.setPassword(this.reqGetParameter("password", ""));
                fr.setPollFrequency(this.reqGetParameterInt("frequency", 0));
                fr.setUserFrom(strUser);
                fr.setUserTo(this.reqGetParameter("userto", ""));
                this.smManager.keyDataWrite("FETCHMAIL_RECORD", strUser, "", fr.recordExport());
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        if (string.equals("delete")) {
            try {
                this.smManager.keyDataDelete("FETCHMAIL_RECORD", strUser, "");
                strAction = "";
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        StringBuffer strb = new StringBuffer();
        Vector vecRecords = this.smManager.keyDataReadAll("FETCHMAIL_RECORD", "");
        if (strAction.length() == 0 && vecRecords.size() > 0) {
            strUser = (String)vecRecords.elementAt(0);
            fr.recordImport(this.smManager.keyDataRead("FETCHMAIL_RECORD", strUser, ""));
        }
        int i = 0;
        while (i < vecRecords.size()) {
            String str = (String)vecRecords.elementAt(i);
            strb.append("<option ");
            if (str.equals(strUser)) {
                strb.append("selected ");
            }
            strb.append("value=\"" + str + "\">" + str + "</option>\r\n");
            ++i;
        }
        this.tpl.setVar("userlist", (Object)strb);
        this.tpl.setVar("username", fr.getUserFrom());
        this.tpl.setVar("host", fr.getHost());
        this.tpl.setVar("password", fr.getPassword());
        this.tpl.setVar("frequency", fr.getPollFrequency());
        this.tpl.setVar("userto", fr.getUserTo());
        this.serve_page("wa1300", fr.getUserFrom());
    }

    public void WA1400(String string) throws IOException {
        String strAction;
        FilterRecord fr = new FilterRecord();
        String strFilter = null;
        strFilter = string.equals("store") ? this.reqGetParameter("filterinput", null) : this.reqGetParameter("filterlist", null);
        if (string.equals("filterlist")) {
            fr = this.smManager.filterRead(strFilter);
        }
        if (string.equals("update") || string.equals("store")) {
            try {
                fr.setName(strFilter);
                fr.setFilterType(this.reqGetParameterInt("filtertype", 1));
                fr.setMask(this.reqGetParameter("mask", ""));
                fr.setAVScan(this.reqGetParameterBoolean("avscan", false));
                fr.setRBLcheck(this.reqGetParameterBoolean("rblcheck", false));
                fr.setMemo(this.reqGetParameter("memo", ""));
                this.smManager.filterWrite(fr);
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        if (string.equals("delete")) {
            try {
                this.smManager.filterDelete(strFilter);
                strAction = "";
            }
            catch (Throwable t) {
                this.tpl.setVar("alert", t.getMessage());
            }
        }
        StringBuffer strb = new StringBuffer();
        Vector vecRecords = this.smManager.filterReadAll();
        if (strAction.length() == 0 && vecRecords.size() > 0) {
            strFilter = (String)vecRecords.elementAt(0);
            fr = this.smManager.filterRead(strFilter);
        }
        int i = 0;
        while (i < vecRecords.size()) {
            String str = (String)vecRecords.elementAt(i);
            strb.append("<option ");
            if (str.equals(strFilter)) {
                strb.append("selected ");
            }
            strb.append("value=\"" + str + "\">" + str + "</option>\r\n");
            ++i;
        }
        this.tpl.setVar("filterlist", (Object)strb);
        this.tpl.setVar("filtername", fr.getName());
        this.tpl.setVar("filtertype", fr.getFilterType());
        this.tpl.setVar("mask", fr.getMask());
        this.tpl.setVar("avscan", fr.getAVScan());
        this.tpl.setVar("rblcheck", fr.getRBLCheck());
        this.tpl.setVar("memo", fr.getMemo());
        this.serve_page("wa1400", fr.getName());
    }

    public void WA1900(String strAction) throws IOException {
        String strIP_From = this.reqGetParameter("ip_from", "").trim();
        String strIP_To = this.reqGetParameter("ip_to", "").trim();
        this.tpl.setVar("ip_from", strIP_From);
        this.tpl.setVar("ip_to", strIP_To);
        this.tpl.setVar("lwb_ip", "---.---.---.---");
        this.tpl.setVar("upb_ip", "---.---.---.---");
        this.tpl.setVar("netmask", "---.---.---.--- /--");
        boolean blnError = false;
        if (strAction.equals("calc")) {
            long lngIP_From = 0L;
            long lngIP_To = 0L;
            try {
                lngIP_From = IP_Network.stringToLong((String)strIP_From);
            }
            catch (Throwable throwable) {
                blnError = true;
            }
            try {
                lngIP_To = IP_Network.stringToLong((String)strIP_To);
            }
            catch (Throwable throwable) {
                try {
                    lngIP_To = lngIP_From + (long)Integer.parseInt(strIP_To);
                }
                catch (NumberFormatException numberFormatException) {
                    blnError = true;
                }
            }
            if (!blnError) {
                long lngDiff = lngIP_To - lngIP_From + 1L;
                int intY = (int)Math.ceil(Math.log(lngDiff) / Math.log(2.0));
                this.tpl.setVar("lwb_ip", IP_Network.longToString((long)lngIP_From));
                this.tpl.setVar("upb_ip", IP_Network.longToString((long)lngIP_To));
                this.tpl.setVar("netmask", String.valueOf(IP_Network.longToString((long)(-1L << intY & 0xFFFFFFFFL))) + " /" + (32 - intY));
            }
        }
        this.serve_page("wa1900");
    }

    public void WA1901(String strAction) throws IOException {
        Whois who = new Whois();
        this.tpl.setVar("whois_query", "");
        this.tpl.setVar("whois_result", "");
        this.tpl.setVar("query", "");
        WhoisResult wr = null;
        String strQuery = this.req.getParameter("query");
        if (strQuery == null || strQuery.length() == 0) {
            this.serve_page("wa1901", "Whois");
            return;
        }
        this.tpl.setVar("query", strQuery);
        wr = who.query(strQuery);
        if (wr.intResult == 1) {
            this.tpl.setVar("whois_query", "<b>No WHOIS service known for '" + who.getCountry(strQuery, "<unknown>") + "'</b>");
            this.serve_page("wa1901", "Whois");
            return;
        }
        if (wr.ws.intQueryType == 3) {
            this.res.sendRedirect(String.valueOf(wr.ws.strWhoisHost) + wr.ws.strQuery);
            return;
        }
        if (wr.intResult != 0) {
            this.tpl.setVar("whois_query", "<b>" + wr.strErrorMessage + "</b>");
            this.serve_page("wa1901", "Whois");
            return;
        }
        this.tpl.setVar("whois_query", "Asked '" + wr.inaServer.toString() + "'");
        if (wr.ws.intQueryType == 0) {
            StringBuffer strb = new StringBuffer();
            int i = 0;
            while (i < wr.strAnswer.length) {
                strb.append(wr.strAnswer[i]);
                strb.append("<br>");
                ++i;
            }
            this.tpl.setVar("whois_result", strb.toString());
        } else {
            StringBuffer strb = new StringBuffer();
            int i = 0;
            while (i < wr.strAnswer.length) {
                strb.append(wr.strAnswer[i]);
                ++i;
            }
            this.tpl.setTextCodecEnabled(false);
            this.tpl.setVar("whois_result", strb.toString());
            this.tpl.setTextCodecEnabled(true);
        }
        this.serve_page("wa1901");
    }

    public void WA1902(String strAction) throws IOException {
        Vector<String> vecServers = new Vector<String>();
        String strServer = this.reqGetParameter("server", "").trim();
        String strIP = this.reqGetParameter("ip", "").trim();
        this.tpl.setVar("server", strServer);
        this.tpl.setVar("ip", strIP);
        if (strServer.length() == 0) {
            File fl = new File(this.strFILERESDIR, "rbl.txt");
            if (!fl.exists()) {
                this.tpl.setVar("result", "'" + fl.getPath() + "' is missing.");
                this.serve_page("wa1902");
                return;
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(fl));
                while ((strServer = br.readLine()) != null) {
                    if ((strServer = String.valueOf(strServer.trim()) + "#").length() < 4 || "#;!".indexOf(strServer.charAt(0)) != -1) continue;
                    strServer = HelperExtract.getLeft((String)strServer, (String)"#").trim();
                    vecServers.addElement(strServer);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                HelperIO.close(br);
                throw throwable;
            }
            Object var7_9 = null;
            HelperIO.close((Object)br);
        } else {
            vecServers.addElement(strServer);
        }
        RBLCheck rbl = new RBLCheck(null, this.cnfConfig);
        StringBuffer strb = new StringBuffer();
        strb.append("<table border=\"0\" cellpadding=\"1\">\n");
        strb.append("<tr><td>Server</td><td>Qry/ms</td><td>Result</td><td>Text</td></tr>\n");
        int i = 0;
        while (i < vecServers.size()) {
            strServer = (String)vecServers.elementAt(i);
            rbl.check(strIP, strServer, "");
            strb.append("<tr><td>");
            strb.append(strServer);
            strb.append("</td><td align=\"right\">");
            strb.append(rbl.getTime());
            strb.append("&nbsp;&nbsp;");
            strb.append("</td><td>");
            strb.append(rbl.getIPMessage());
            strb.append("</td><td>");
            strb.append(rbl.getMessage());
            strb.append("</td></tr>");
            ++i;
        }
        strb.append("</table>");
        this.tpl.setVar("result", strb.toString());
        this.serve_page("wa1902");
    }

    public void WA2000(String strAction) throws IOException {
        if (!strAction.equals("status")) {
            this.serve_page("WA2000");
            return;
        }
        StatisticsRecord sr = this.smManager.statsGet();
        long lngRuntimeH = (sr.lngTimeCurrent - sr.lngTimeStarted) / 1000L / 3600L;
        if (lngRuntimeH == 0L) {
            lngRuntimeH = 1L;
        }
        Date dat = new Date(sr.lngTimeCurrent);
        this.sos.println("servertime=" + this.sdfDate.format(dat) + " " + this.sdfTime.format(dat));
        dat = new Date(sr.lngTimeStarted);
        this.sos.println("started=" + this.sdfDate.format(dat) + " " + this.sdfTime.format(dat));
        this.sos.println("running=" + HelperDT.getRuntimeDHMS((long)(sr.lngTimeCurrent - sr.lngTimeStarted)));
        this.sos.println("mem_avail=" + HelperFormat.formatMemoryString((long)sr.lngMemory_total));
        this.sos.println("mem_free=" + HelperFormat.formatMemoryString((long)sr.lngMemory_free));
        this.sos.println("pop3_t_access=" + sr.lngPOP3_accesses);
        this.sos.println("pop3_t_bytes=" + HelperFormat.formatMemoryString((long)sr.lngPOP3_bytes));
        this.sos.println("pop3_t_peak=" + sr.intPOP3_peak);
        this.sos.println("pop3_t_max=" + this.cnfConfig.intPOP3_Instances);
        this.sos.println("pop3_h_access=" + sr.lngPOP3_accesses / lngRuntimeH);
        this.sos.println("pop3_h_bytes=" + HelperFormat.formatMemoryString((long)(sr.lngPOP3_bytes / lngRuntimeH)));
        this.sos.println("smtp_t_access=" + sr.lngSMTP_accesses);
        this.sos.println("smtp_t_bytes=" + HelperFormat.formatMemoryString((long)sr.lngSMTP_bytes));
        this.sos.println("smtp_t_peak=" + sr.intSMTP_peak);
        this.sos.println("smtp_t_max=" + this.cnfConfig.intSMTP_Instances);
        this.sos.println("smtp_h_access=" + sr.lngSMTP_accesses / lngRuntimeH);
        this.sos.println("smtp_h_bytes=" + HelperFormat.formatMemoryString((long)(sr.lngSMTP_bytes / lngRuntimeH)));
        this.sos.println("fwd_t_access=" + sr.lngFWD_accesses);
        this.sos.println("fwd_t_bytes=" + HelperFormat.formatMemoryString((long)sr.lngFWD_bytes));
        this.sos.println("fwd_t_peak=" + sr.intFWD_peak);
        this.sos.println("fwd_t_max=" + this.cnfConfig.intFWD_Instances);
        this.sos.println("fwd_h_access=" + sr.lngFWD_accesses / lngRuntimeH);
        this.sos.println("fwd_h_bytes=" + HelperFormat.formatMemoryString((long)(sr.lngFWD_bytes / lngRuntimeH)));
        this.sos.println("mpa_peak=" + sr.intMPA_peak);
        this.sos.println("mpa_max=" + this.cnfConfig.intMPA_Instances);
        this.res.setHeader("Connection", "close");
    }

    public void WA2001(String strAction) throws IOException {
        if (this.reqGetParameter("download", null) != null) {
            String strLogfile = Configuration.logContext.getCurrentLogFile();
            this.serve_file_raw(strLogfile, HelperPath.splitPath_getFile((String)strLogfile));
            return;
        }
        if (!strAction.equals("logfile")) {
            this.serve_page("WA2001");
            return;
        }
        String strLines = this.reqGetParameter("lines", null);
        int intLines = HelperExtract.getNumeric((String)strLines, (int)20);
        String[] strLog = this.smManager.logGet();
        int intUpb = strLog.length;
        int intLwb = Math.max(strLog.length - intLines, 0);
        StringBuffer strbLog = new StringBuffer();
        System.out.println(intUpb - intLwb);
        int i = intLwb;
        while (i < intUpb) {
            String s = HelperFilter.replaceMore((String)strLog[i], (String)"\r", (String)"");
            strbLog.append(this.htmlcodec.encode(s));
            strbLog.append("<br>");
            ++i;
        }
        this.sos.println(strbLog.toString());
        this.res.setHeader("Connection", "close");
    }

    public void WA2002(String strAction) throws IOException {
        if (strAction.equals("restart_intern")) {
            this.res.sendRedirect("/");
            this.smManager.adminRestart();
            return;
        }
        if (strAction.equals("restart_extern")) {
            this.res.sendRedirect("/");
            this.smManager.adminFullRestart();
            return;
        }
        if (strAction.equals("shutdown_mta")) {
            this.res.sendRedirect("/");
            this.smManager.adminShutdown();
            return;
        }
        this.serve_page("wa2002");
    }

    public void WA2010(String string) throws IOException {
        MailHeaderRecord mhr;
        int intMail;
        String strAction;
        String strSelectedDomain = this.reqGetParameter("domainlist", "");
        String strSelectedUser = this.reqGetParameter("userlist", "");
        String strSelectedMail = this.reqGetParameter("maillist", "");
        if (!HelperExtract.splitUserName_getDomain((String)strSelectedUser).equals(strSelectedDomain)) {
            strSelectedMail = "";
            strSelectedUser = "";
        }
        Vector vecMails = (Vector)this.session.getAttribute("COLLECTED_MAILS");
        if (string.equals("getmail")) {
            int intMail2 = this.reqGetParameterInt("mailnb", -1);
            if (intMail2 != -1) {
                MailHeaderRecord mhr2 = (MailHeaderRecord)vecMails.elementAt(intMail2);
                LineWriter lw = new LineWriter((OutputStream)this.sos);
                POP3OutputWriter out = new POP3OutputWriter(lw, 200);
                out.write("<pre>");
                this.smManager.mailReadBody(mhr2, out);
                out.write("</pre>");
                return;
            }
            this.sos.println("&nbsp;");
            return;
        }
        if (string.equals("fetchmail")) {
            this.smManager.adminForceFetchmail();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            strAction = "reload";
        }
        if (strAction.equals("cleanup")) {
            MTAEventQueue.postEvent(new CleanupEvent());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            strAction = "reload";
        }
        this.tpl.setVar("mails", "");
        this.tpl.setVar("time_read", "");
        this.tpl.setVar("time_sort", "");
        if (strAction.equals("reload")) {
            long l = TimeFactory.getTime();
            Configuration.logContext.write("D Get headers");
            vecMails = this.smManager.mailGetAllHeaders();
            this.tpl.setVar("mails", vecMails.size());
            this.tpl.setVar("time_read", (TimeFactory.getTime() - l) / 1000L);
            l = TimeFactory.getTime();
            Configuration.logContext.write("D Got headers, sorting " + vecMails.size() + " mails");
            HelperSort.quick((Vector)vecMails, (Comparator)new WA2010_SortMessages());
            this.tpl.setVar("time_sort", (TimeFactory.getTime() - l) / 1000L);
            Configuration.logContext.write("D Done");
            strSelectedDomain = "";
            strSelectedUser = "";
            strSelectedMail = "";
        }
        if (strAction.equals("save") && (intMail = HelperExtract.getNumeric((String)strSelectedMail, (int)-1)) != -1) {
            MailHeaderRecord mhr3 = (MailHeaderRecord)vecMails.elementAt(intMail);
            mhr3.setIsRelayMail(this.reqGetParameterBoolean("relayed", false));
            mhr3.setExternalMail(this.reqGetParameterBoolean("external", false));
            mhr3.setMailDeleted(this.reqGetParameterBoolean("deleted", false));
            mhr3.setMailLocked(this.reqGetParameterBoolean("locked", false));
            mhr3.setRetryCount(this.reqGetParameterInt("retries", 1));
            this.smManager.mailWriteHeader(mhr3);
        }
        this.session.setAttribute("COLLECTED_MAILS", (Object)vecMails);
        StringBuffer strbDomain = new StringBuffer();
        StringBuffer strbUser = new StringBuffer();
        StringBuffer strbMails = new StringBuffer();
        String strOldDomain = "";
        String strOldUser = "";
        String strOutboundDisplayPrefix = "";
        int intCntDomain = 0;
        int intCntUser = 0;
        int intCntMails = 0;
        if (vecMails != null) {
            int i = 0;
            while (i <= vecMails.size()) {
                mhr = null;
                String strDomain = "";
                String strUser = "";
                if (i < vecMails.size()) {
                    mhr = (MailHeaderRecord)vecMails.elementAt(i);
                    strDomain = HelperExtract.splitUserName_getDomain((String)mhr.getEnvelopeTo_Redirected()[0]);
                    strUser = mhr.getEnvelopeTo_Redirected()[0];
                    if (strSelectedDomain.length() == 0) {
                        strSelectedDomain = strDomain;
                    }
                    if (strSelectedUser.length() == 0 && strSelectedDomain.equals(strDomain)) {
                        strSelectedUser = strUser;
                        strSelectedMail = Integer.toString(i);
                    }
                }
                if (!strOldDomain.equals(strDomain)) {
                    if (strOldDomain.length() > 0) {
                        strbDomain.append("<option ");
                        if (strOldDomain.equals(strSelectedDomain)) {
                            strbDomain.append("selected ");
                        }
                        strbDomain.append("value=\"");
                        strbDomain.append(strOldDomain);
                        strbDomain.append("\">");
                        strbDomain.append("[");
                        strbDomain.append(HelperFormat.rset((long)intCntDomain, (int)5, (char)'0'));
                        strbDomain.append("] ");
                        strbDomain.append(strOutboundDisplayPrefix);
                        strbDomain.append(strOldDomain);
                        strbDomain.append("</option>\r\n");
                    }
                    intCntDomain = 0;
                }
                if (!(strOldUser.equals(strUser) && strOldDomain.equals(strDomain) || !strOldDomain.equals(strSelectedDomain))) {
                    if (strOldUser.length() > 0) {
                        strbUser.append("<option ");
                        if (strOldUser.equals(strSelectedUser)) {
                            strbUser.append("selected ");
                        }
                        strbUser.append("value=\"");
                        strbUser.append(strOldUser);
                        strbUser.append("\">");
                        strbUser.append("[");
                        strbUser.append(HelperFormat.rset((long)intCntUser, (int)5, (char)'0'));
                        strbUser.append("] ");
                        strbUser.append(strOutboundDisplayPrefix);
                        strbUser.append(strOldUser);
                        strbUser.append("</option>\r\n");
                    }
                    intCntUser = 0;
                }
                if (!strOldUser.equals(strUser)) {
                    intCntUser = 0;
                }
                if (strUser.equals(strSelectedUser) && mhr != null) {
                    strbMails.append("<option ");
                    if (i == HelperExtract.getNumeric((String)strSelectedMail, (int)1)) {
                        strbMails.append("selected ");
                    }
                    strbMails.append("value=\"");
                    strbMails.append(Integer.toString(i));
                    strbMails.append("\">");
                    strbMails.append("[" + HelperFormat.rset((long)(++intCntMails), (int)5, (char)'0') + "] ");
                    strbMails.append(mhr.toString());
                    strbMails.append("</option>\r\n");
                }
                strOldDomain = strDomain;
                ++intCntDomain;
                strOldUser = strUser;
                ++intCntUser;
                if (mhr != null && mhr.getExternalMail() && strOutboundDisplayPrefix.length() == 0) {
                    strOutboundDisplayPrefix = "OUT: ";
                }
                ++i;
            }
        }
        if (vecMails != null && vecMails.size() == 0) {
            strbDomain.append("<option>----</option>\r\n");
            strbUser.append("<option>----</option>\r\n");
            strbMails.append("<option>----</option>\r\n");
        }
        this.tpl.setVar("domainlist", strbDomain.toString());
        this.tpl.setVar("userlist", strbUser.toString());
        this.tpl.setVar("maillist", strbMails.toString());
        this.tpl.setVar("size", "");
        this.tpl.setVar("relayed", false);
        this.tpl.setVar("external", false);
        this.tpl.setVar("deleted", false);
        this.tpl.setVar("locked", false);
        this.tpl.setVar("received", "");
        this.tpl.setVar("picked", "");
        this.tpl.setVar("retries", "");
        this.tpl.setVar("next_retry", "");
        int intMail3 = HelperExtract.getNumeric((String)strSelectedMail, (int)-1);
        this.tpl.setVar("mailnb", intMail3);
        if (intMail3 != -1) {
            mhr = (MailHeaderRecord)vecMails.elementAt(intMail3);
            Date dat = null;
            this.tpl.setVar("size", HelperFormat.formatMemoryString((long)mhr.getMailSize()));
            this.tpl.setVar("relayed", mhr.getIsRelayMail());
            this.tpl.setVar("external", mhr.getExternalMail());
            this.tpl.setVar("deleted", mhr.getMailDeleted());
            this.tpl.setVar("locked", mhr.getMailLocked());
            dat = new Date(mhr.getTimeReceived());
            this.tpl.setVar("received", String.valueOf(this.sdfDate.format(dat)) + "/" + this.sdfTime.format(dat));
            if (mhr.getTimeFetched() > 0L) {
                dat = new Date(mhr.getTimeFetched());
                this.tpl.setVar("picked", String.valueOf(this.sdfDate.format(dat)) + "/" + this.sdfTime.format(dat));
            } else {
                this.tpl.setVar("picked", "-/-");
            }
            this.tpl.setVar("retries", mhr.getRetryCount());
            if (mhr.getTimeNextRetry() > 0L && mhr.getExternalMail()) {
                dat = new Date(mhr.getTimeNextRetry());
                this.tpl.setVar("next_retry", String.valueOf(this.sdfDate.format(dat)) + "/" + this.sdfTime.format(dat));
            } else {
                this.tpl.setVar("next_retry", "-/-");
            }
        }
        this.serve_page("wa2010");
    }
}

