/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.awt;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.util.Vector;
import net.zerotoaster.mta.admin.awt.ConfigFrame;
import net.zerotoaster.mta.admin.awt.MessageBox;
import net.zerotoaster.mta.admin.awt.PrivilegeChanged;
import net.zerotoaster.mta.admin.awt.StateChangeEvent;
import net.zerotoaster.mta.admin.awt.StateChangeListener;
import net.zerotoaster.mta.admin.awt.StructurePanel;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.util.Helper;

public class ConfigFilter
extends ConfigFrame
implements ActionListener,
ItemListener,
WindowListener,
StateChangeListener {
    private Menu ivjmnuFile = null;
    private MenuItem ivjmnuQuit = null;
    private Button ivjbtnCancel = null;
    private Button ivjbtnDelete = null;
    private Button ivjbtnNew = null;
    private Button ivjbtnStore = null;
    private StructurePanel ivjspnlConfig = null;
    private StructurePanel ivjspnlMemo = null;
    private StructurePanel ivjspnlName = null;
    private TextArea ivjtxtMemo = null;
    private TextField ivjtxtName = null;
    private Label ivjLabel1 = null;
    private Label ivjLabel11 = null;
    private Label ivjlblRuleType = null;
    private Button ivjbtnHelp = null;
    private Choice ivjchsFilterType = null;
    private List ivjlstFilters = null;
    private TextField ivjtxtMask = null;
    private MenuBar ivjConfigFilterMenuBar = null;
    private StructurePanel ivjspnlFilterList = null;
    private Checkbox ivjchkAVScan = null;
    private Checkbox ivjchkRBL = null;
    static Class class$java$awt$Window;

    public ConfigFilter() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getmnuQuit()) {
            this.connEtoC1();
        }
    }

    public void chsFilterType_ItemStateChanged() {
        int i = this.ivjchsFilterType.getSelectedIndex() + 1;
        switch (i) {
            case 1: {
                this.ivjchkAVScan.setEnabled(true);
                this.ivjchkRBL.setEnabled(true);
                break;
            }
            case 2: 
            case 3: {
                this.ivjchkAVScan.setEnabled(false);
                this.ivjchkRBL.setEnabled(false);
            }
        }
    }

    private void connEtoC1() {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(WindowEvent arg1) {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.lstFilters_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ItemEvent arg1) {
        try {
            this.chsFilterType_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    void copyFRtoGUI(FilterRecord fr) {
        ((TextComponent)this.ivjtxtName).setText(fr.getName());
        ((TextComponent)this.ivjtxtMask).setText(fr.getMask());
        this.ivjchsFilterType.select(fr.getFilterType() - 1);
        this.chsFilterType_ItemStateChanged();
        this.ivjtxtMemo.setText(fr.getMemo());
        this.ivjchkAVScan.setState(fr.getAVScan());
        this.ivjchkRBL.setState(fr.getRBLCheck());
        switch (fr.getType()) {
            case 2: {
                this.ivjlblRuleType.setText("Filter by domain");
                break;
            }
            case 3: {
                this.ivjlblRuleType.setText("Filter by network");
                break;
            }
            case 1: {
                this.ivjlblRuleType.setText("Filter by user");
                break;
            }
            default: {
                this.ivjlblRuleType.setText("Unknown filter type");
            }
        }
    }

    boolean copyGUItoFR(FilterRecord fr) {
        String strName = Helper.validateFileName(this.ivjtxtName.getText());
        if (strName == null) {
            MessageBox.OK(this, "Error", "Name is empty or invalid");
            this.ivjtxtName.requestFocus();
            return false;
        }
        fr.setName(strName);
        try {
            fr.setMask(this.ivjtxtMask.getText().trim());
        }
        catch (Throwable t) {
            MessageBox.OK(this, "Error", t.getMessage());
            this.ivjtxtMask.requestFocus();
            return false;
        }
        int i = this.ivjchsFilterType.getSelectedIndex();
        if (i == -1) {
            MessageBox.OK(this, "Error", "You must select a filter type");
            this.ivjchsFilterType.requestFocus();
            return false;
        }
        fr.setFilterType(i + 1);
        fr.setMemo(this.ivjtxtMemo.getText().trim());
        fr.setAVScan(this.ivjchkAVScan.getState());
        fr.setRBLcheck(this.ivjchkRBL.getState());
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private Button getbtnCancel() {
        if (this.ivjbtnCancel == null) {
            try {
                this.ivjbtnCancel = new Button();
                this.ivjbtnCancel.setName("btnCancel");
                this.ivjbtnCancel.setLabel("Cancel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnCancel;
    }

    private Button getbtnDelete() {
        if (this.ivjbtnDelete == null) {
            try {
                this.ivjbtnDelete = new Button();
                this.ivjbtnDelete.setName("btnDelete");
                this.ivjbtnDelete.setLabel("Delete");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnDelete;
    }

    private Button getbtnHelp() {
        if (this.ivjbtnHelp == null) {
            try {
                this.ivjbtnHelp = new Button();
                this.ivjbtnHelp.setName("btnHelp");
                this.ivjbtnHelp.setLabel("Help");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnHelp;
    }

    private Button getbtnNew() {
        if (this.ivjbtnNew == null) {
            try {
                this.ivjbtnNew = new Button();
                this.ivjbtnNew.setName("btnNew");
                this.ivjbtnNew.setLabel("New");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnNew;
    }

    private Button getbtnStore() {
        if (this.ivjbtnStore == null) {
            try {
                this.ivjbtnStore = new Button();
                this.ivjbtnStore.setName("btnStore");
                this.ivjbtnStore.setLabel("Store");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnStore;
    }

    private static void getBuilderData() {
    }

    private Checkbox getchkAVScan() {
        if (this.ivjchkAVScan == null) {
            try {
                this.ivjchkAVScan = new Checkbox();
                this.ivjchkAVScan.setName("chkAVScan");
                this.ivjchkAVScan.setLabel("AV Scan relay mail");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjchkAVScan;
    }

    private Checkbox getchkRBL() {
        if (this.ivjchkRBL == null) {
            try {
                this.ivjchkRBL = new Checkbox();
                this.ivjchkRBL.setName("chkRBL");
                this.ivjchkRBL.setLabel("RBL check relay mail");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjchkRBL;
    }

    private Choice getchsFilterType() {
        if (this.ivjchsFilterType == null) {
            try {
                this.ivjchsFilterType = new Choice();
                this.ivjchsFilterType.setName("chsFilterType");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjchsFilterType;
    }

    private MenuBar getConfigFilterMenuBar() {
        if (this.ivjConfigFilterMenuBar == null) {
            try {
                this.ivjConfigFilterMenuBar = new MenuBar();
                this.ivjConfigFilterMenuBar.setFont(new Font("dialog", 1, 12));
                this.ivjConfigFilterMenuBar.add(this.getmnuFile());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConfigFilterMenuBar;
    }

    private Label getLabel1() {
        if (this.ivjLabel1 == null) {
            try {
                this.ivjLabel1 = new Label();
                this.ivjLabel1.setName("Label1");
                this.ivjLabel1.setText("Mask: 'user@domain.tld', 'domain.tld'");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabel1;
    }

    private Label getLabel11() {
        if (this.ivjLabel11 == null) {
            try {
                this.ivjLabel11 = new Label();
                this.ivjLabel11.setName("Label11");
                this.ivjLabel11.setText("or 'network, netmask'.");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabel11;
    }

    private Label getlblRuleType() {
        if (this.ivjlblRuleType == null) {
            try {
                this.ivjlblRuleType = new Label();
                this.ivjlblRuleType.setName("lblRuleType");
                this.ivjlblRuleType.setFont(new Font("monospaced", 0, 12));
                this.ivjlblRuleType.setText(".");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblRuleType;
    }

    private List getlstFilters() {
        if (this.ivjlstFilters == null) {
            try {
                this.ivjlstFilters = new List(0);
                this.ivjlstFilters.setName("lstFilters");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlstFilters;
    }

    private Menu getmnuFile() {
        if (this.ivjmnuFile == null) {
            try {
                this.ivjmnuFile = new Menu();
                this.ivjmnuFile.setFont(new Font("dialog", 1, 12));
                this.ivjmnuFile.setLabel("File");
                this.ivjmnuFile.add(this.getmnuQuit());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjmnuFile;
    }

    private MenuItem getmnuQuit() {
        if (this.ivjmnuQuit == null) {
            try {
                this.ivjmnuQuit = new MenuItem();
                this.ivjmnuQuit.setFont(new Font("dialog", 1, 12));
                this.ivjmnuQuit.setLabel("Quit");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjmnuQuit;
    }

    private StructurePanel getspnlConfig() {
        GridBagConstraints constraintschsFilterType = new GridBagConstraints();
        GridBagConstraints constraintstxtMask = new GridBagConstraints();
        GridBagConstraints constraintsLabel1 = new GridBagConstraints();
        GridBagConstraints constraintsLabel11 = new GridBagConstraints();
        GridBagConstraints constraintslblRuleType = new GridBagConstraints();
        GridBagConstraints constraintschkAVScan = new GridBagConstraints();
        GridBagConstraints constraintschkRBL = new GridBagConstraints();
        if (this.ivjspnlConfig == null) {
            try {
                this.ivjspnlConfig = new StructurePanel();
                this.ivjspnlConfig.setName("spnlConfig");
                ((Component)this.ivjspnlConfig).setFont(new Font("dialog", 0, 12));
                this.ivjspnlConfig.setLayout(new GridBagLayout());
                this.ivjspnlConfig.setBorderText("Config");
                constraintschsFilterType.gridx = 0;
                constraintschsFilterType.gridy = 0;
                constraintschsFilterType.gridwidth = 1;
                constraintschsFilterType.gridheight = 1;
                constraintschsFilterType.fill = 2;
                constraintschsFilterType.anchor = 17;
                constraintschsFilterType.weightx = 0.0;
                constraintschsFilterType.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchsFilterType(), constraintschsFilterType);
                constraintstxtMask.gridx = 0;
                constraintstxtMask.gridy = 1;
                constraintstxtMask.gridwidth = 1;
                constraintstxtMask.gridheight = 1;
                constraintstxtMask.fill = 2;
                constraintstxtMask.anchor = 17;
                constraintstxtMask.weightx = 0.0;
                constraintstxtMask.weighty = 0.0;
                this.getspnlConfig().add((Component)this.gettxtMask(), constraintstxtMask);
                constraintsLabel1.gridx = 0;
                constraintsLabel1.gridy = 5;
                constraintsLabel1.gridwidth = 1;
                constraintsLabel1.gridheight = 1;
                constraintsLabel1.fill = 2;
                constraintsLabel1.anchor = 17;
                constraintsLabel1.weightx = 0.0;
                constraintsLabel1.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getLabel1(), constraintsLabel1);
                constraintsLabel11.gridx = 0;
                constraintsLabel11.gridy = 6;
                constraintsLabel11.gridwidth = 1;
                constraintsLabel11.gridheight = 1;
                constraintsLabel11.fill = 2;
                constraintsLabel11.anchor = 17;
                constraintsLabel11.weightx = 0.0;
                constraintsLabel11.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getLabel11(), constraintsLabel11);
                constraintslblRuleType.gridx = 0;
                constraintslblRuleType.gridy = 4;
                constraintslblRuleType.gridwidth = 1;
                constraintslblRuleType.gridheight = 1;
                constraintslblRuleType.fill = 2;
                constraintslblRuleType.anchor = 17;
                constraintslblRuleType.weightx = 0.0;
                constraintslblRuleType.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getlblRuleType(), constraintslblRuleType);
                constraintschkAVScan.gridx = 0;
                constraintschkAVScan.gridy = 2;
                constraintschkAVScan.gridwidth = 1;
                constraintschkAVScan.gridheight = 1;
                constraintschkAVScan.fill = 2;
                constraintschkAVScan.anchor = 17;
                constraintschkAVScan.weightx = 0.0;
                constraintschkAVScan.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchkAVScan(), constraintschkAVScan);
                constraintschkRBL.gridx = 0;
                constraintschkRBL.gridy = 3;
                constraintschkRBL.gridwidth = 1;
                constraintschkRBL.gridheight = 1;
                constraintschkRBL.fill = 2;
                constraintschkRBL.anchor = 17;
                constraintschkRBL.weightx = 0.0;
                constraintschkRBL.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchkRBL(), constraintschkRBL);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspnlConfig;
    }

    private StructurePanel getspnlFilterList() {
        GridBagConstraints constraintslstFilters = new GridBagConstraints();
        GridBagConstraints constraintsbtnNew = new GridBagConstraints();
        GridBagConstraints constraintsbtnStore = new GridBagConstraints();
        GridBagConstraints constraintsbtnCancel = new GridBagConstraints();
        GridBagConstraints constraintsbtnDelete = new GridBagConstraints();
        GridBagConstraints constraintsbtnHelp = new GridBagConstraints();
        if (this.ivjspnlFilterList == null) {
            try {
                this.ivjspnlFilterList = new StructurePanel();
                this.ivjspnlFilterList.setName("spnlFilterList");
                this.ivjspnlFilterList.setLayout(new GridBagLayout());
                this.ivjspnlFilterList.setBorderText("Filters");
                constraintslstFilters.gridx = 0;
                constraintslstFilters.gridy = 0;
                constraintslstFilters.gridwidth = 5;
                constraintslstFilters.gridheight = 1;
                constraintslstFilters.fill = 1;
                constraintslstFilters.anchor = 17;
                constraintslstFilters.weightx = 0.0;
                constraintslstFilters.weighty = 0.1;
                this.getspnlFilterList().add((Component)this.getlstFilters(), constraintslstFilters);
                constraintsbtnNew.gridx = 0;
                constraintsbtnNew.gridy = 1;
                constraintsbtnNew.gridwidth = 1;
                constraintsbtnNew.gridheight = 1;
                constraintsbtnNew.fill = 2;
                constraintsbtnNew.anchor = 17;
                constraintsbtnNew.weightx = 0.0;
                constraintsbtnNew.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnNew(), constraintsbtnNew);
                constraintsbtnStore.gridx = 1;
                constraintsbtnStore.gridy = 1;
                constraintsbtnStore.gridwidth = 1;
                constraintsbtnStore.gridheight = 1;
                constraintsbtnStore.fill = 2;
                constraintsbtnStore.anchor = 17;
                constraintsbtnStore.weightx = 0.0;
                constraintsbtnStore.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnStore(), constraintsbtnStore);
                constraintsbtnCancel.gridx = 2;
                constraintsbtnCancel.gridy = 1;
                constraintsbtnCancel.gridwidth = 1;
                constraintsbtnCancel.gridheight = 1;
                constraintsbtnCancel.fill = 2;
                constraintsbtnCancel.anchor = 17;
                constraintsbtnCancel.weightx = 0.0;
                constraintsbtnCancel.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnCancel(), constraintsbtnCancel);
                constraintsbtnDelete.gridx = 3;
                constraintsbtnDelete.gridy = 1;
                constraintsbtnDelete.gridwidth = 1;
                constraintsbtnDelete.gridheight = 1;
                constraintsbtnDelete.fill = 2;
                constraintsbtnDelete.anchor = 17;
                constraintsbtnDelete.weightx = 0.0;
                constraintsbtnDelete.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnDelete(), constraintsbtnDelete);
                constraintsbtnHelp.gridx = 4;
                constraintsbtnHelp.gridy = 1;
                constraintsbtnHelp.gridwidth = 1;
                constraintsbtnHelp.gridheight = 1;
                constraintsbtnHelp.fill = 2;
                constraintsbtnHelp.anchor = 17;
                constraintsbtnHelp.weightx = 0.0;
                constraintsbtnHelp.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnHelp(), constraintsbtnHelp);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspnlFilterList;
    }

    private StructurePanel getspnlMemo() {
        if (this.ivjspnlMemo == null) {
            try {
                this.ivjspnlMemo = new StructurePanel();
                this.ivjspnlMemo.setName("spnlMemo");
                ((Component)this.ivjspnlMemo).setFont(new Font("dialog", 0, 12));
                this.ivjspnlMemo.setLayout(new GridLayout());
                this.ivjspnlMemo.setBorderText("Memo");
                this.getspnlMemo().add((Component)this.gettxtMemo(), this.gettxtMemo().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspnlMemo;
    }

    private StructurePanel getspnlName() {
        GridBagConstraints constraintstxtName = new GridBagConstraints();
        if (this.ivjspnlName == null) {
            try {
                this.ivjspnlName = new StructurePanel();
                this.ivjspnlName.setName("spnlName");
                this.ivjspnlName.setLayout(new GridBagLayout());
                this.ivjspnlName.setBorderText("Name");
                constraintstxtName.gridx = 1;
                constraintstxtName.gridy = 1;
                constraintstxtName.gridwidth = 1;
                constraintstxtName.gridheight = 1;
                constraintstxtName.fill = 2;
                constraintstxtName.anchor = 17;
                constraintstxtName.weightx = 0.0;
                constraintstxtName.weighty = 0.0;
                this.getspnlName().add((Component)this.gettxtName(), constraintstxtName);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspnlName;
    }

    private TextField gettxtMask() {
        if (this.ivjtxtMask == null) {
            try {
                this.ivjtxtMask = new TextField();
                this.ivjtxtMask.setName("txtMask");
                this.ivjtxtMask.setColumns(30);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtMask;
    }

    private TextArea gettxtMemo() {
        if (this.ivjtxtMemo == null) {
            try {
                this.ivjtxtMemo = new TextArea();
                this.ivjtxtMemo.setName("txtMemo");
                this.ivjtxtMemo.setRows(10);
                this.ivjtxtMemo.setFont(new Font("dialog", 0, 12));
                this.ivjtxtMemo.setColumns(15);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtMemo;
    }

    private TextField gettxtName() {
        if (this.ivjtxtName == null) {
            try {
                this.ivjtxtName = new TextField();
                this.ivjtxtName.setName("txtName");
                this.ivjtxtName.setColumns(30);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtName;
    }

    public void handleException(Throwable t) {
        super.handleException(t);
    }

    protected void init() {
        ConfigFrame.logContext.write("# Relay configuration init");
        super.init();
        this.ivjchsFilterType.add("Relay configuration");
        this.ivjchsFilterType.add("Whitelist entry");
        this.ivjchsFilterType.add("Blacklist entry");
        this.ivjchsFilterType.select(0);
        this.stchng.setName("Relay Configuration");
        this.stchng.addStateChangeListener(this);
        this.stchng.registerMenuBar(this.ivjConfigFilterMenuBar);
        this.stchng.registerBtnNew(this.ivjbtnNew);
        this.stchng.registerBtnStore(this.ivjbtnStore);
        this.stchng.registerBtnCancel(this.ivjbtnCancel);
        this.stchng.registerBtnDelete(this.ivjbtnDelete);
        this.stchng.registerBtnHelp(this.ivjbtnHelp);
        this.stchng.registerKeyField(this.ivjlstFilters);
        this.stchng.registerChangeTrigger(this.ivjtxtName);
        this.stchng.registerChangeTrigger(this.ivjtxtMask);
        this.stchng.registerChangeTrigger(this.ivjchsFilterType);
        this.stchng.registerChangeTrigger(this.ivjtxtMemo);
        this.stchng.doBrowse();
        ConfigFrame.logContext.write("# Relay configuration ready");
    }

    private void initConnections() {
        this.getmnuQuit().addActionListener(this);
        this.addWindowListener(this);
        this.getlstFilters().addItemListener(this);
        this.getchsFilterType().addItemListener(this);
    }

    private void initialize() {
        GridBagConstraints constraintsspnlName = new GridBagConstraints();
        GridBagConstraints constraintsspnlConfig = new GridBagConstraints();
        GridBagConstraints constraintsspnlMemo = new GridBagConstraints();
        GridBagConstraints constraintsspnlFilterList = new GridBagConstraints();
        this.setName("ConfigFilter");
        this.setMenuBar(this.getConfigFilterMenuBar());
        ((Component)this).setFont(new Font("dialog", 0, 12));
        this.setLayout(new GridBagLayout());
        ((Component)this).setSize(534, 355);
        this.setTitle("Filter configuration");
        constraintsspnlName.gridx = 1;
        constraintsspnlName.gridy = 0;
        constraintsspnlName.gridwidth = 1;
        constraintsspnlName.gridheight = 1;
        constraintsspnlName.fill = 2;
        constraintsspnlName.anchor = 17;
        constraintsspnlName.weightx = 0.0;
        constraintsspnlName.weighty = 0.0;
        this.add((Component)this.getspnlName(), constraintsspnlName);
        constraintsspnlConfig.gridx = 1;
        constraintsspnlConfig.gridy = 1;
        constraintsspnlConfig.gridwidth = 1;
        constraintsspnlConfig.gridheight = 1;
        constraintsspnlConfig.fill = 1;
        constraintsspnlConfig.anchor = 17;
        constraintsspnlConfig.weightx = 0.0;
        constraintsspnlConfig.weighty = 0.0;
        this.add((Component)this.getspnlConfig(), constraintsspnlConfig);
        constraintsspnlMemo.gridx = 1;
        constraintsspnlMemo.gridy = 2;
        constraintsspnlMemo.gridwidth = 1;
        constraintsspnlMemo.gridheight = 1;
        constraintsspnlMemo.fill = 1;
        constraintsspnlMemo.anchor = 17;
        constraintsspnlMemo.weightx = 0.0;
        constraintsspnlMemo.weighty = 0.0;
        this.add((Component)this.getspnlMemo(), constraintsspnlMemo);
        constraintsspnlFilterList.gridx = 0;
        constraintsspnlFilterList.gridy = 0;
        constraintsspnlFilterList.gridwidth = 1;
        constraintsspnlFilterList.gridheight = 3;
        constraintsspnlFilterList.fill = 1;
        constraintsspnlFilterList.anchor = 17;
        constraintsspnlFilterList.weightx = 0.0;
        constraintsspnlFilterList.weighty = 0.1;
        this.add((Component)this.getspnlFilterList(), constraintsspnlFilterList);
        this.initConnections();
        this.init();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getlstFilters()) {
            this.connEtoC3(e);
        }
        if (e.getSource() == this.getchsFilterType()) {
            this.connEtoC4(e);
        }
    }

    public void lstFilters_ItemStateChanged() {
        String strRecord = this.ivjlstFilters.getSelectedItem();
        if (strRecord == null) {
            this.stchng.setRecordExists(false);
            return;
        }
        FilterRecord fr = ConfigFrame.smManager.filterRead(strRecord);
        if (fr == null) {
            this.stchng.setRecordExists(false);
            MessageBox.OK(this, "", "Cannot read filter '" + strRecord + "' !");
            return;
        }
        this.copyFRtoGUI(fr);
        this.stchng.setRecordExists(true);
    }

    public static void main(String[] args) {
        try {
            ConfigFilter aConfigFilter = new ConfigFilter();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$java$awt$Window;
                if (clazz == null) {
                    try {
                        clazz = class$java$awt$Window = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] parmTypes = classArray;
                Object[] parms = new Object[]{aConfigFilter};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {}
            aConfigFilter.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("In main() von net.zerotoaster.mta.admin.awt.ConfigFrame trat eine Ausnahmebedingung auf");
            exception.printStackTrace(System.out);
        }
    }

    public void mnuQuit_ActionEvents() {
        this.setVisible(false);
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof PrivilegeChanged) {
            switch (ConfigFrame.intRM_Privilege) {
                case -1: 
                case 0: 
                case 1: 
                case 3: {
                    super.setVisible(false);
                    return;
                }
            }
        }
        super.mtaEvent(e);
    }

    void refreshFilterList(String strFilterToSelect) {
        this.ivjlstFilters.removeAll();
        if (!this.isVisible()) {
            return;
        }
        Vector v = ConfigFrame.smManager.filterReadAll();
        int i = 0;
        while (i < v.size()) {
            this.ivjlstFilters.addItem((String)v.elementAt(i));
            ++i;
        }
        if (this.ivjlstFilters.getItemCount() == 0) {
            this.stchng.setRecordExists(false);
            this.copyFRtoGUI(new FilterRecord());
            return;
        }
        this.ivjlstFilters.select(0);
        if (strFilterToSelect != null) {
            i = 0;
            while (i < this.ivjlstFilters.getItemCount()) {
                if (this.ivjlstFilters.getItem(i).equals(strFilterToSelect)) {
                    this.ivjlstFilters.select(i);
                    break;
                }
                ++i;
            }
        }
        this.lstFilters_ItemStateChanged();
    }

    public void setVisible(boolean b) {
        switch (ConfigFrame.intRM_Privilege) {
            case -1: 
            case 0: 
            case 1: 
            case 3: {
                super.setVisible(false);
                return;
            }
        }
        super.setVisible(b);
        if (b) {
            this.refreshFilterList(null);
        }
    }

    public void stateChanged(StateChangeEvent e) {
        FilterRecord fr = new FilterRecord();
        String strSelectedFilter = null;
        switch (e.getState()) {
            case 7: {
                ConfigFrame.frmHelp.showHelp(this);
                break;
            }
            case 3: {
                this.copyFRtoGUI(new FilterRecord());
                this.ivjtxtName.requestFocus();
                break;
            }
            case 5: {
                if (!this.copyGUItoFR(fr)) {
                    e.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                ConfigFrame.smManager.filterWrite(fr);
                this.copyFRtoGUI(fr);
                this.refreshFilterList(fr.getName());
                this.stchng.doBrowse();
                ((Component)this).setCursor(new Cursor(0));
                break;
            }
            case 6: {
                if (!MessageBox.OK_CANCEL(this, "", "Are you sure to abort this operation ?")) {
                    e.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                strSelectedFilter = this.ivjlstFilters.getSelectedItem();
                if (strSelectedFilter != null) {
                    fr = ConfigFrame.smManager.filterRead(strSelectedFilter);
                }
                this.copyFRtoGUI(fr);
                this.stchng.doBrowse();
                ((Component)this).setCursor(new Cursor(0));
                break;
            }
            case 4: {
                strSelectedFilter = this.ivjlstFilters.getSelectedItem();
                if (strSelectedFilter == null) {
                    e.reset();
                    break;
                }
                if (!MessageBox.OK_CANCEL(this, "Warning", "Are you sure to delete filter '" + strSelectedFilter + "' ?")) {
                    e.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                ConfigFrame.smManager.filterDelete(strSelectedFilter);
                this.refreshFilterList(null);
                ((Component)this).setCursor(new Cursor(0));
                this.stchng.doBrowse();
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC2(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

