/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class SOARecord
extends Record {
    private Name host;
    private Name admin;
    private int serial;
    private int refresh;
    private int retry;
    private int expire;
    private int minimum;

    private SOARecord() {
    }

    SOARecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)6, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.host = new Name(in);
        this.admin = new Name(in);
        this.serial = in.readInt();
        this.refresh = in.readInt();
        this.retry = in.readInt();
        this.expire = in.readInt();
        this.minimum = in.readInt();
    }

    public SOARecord(Name _name, short _dclass, int _ttl, Name _host, Name _admin, int _serial, int _refresh, int _retry, int _expire, int _minimum) throws IOException {
        super(_name, (short)6, _dclass, _ttl);
        this.host = _host;
        this.admin = _admin;
        this.serial = _serial;
        this.refresh = _refresh;
        this.retry = _retry;
        this.expire = _expire;
        this.minimum = _minimum;
    }

    SOARecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)6, _dclass, _ttl);
        this.host = new Name(st.nextToken(), origin);
        this.admin = new Name(st.nextToken(), origin);
        this.serial = Integer.parseInt(st.nextToken());
        this.refresh = TTL.parseTTL(st.nextToken());
        this.retry = TTL.parseTTL(st.nextToken());
        this.expire = TTL.parseTTL(st.nextToken());
        this.minimum = TTL.parseTTL(st.nextToken());
    }

    public Name getAdmin() {
        return this.admin;
    }

    public int getExpire() {
        return this.expire;
    }

    public Name getHost() {
        return this.host;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getSerial() {
        return this.serial;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.host != null) {
            sb.append(this.host);
            sb.append(" ");
            sb.append(this.admin);
            sb.append(" (\n\t\t\t\t\t");
            sb.append(this.serial);
            sb.append("\t; serial\n\t\t\t\t\t");
            sb.append(this.refresh);
            sb.append("\t; refresh\n\t\t\t\t\t");
            sb.append(this.retry);
            sb.append("\t; retry\n\t\t\t\t\t");
            sb.append(this.expire);
            sb.append("\t; expire\n\t\t\t\t\t");
            sb.append(this.minimum);
            sb.append(" )\t; minimum");
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.host == null) {
            return;
        }
        this.host.toWire(out, c);
        this.admin.toWire(out, c);
        out.writeInt(this.serial);
        out.writeInt(this.refresh);
        out.writeInt(this.retry);
        out.writeInt(this.expire);
        out.writeInt(this.minimum);
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.host == null) {
            return;
        }
        this.host.toWireCanonical(out);
        this.admin.toWireCanonical(out);
        out.writeInt(this.serial);
        out.writeInt(this.refresh);
        out.writeInt(this.retry);
        out.writeInt(this.expire);
        out.writeInt(this.minimum);
    }
}

