/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xbill.DNS.Name;

public class FindServer {
    private static String[] server = null;
    private static Name[] search = null;
    private static boolean probed = false;

    private FindServer() {
    }

    private static void find95() {
        String s = "winipcfg.out";
        try {
            Process p = Runtime.getRuntime().exec("winipcfg /all /batch " + s);
            p.waitFor();
            File f = new File(s);
            FindServer.findWin(new FileInputStream(f));
            new File(s).delete();
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void findNT() {
        try {
            Process p = Runtime.getRuntime().exec("ipconfig /all");
            FindServer.findWin(p.getInputStream());
            p.destroy();
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void findProperty() {
        int i;
        String s;
        StringTokenizer st;
        Vector<String> v = null;
        String prop = System.getProperty("dns.server");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (v == null) {
                    v = new Vector<String>();
                }
                v.addElement(s);
            }
            if (v != null) {
                server = new String[v.size()];
                i = 0;
                while (i < v.size()) {
                    FindServer.server[i] = (String)v.elementAt(i);
                    ++i;
                }
            }
        }
        v = null;
        prop = System.getProperty("dns.search");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(s);
            }
            if (v != null) {
                search = new Name[v.size()];
                i = 0;
                while (i < v.size()) {
                    FindServer.search[i] = new Name((String)v.elementAt(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void findUnix() {
        FileInputStream in = null;
        try {
            in = new FileInputStream("/etc/resolv.conf");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        Vector<String> vserver = null;
        Vector<String> vsearch = null;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String s;
                StringTokenizer st;
                void var5_5;
                if (var5_5.startsWith("nameserver")) {
                    if (vserver == null) {
                        vserver = new Vector<String>();
                    }
                    st = new StringTokenizer((String)var5_5);
                    st.nextToken();
                    vserver.addElement(st.nextToken());
                    continue;
                }
                if (var5_5.startsWith("domain")) {
                    if (vsearch == null) {
                        vsearch = new Vector<String>();
                    }
                    st = new StringTokenizer((String)var5_5);
                    st.nextToken();
                    if (!st.hasMoreTokens() || vsearch.contains(s = st.nextToken())) continue;
                    vsearch.addElement(s);
                    continue;
                }
                if (!var5_5.startsWith("search")) continue;
                if (vsearch == null) {
                    vsearch = new Vector();
                }
                st = new StringTokenizer((String)var5_5);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                    if (vsearch.contains(s)) continue;
                    vsearch.addElement(s);
                }
            }
            br.close();
        }
        catch (IOException iOException) {}
        if (server == null && vserver != null) {
            server = new String[vserver.size()];
            int i = 0;
            while (i < vserver.size()) {
                FindServer.server[i] = (String)vserver.elementAt(i);
                ++i;
            }
        }
        if (search == null && vsearch != null) {
            search = new Name[vsearch.size()];
            int i = 0;
            while (i < vsearch.size()) {
                FindServer.search[i] = new Name((String)vsearch.elementAt(i));
                ++i;
            }
        }
    }

    private static void findWin(InputStream in) {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            try {
                Vector<String> vserver = null;
                String line = null;
                boolean readingServers = false;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (!st.hasMoreTokens()) {
                        readingServers = false;
                        continue;
                    }
                    String s = st.nextToken();
                    if (line.indexOf(":") != -1) {
                        readingServers = false;
                    }
                    if (line.indexOf("Host Name") != -1) {
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                        }
                        Name name = new Name(s);
                        if (name.labels() == 1) continue;
                        name = new Name(name, 1);
                        search = new Name[1];
                        FindServer.search[0] = name;
                        continue;
                    }
                    if (!readingServers && line.indexOf("DNS Servers") == -1) continue;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    if (vserver == null) {
                        vserver = new Vector<String>();
                    }
                    vserver.addElement(s);
                    readingServers = true;
                }
                if (server == null && vserver != null) {
                    server = new String[vserver.size()];
                    int i = 0;
                    while (i < vserver.size()) {
                        FindServer.server[i] = (String)vserver.elementAt(i);
                        ++i;
                    }
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            try {
                br.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var2_11 = null;
        try {
            br.close();
        }
        catch (IOException iOException) {}
    }

    private static synchronized void probe() {
        if (probed) {
            return;
        }
        probed = true;
        FindServer.findProperty();
        if (server == null || search == null) {
            String OS = System.getProperty("os.name");
            if (OS.indexOf("Windows") != -1) {
                if (OS.indexOf("NT") != -1 || OS.indexOf("2000") != -1) {
                    FindServer.findNT();
                } else {
                    FindServer.find95();
                }
            } else {
                FindServer.findUnix();
            }
        }
        if (search == null) {
            search = new Name[1];
        } else {
            Name[] oldsearch = search;
            search = new Name[oldsearch.length + 1];
            System.arraycopy(oldsearch, 0, search, 0, oldsearch.length);
        }
        FindServer.search[FindServer.search.length - 1] = Name.root;
    }

    public static Name[] searchPath() {
        FindServer.probe();
        return search;
    }

    public static String server() {
        String[] array = FindServer.servers();
        if (array == null) {
            return null;
        }
        return array[0];
    }

    public static String[] servers() {
        FindServer.probe();
        return server;
    }
}

