/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import java.util.StringTokenizer;
import org.xbill.DNS.Options;

class BitString {
    int nbits;
    byte[] data;

    BitString(int _nbits, byte[] _data) {
        this.nbits = _nbits;
        this.data = _data;
    }

    BitString(String s) throws IOException {
        int i;
        int radix;
        if (Options.check("verbosebitstring")) {
            System.err.println("parsing BitString" + s);
        }
        if (s.length() < 4 || !s.startsWith("[") || !s.endsWith("]")) {
            throw new IOException("Invalid encoding: " + s);
        }
        if (Options.check("verbosebitstring")) {
            System.err.println("basic encoding ok");
        }
        switch (s.charAt(1)) {
            case 'x': {
                radix = 16;
                break;
            }
            case 'o': {
                radix = 8;
                break;
            }
            case 'b': {
                radix = 2;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                radix = 0;
                break;
            }
            default: {
                throw new IOException("Invalid encoding: " + s);
            }
        }
        if (Options.check("verbosebitstring")) {
            System.err.println("radix = " + radix);
        }
        int slash = s.indexOf(47);
        BitSet set = new BitSet();
        if (radix > 0) {
            i = 2;
            int j = 0;
            while (i < s.length() - 1 && i != slash) {
                int x = Character.digit(s.charAt(i), radix);
                if (x == -1) {
                    throw new IOException("Invalid digit: " + s.charAt(i));
                }
                switch (radix) {
                    case 2: {
                        if (x == 1) {
                            set.set(j);
                        }
                        ++this.nbits;
                        break;
                    }
                    case 8: {
                        if ((x & 4) != 0) {
                            set.set(3 * j);
                        }
                        if ((x & 2) != 0) {
                            set.set(3 * j + 1);
                        }
                        if ((x & 1) != 0) {
                            set.set(3 * j + 2);
                        }
                        this.nbits += 3;
                        break;
                    }
                    case 16: {
                        if ((x & 8) != 0) {
                            set.set(4 * j);
                        }
                        if ((x & 4) != 0) {
                            set.set(4 * j + 1);
                        }
                        if ((x & 2) != 0) {
                            set.set(4 * j + 2);
                        }
                        if ((x & 1) != 0) {
                            set.set(4 * j + 3);
                        }
                        this.nbits += 4;
                    }
                }
                ++i;
                ++j;
            }
        } else {
            int end = slash != -1 ? slash : s.length() - 1;
            String quad = s.substring(1, end);
            StringTokenizer st = new StringTokenizer(quad, ".");
            int i2 = 0;
            while (i2 < 4) {
                if (!st.hasMoreTokens()) {
                    throw new IOException("Invalid dotted quad");
                }
                String token = st.nextToken();
                try {
                    int x = Integer.parseInt(token);
                    int j = 0;
                    while (j < 8) {
                        if ((x & 1) != 0) {
                            set.set(8 * i2 + 7 - j);
                        }
                        x >>= 1;
                        ++j;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Invalid dotted quad");
                }
                ++i2;
            }
            this.nbits = 32;
        }
        if (slash != -1) {
            String count = s.substring(slash + 1, s.length() - 1);
            try {
                int bitcount = Integer.parseInt(count);
                if (bitcount > this.nbits || bitcount < 0) {
                    throw new Exception();
                }
                this.nbits = bitcount;
            }
            catch (Exception exception) {
                throw new IOException("Invalid binary label: " + s);
            }
        }
        this.data = new byte[this.bytes()];
        i = 0;
        while (i < this.nbits) {
            int n = i / 8;
            this.data[n] = (byte)(this.data[n] | (set.get(i) ? 1 : 0) << 7 - i % 8);
            ++i;
        }
    }

    int bytes() {
        return (this.nbits + 7) / 8;
    }

    int compareBits(BitString b, int n) {
        if (n > this.nbits || n > b.nbits) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < n) {
            int bbit;
            int bit = BitString.getBit(this.data, i);
            if (bit != (bbit = BitString.getBit(b.data, i))) {
                return bit - bbit;
            }
            ++i;
        }
        return 0;
    }

    public int compareTo(Object o) {
        BitString b = (BitString)o;
        int min = this.nbits > b.nbits ? b.nbits : this.nbits;
        int ret = this.compareBits(b, min);
        if (ret != 0) {
            return ret;
        }
        return this.nbits - b.nbits;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitString)) {
            return false;
        }
        BitString b = (BitString)o;
        if (this.nbits != b.nbits) {
            return false;
        }
        int i = 0;
        while (i < this.bytes()) {
            if (this.data[i] != b.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int getBit(byte[] data, int n) {
        return (data[n / 8] & 0xFF) >> 7 - n % 8 & 1;
    }

    void join(BitString b) {
        if (this.nbits == 256) {
            return;
        }
        int total = this.nbits + b.nbits;
        if (total <= 256) {
            byte[] newdata = new byte[(total + 7) / 8];
            int i = this.nbits - 1;
            while (i >= 0) {
                BitString.setBit(newdata, i + b.nbits, BitString.getBit(this.data, i));
                --i;
            }
            i = 0;
            while (i < b.nbits) {
                BitString.setBit(newdata, i, BitString.getBit(b.data, i));
                ++i;
            }
            this.nbits = total;
            this.data = newdata;
            b.nbits = 0;
            b.data = null;
        } else {
            byte[] newdata = new byte[32];
            byte[] newbdata = new byte[(total - 256 + 7) / 8];
            int i = this.nbits;
            while (i >= 0) {
                BitString.setBit(newdata, 255 - i, BitString.getBit(this.data, this.nbits - i - 1));
                --i;
            }
            i = 0;
            while (i < 256 - this.nbits) {
                BitString.setBit(newdata, 255 - this.nbits - i, BitString.getBit(b.data, b.nbits - i - 1));
                ++i;
            }
            this.nbits = 256;
            this.data = newdata;
            b.nbits = total - 256;
            System.arraycopy(b.data, 0, newbdata, 0, newbdata.length);
            b.data = newbdata;
        }
    }

    private static final void setBit(byte[] data, int n, int val) {
        if (val == 0) {
            int n2 = n / 8;
            data[n2] = (byte)(data[n2] & ~(1 << 7 - n % 8));
        } else {
            int n3 = n / 8;
            data[n3] = (byte)(data[n3] | 1 << 7 - n % 8);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\\[x");
        int i = 0;
        while (i < this.bytes()) {
            int value = this.data[i] & 0xFF;
            int high = value >> 4;
            int low = value & 0xF;
            sb.append(Integer.toHexString(high).toUpperCase());
            if (low > 0 || i < this.bytes() - 1) {
                sb.append(Integer.toHexString(low).toUpperCase());
            }
            ++i;
        }
        sb.append("/");
        sb.append(this.nbits);
        sb.append("]");
        return sb.toString();
    }

    int wireBits() {
        return this.nbits == 256 ? 0 : this.nbits;
    }
}

