/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.KXRecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.base64;

public class jnamed {
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    Hashtable caches;
    Hashtable znames;
    Hashtable TSIGs;

    public jnamed(String conffile) throws IOException {
        FileInputStream fs;
        Vector<Short> ports = new Vector<Short>();
        Vector<InetAddress> addresses = new Vector<InetAddress>();
        try {
            fs = new FileInputStream(conffile);
        }
        catch (Exception exception) {
            System.out.println("Cannot open " + conffile);
            return;
        }
        this.caches = new Hashtable();
        this.znames = new Hashtable();
        this.TSIGs = new Hashtable();
        BufferedReader br = new BufferedReader(new InputStreamReader(fs));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            String keyword = st.nextToken();
            if (!st.hasMoreTokens()) {
                System.out.println("Invalid line: " + line);
                continue;
            }
            if (keyword.charAt(0) == '#') continue;
            if (keyword.equals("primary")) {
                this.addPrimaryZone(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("secondary")) {
                this.addSecondaryZone(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("cache")) {
                Cache cache = new Cache(st.nextToken());
                this.caches.put(new Short(1), cache);
                continue;
            }
            if (keyword.equals("key")) {
                this.addTSIG(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("port")) {
                ports.addElement(Short.valueOf(st.nextToken()));
                continue;
            }
            if (keyword.equals("address")) {
                String addr = st.nextToken();
                addresses.addElement(InetAddress.getByName(addr));
                continue;
            }
            System.out.println("ignoring invalid keyword: " + keyword);
        }
        if (ports.size() == 0) {
            ports.addElement(new Short(53));
        }
        if (addresses.size() == 0) {
            addresses.addElement(null);
        }
        Enumeration eaddr = addresses.elements();
        while (eaddr.hasMoreElements()) {
            InetAddress addr = (InetAddress)eaddr.nextElement();
            Enumeration eport = ports.elements();
            while (eport.hasMoreElements()) {
                short port = (Short)eport.nextElement();
                this.addUDP(addr, port);
                this.addTCP(addr, port);
                String addrString = addr == null ? "0.0.0.0" : addr.getHostAddress();
                System.out.println("jnamed: listening on " + addrString + "#" + port);
            }
        }
        System.out.println("jnamed: running");
    }

    void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Enumeration e = response.getSection(section);
        while (e.hasMoreElements()) {
            Record r = (Record)e.nextElement();
            Name glueName = null;
            switch (r.getType()) {
                case 15: {
                    glueName = ((MXRecord)r).getTarget();
                    break;
                }
                case 2: {
                    glueName = ((NSRecord)r).getTarget();
                    break;
                }
                case 36: {
                    glueName = ((KXRecord)r).getTarget();
                    break;
                }
                case 35: {
                    glueName = ((NAPTRRecord)r).getReplacement();
                    break;
                }
                case 33: {
                    glueName = ((SRVRecord)r).getTarget();
                    break;
                }
            }
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    byte addAnswer(Message response, Name name, short type, short dclass, int iterations, int n) {
        RRset rrset;
        SetResponse sr;
        Zone zone;
        int flags;
        byte rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24) {
            type = (short)255;
            flags = n | 2;
        }
        if ((zone = this.findBestZone(name)) != null) {
            sr = zone.findRecords(name, type);
        } else {
            Cache cache = this.getCache(dclass);
            sr = cache.lookupRecords(name, type, (byte)2);
        }
        if (sr.isUnknown()) {
            this.addCacheNS(response, this.getCache(dclass), name);
        }
        if (sr.isNXDOMAIN()) {
            response.getHeader().setRcode((short)3);
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, (byte)2, flags);
        } else if (sr.isCNAME()) {
            rrset = new RRset();
            CNAMERecord cname = sr.getCNAME();
            rrset.addRR(cname);
            this.addRRset(name, response, rrset, (byte)1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            rrset = new RRset();
            DNAMERecord dname = sr.getDNAME();
            rrset.addRR(dname);
            this.addRRset(name, response, rrset, (byte)1, flags);
            Name newname = name.fromDNAME(dname);
            if (newname == null) {
                return 2;
            }
            try {
                rrset = new RRset();
                rrset.addRR(new CNAMERecord(name, dclass, 0, newname));
                this.addRRset(name, response, rrset, (byte)1, flags);
            }
            catch (IOException iOException) {}
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            RRset[] rrsets = sr.answers();
            int i = 0;
            while (i < rrsets.length) {
                this.addRRset(name, response, rrsets[i], (byte)1, flags);
                ++i;
            }
            if (zone != null) {
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else {
                this.addCacheNS(response, this.getCache(dclass), name);
            }
        }
        return rcode;
    }

    private void addCacheNS(Message response, Cache cache, Name name) {
        SetResponse sr = cache.lookupRecords(name, (short)2, (byte)0);
        if (!sr.isDelegation()) {
            return;
        }
        RRset nsRecords = sr.getNS();
        Enumeration e = nsRecords.rrs();
        while (e.hasMoreElements()) {
            Record r = (Record)e.nextElement();
            response.addRecord(r, 2);
        }
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, (short)1, (short)1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, (byte)3, flags);
    }

    private void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, (byte)2, flags);
    }

    public void addPrimaryZone(String zname, String zonefile) throws IOException {
        Name origin = null;
        Cache cache = this.getCache((short)1);
        if (zname != null) {
            origin = new Name(zname, Name.root);
        }
        Zone newzone = new Zone(zonefile, cache, origin);
        this.znames.put(newzone.getOrigin(), newzone);
    }

    void addRRset(Name name, Message response, RRset rrset, byte section, int flags) {
        Enumeration e;
        byte s = 1;
        while (s <= section) {
            if (response.findRRset(name, rrset.getType(), s)) {
                return;
            }
            s = (byte)(s + 1);
        }
        if ((flags & 2) == 0) {
            e = rrset.rrs();
            while (e.hasMoreElements()) {
                Record r = (Record)e.nextElement();
                if (!name.isWild() && r.getName().isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            e = rrset.sigs();
            while (e.hasMoreElements()) {
                Record r = (Record)e.nextElement();
                if (!name.isWild() && r.getName().isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    public void addSecondaryZone(String zone, String remote) throws IOException {
        Cache cache = this.getCache((short)1);
        Name zname = new Name(zone);
        Zone newzone = new Zone(zname, 1, remote, cache);
        this.znames.put(zname, newzone);
    }

    private void addSOA(Message response, Zone zone) {
        response.addRecord(zone.getSOA(), 2);
    }

    public void addTCP(InetAddress addr, short port) {
        Thread t = new Thread(new Runnable(this, addr, port){
            /* synthetic */ jnamed this$0;
            /* synthetic */ InetAddress val$addr;
            /* synthetic */ short val$port;

            public void run() {
                this.this$0.serveTCP(this.val$addr, this.val$port);
            }
            {
                this.this$0 = this$0;
                this.val$addr = val$addr;
                this.val$port = val$port;
            }
        });
        t.start();
    }

    public void addTSIG(String name, String key) {
        this.TSIGs.put(new Name(name), base64.fromString(key));
    }

    public void addUDP(InetAddress addr, short port) {
        Thread t = new Thread(new Runnable(this, addr, port){
            /* synthetic */ jnamed this$0;
            /* synthetic */ InetAddress val$addr;
            /* synthetic */ short val$port;

            public void run() {
                this.this$0.serveUDP(this.val$addr, this.val$port);
            }
            {
                this.this$0 = this$0;
                this.val$addr = val$addr;
                this.val$port = val$port;
            }
        });
        t.start();
    }

    Message doAXFR(Name name, Message query, TSIG tsig, TSIGRecord tSIGRecord, Socket s) {
        Zone zone = (Zone)this.znames.get(name);
        boolean first = true;
        if (zone == null) {
            return this.errorMessage(query, (short)5);
        }
        Enumeration e = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (e.hasMoreElements()) {
                RRset rrset = (RRset)e.nextElement();
                Message response = new Message();
                Header header = response.getHeader();
                header.setID(id);
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, (byte)1, 1);
                tsig.applyAXFR(response, tSIGRecord, first);
                TSIGRecord qtsig = response.getTSIG();
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException iOException) {
            System.out.println("AXFR failed");
        }
        try {
            s.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    public Message errorMessage(Message query, short rcode) {
        Header header = query.getHeader();
        Message response = new Message();
        response.setHeader(header);
        int i = 0;
        while (i < 4) {
            response.removeAllRecords(i);
            ++i;
        }
        if (rcode == 2) {
            response.addRecord(query.getQuestion(), 0);
        }
        header.setRcode(rcode);
        return response;
    }

    public Zone findBestZone(Name name) {
        Zone foundzone = null;
        foundzone = (Zone)this.znames.get(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        int i = 1;
        while (i < labels) {
            Name tname = new Name(name, i);
            foundzone = (Zone)this.znames.get(tname);
            if (foundzone != null) {
                return foundzone;
            }
            ++i;
        }
        return null;
    }

    public RRset findExactMatch(Name name, short type, short dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        Cache cache = this.getCache(dclass);
        RRset[] rrsets = glue ? cache.findAnyRecords(name, type) : cache.findRecords(name, type);
        if (rrsets == null) {
            return null;
        }
        return rrsets[0];
    }

    TSIG findTSIG(Name name) {
        byte[] key = (byte[])this.TSIGs.get(name);
        if (key != null) {
            return new TSIG(name, key);
        }
        return null;
    }

    public Message formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(new DataByteInputStream(in));
        }
        catch (IOException iOException) {
            header = new Header(0);
        }
        Message response = new Message();
        response.setHeader(header);
        int i = 0;
        while (i < 4) {
            response.removeAllRecords(i);
            ++i;
        }
        header.setRcode((short)1);
        return response;
    }

    Message generateReply(Message query, byte[] in, Socket s) {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, (short)1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, (short)4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this.findTSIG(queryTSIG.getName())) == null || tsig.verify(query, in, null) != 0)) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT == null || queryOPT.getVersion() > 0) {
            // empty if block
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? (int)queryOPT.getPayloadSize() : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message();
        response.getHeader().setID(query.getHeader().getID());
        response.getHeader().setFlag(0);
        query.getHeader().getFlag(7);
        response.getHeader().setFlag(7);
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        short type = queryRecord.getType();
        short dclass = queryRecord.getDClass();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, s);
        }
        if (!Type.isRR(type) && type != 255) {
            return this.errorMessage(query, (short)4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryTSIG != null) {
            try {
                if (tsig != null) {
                    tsig.apply(response, queryTSIG);
                }
            }
            catch (IOException iOException) {}
        }
        try {
            response.freeze();
            byte[] out = response.toWire();
            if (out.length > maxLength) {
                response.thaw();
                this.truncate(response, out.length, maxLength);
                if (tsig != null) {
                    tsig.apply(response, queryTSIG);
                }
            }
        }
        catch (IOException iOException) {}
        return response;
    }

    public Cache getCache(short dclass) {
        Cache c = (Cache)this.caches.get(new Short(dclass));
        if (c == null) {
            c = new Cache(dclass);
            this.caches.put(new Short(dclass), c);
        }
        return c;
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage: jnamed [conf]");
            System.exit(0);
        }
        try {
            String conf = args.length == 1 ? args[0] : "jnamed.conf";
            new jnamed(conf);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void serveTCP(InetAddress addr, short port) {
        try {
            ServerSocket sock = new ServerSocket(port, 128, addr);
            while (true) {
                Message response;
                byte[] in;
                Socket s = sock.accept();
                try {
                    InputStream is = s.getInputStream();
                    DataInputStream dataIn = new DataInputStream(is);
                    int inLength = dataIn.readUnsignedShort();
                    in = new byte[inLength];
                    dataIn.readFully(in);
                }
                catch (InterruptedIOException interruptedIOException) {
                    s.close();
                    continue;
                }
                try {
                    Message query = new Message(in);
                    response = this.generateReply(query, in, s);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    response = this.formerrMessage(in);
                }
                byte[] out = response.toWire();
                DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
                dataOut.writeShort(out.length);
                dataOut.write(out);
                s.close();
            }
        }
        catch (IOException e) {
            System.out.println("serveTCP: " + e);
            return;
        }
    }

    public void serveUDP(InetAddress addr, short port) {
        try {
            DatagramSocket sock = new DatagramSocket(port, addr);
            while (true) {
                Message response;
                int udpLength = 512;
                byte[] in = new byte[udpLength];
                DatagramPacket dp = new DatagramPacket(in, in.length);
                try {
                    sock.receive(dp);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                try {
                    Message query = new Message(in);
                    response = this.generateReply(query, in, null);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    response = this.formerrMessage(in);
                }
                byte[] out = response.toWire();
                dp = new DatagramPacket(out, out.length, dp.getAddress(), dp.getPort());
                sock.send(dp);
            }
        }
        catch (IOException e) {
            System.out.println("serveUDP: " + e);
            return;
        }
    }

    public void truncate(Message in, int n, int n2) {
        int length;
        int maxLength;
        TSIGRecord tsig = in.getTSIG();
        if (tsig != null) {
            maxLength = n2 - tsig.getWireLength();
        }
        if ((length = n - this.truncateSection(in, maxLength, n, 3)) < maxLength) {
            return;
        }
        in.getHeader().setFlag(6);
        if (tsig != null) {
            in.removeAllRecords(1);
            in.removeAllRecords(2);
            return;
        }
        if ((length -= this.truncateSection(in, maxLength, length, 2)) < maxLength) {
            return;
        }
        length -= this.truncateSection(in, maxLength, length, 1);
    }

    public int truncateSection(Message in, int maxLength, int n, int section) {
        int removed = 0;
        Record[] records = in.getSectionArray(section);
        int i = records.length - 1;
        while (i >= 0) {
            Record r = records[i];
            removed += r.getWireLength();
            int length = n - r.getWireLength();
            in.removeRecord(r, section);
            if (length <= maxLength) {
                int j = i - 1;
                while (j >= 0) {
                    Record r2 = records[j];
                    if (!r.getName().equals(r2.getName()) || r.getType() != r2.getType() || r.getDClass() != r2.getDClass()) break;
                    removed += r2.getWireLength();
                    length -= r2.getWireLength();
                    in.removeRecord(r2, section);
                    --j;
                }
                return removed;
            }
            --i;
        }
        return removed;
    }
}

