/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import rb.util.StringUtil;
import sun.misc.HexDumpEncoder;

public class SystemRB {
    static ByteArrayOutputStream logBuffer = new ByteArrayOutputStream();
    static File logFile = null;
    private static boolean logFileChecked = false;
    public static final String PrpLogPrps = "rb.log.properties";
    public static final String PrpLogFile = "rb.log.file";
    static Vector dragDropObjects = null;
    static int BufferSize = 8192;
    static final Object[] EmptyArray = new Object[0];

    public static void abort(Object object, String string, Throwable throwable, int n) {
        SystemRB.logPrim(object, string, throwable);
        System.exit(n);
    }

    public static void abort(String string, int n) {
        SystemRB.abort("", string, null, n);
    }

    public static boolean arrayEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray.length == 0) {
            return objectArray2 == null || objectArray2.length == 0;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!SystemRB.equals(objectArray[n], objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static String getDigest(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeUTF(string);
            objectOutputStream.close();
            byte[] byArray = MessageDigest.getInstance("MD5").digest(byteArrayOutputStream.toByteArray());
            return new HexDumpEncoder().encode(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector getDragDropObjects() {
        return dragDropObjects;
    }

    public static boolean getPropertyBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = bl ? "true" : "false";
            SystemRB.setProperty(string, string2);
        }
        if (SystemRB.isPropertyTrue(PrpLogPrps, false)) {
            SystemRB.log(String.valueOf(string) + "=" + string2);
        }
        return SystemRB.isPropertyTrue(string, false);
    }

    public static String getPropertyString(String string, String string2) {
        String string3;
        if (string.indexOf("serverD") >= 0) {
            System.out.println(string);
        }
        if ((string3 = System.getProperty(string)) == null) {
            string3 = string2;
            SystemRB.setProperty(string, string3);
        }
        if ("true".equals(System.getProperty(PrpLogPrps))) {
            SystemRB.log(String.valueOf(string) + "=" + string3);
        }
        return string3;
    }

    private static boolean isPropertyTrue(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("1") || string2.toLowerCase().equals("true");
    }

    public static void log(Object object, String string, Throwable throwable) {
        SystemRB.logPrim(object, string, throwable);
    }

    public static void log(String string) {
        SystemRB.log(null, string, null);
    }

    public static File logFile() {
        SystemRB.logFileCheck();
        return logFile;
    }

    public static void logFile(File file) {
        logFile = file;
    }

    private static boolean logFileCheck() {
        if (logFileChecked) {
            return false;
        }
        logFileChecked = true;
        String string = System.getProperty(PrpLogFile);
        if (string == null || string.length() == 0) {
            return false;
        }
        SystemRB.logFile(new File(string));
        return true;
    }

    private static void logPrim(Object object, String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = logBuffer;
        synchronized (byteArrayOutputStream) {
            logBuffer.reset();
            PrintWriter printWriter = new PrintWriter(logBuffer);
            if (SystemRB.logFileCheck()) {
                printWriter.println("rb.log.file=" + logFile.getPath());
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss ", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            printWriter.print(simpleDateFormat.format(new Date()));
            if (object != null) {
                printWriter.print(object);
                printWriter.print(":");
            }
            printWriter.println(string);
            if (throwable != null) {
                throwable.printStackTrace(printWriter);
            }
            printWriter.flush();
            try {
                logBuffer.writeTo(System.err);
            }
            catch (IOException iOException) {}
            if (logFile == null) {
                return;
            }
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(logFile, "rw");
                randomAccessFile.seek(randomAccessFile.length());
                logBuffer.writeTo(new FileOutputStream(randomAccessFile.getFD()));
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void setDragDropObject(Object object) {
        dragDropObjects = new Vector(1);
        dragDropObjects.addElement(object);
    }

    public static void setDragDropObjects(Vector vector) {
        dragDropObjects = vector;
    }

    public static boolean setProperty(String string, String string2) {
        try {
            Properties properties = System.getProperties();
            ((Hashtable)properties).put(string, string2);
            System.setProperties(properties);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return StringUtil.fromLast(object.getClass().getName(), '.');
    }
}

