/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.io.IOException;
import java.io.Reader;

public class BufferedReaderRB
extends Reader {
    protected Reader in;
    protected char[] cb;
    protected int nChars;
    protected int nextChar;
    protected static final int INVALIDATED = -2;
    protected static final int UNMARKED = -1;
    protected int markedChar = -1;
    protected int readAheadLimit = 0;
    protected static int defaultCharBufferSize = 8192;
    protected static int defaultExpectedLineLength = 80;

    public BufferedReaderRB(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    public BufferedReaderRB(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.cb = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    protected void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else if (this.readAheadLimit <= this.cb.length) {
                System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                this.markedChar = 0;
                n2 = n;
            } else {
                char[] cArray = new char[this.readAheadLimit];
                System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                this.cb = cArray;
                this.markedChar = 0;
                n2 = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = n;
            this.markedChar = this.nextChar;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            return this.cb[this.nextChar++];
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                if (n2 >= this.cb.length && this.markedChar <= -1) {
                    return this.in.read(cArray, n, n2);
                }
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return -1;
            }
            int n3 = Math.min(n2, this.nChars - this.nextChar);
            System.arraycopy(this.cb, this.nextChar, cArray, n, n3);
            this.nextChar += n3;
            return n3;
        }
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        Object object = this.lock;
        synchronized (object) {
            char c;
            boolean bl;
            this.ensureOpen();
            do {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    return null;
                }
                bl = false;
                c = '\u0000';
                int n = this.nextChar;
                while (n < this.nChars) {
                    c = this.cb[n];
                    if (c == '\n' || c == '\r') {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                stringBuffer.append(this.cb, this.nextChar, n - this.nextChar);
                this.nextChar = n;
            } while (!bl);
            ++this.nextChar;
            if (c == '\r') {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar < this.nChars && this.cb[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            long l2 = l;
            while (l2 > 0L) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                long l3 = this.nChars - this.nextChar;
                if (l2 <= l3) {
                    this.nextChar = (int)((long)this.nextChar + l2);
                    l2 = 0L;
                    break;
                }
                l2 -= l3;
                this.nextChar = this.nChars;
            }
            return l - l2;
        }
    }
}

