/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.model;

/**
 * Used for TableModels in JFormDesigner forms to specify additional information
 * for columns, which are not supported by <code>DefaultTableModel</code>.
 *
 * @author Karl Tauber
 * @since 3.0
 */
public class SwingTableColumn
{
	private final Object[] values;
	private final int preferredWidth;
	private final int minWidth;
	private final int maxWidth;
	private final boolean resizable;

	/**
	 * Constructs a column.
	 */
	public SwingTableColumn( Object[] values, int preferredWidth, int minWidth,
		int maxWidth, boolean resizable )
	{
		this.values = values;
		this.preferredWidth = preferredWidth;
		this.minWidth = minWidth;
		this.maxWidth = maxWidth;
		this.resizable = resizable;
	}

	/**
	 * Returns the allowed values of this column or <code>null</code>.
	 * A <code>JComboBox</code> is used as cell editor if a column has values.
	 */
	public Object[] getValues() {
		return values;
	}

	/**
	 * Returns the preferred width of this column or 0 if not specified.
	 */
	public int getPreferredWidth() {
		return preferredWidth;
	}

	/**
	 * Returns the minimum width of this column or 0 if not specified.
	 */
	public int getMinWidth() {
		return minWidth;
	}

	/**
	 * Returns the maximum width of this column or 0 if not specified.
	 */
	public int getMaxWidth() {
		return maxWidth;
	}

	/**
	 * Returns whether the user is allowed to resize this column.
	 */
	public boolean getResizable() {
		return resizable;
	}
}
