/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.model;

/**
 * A non-visual form component represents a non-visual JavaBean.
 * Non-visuals are only allowed as children of {@link FormRoot}.
 * <p>
 * JFormDesigner 1.0 only supports <code>javax.swing.ButtonGroup</code>.
 * Starting with JFormDesigner 2.0, all non-visual JavaBeans are supported.
 * <p>
 * Example for creating a button group:
 * <pre>
 *   FormComponent radioButton1 = new FormComponent("javax.swing.JRadioButton");
 *   radioButton1.setName("radioButton1");
 *   radioButton1.setProperty("text", "Radio Button 1");
 *   <b>radioButton1.setProperty("$buttonGroup", new FormReference("buttonGroup1"));</b>
 *   panel.add(radioButton1);
 *
 *   FormComponent radioButton2 = new FormComponent("javax.swing.JRadioButton");
 *   radioButton2.setName("radioButton2");
 *   radioButton2.setProperty("text", "Radio Button 2");
 *   <b>radioButton2.setProperty("$buttonGroup", new FormReference("buttonGroup1"));</b>
 *   panel.add(radioButton2);
 *
 *   // Create button group object and add it to FormModel root. The name of
 *   // this object must match to the name used in the FormReference above.
 *   FormNonVisual buttonGroup1 = <b>new FormNonVisual("javax.swing.ButtonGroup")</b>;
 *   buttonGroup1.setName("buttonGroup1");
 *   root.add(buttonGroup1);
 * </pre>
 *
 * @author Karl Tauber
 */
public class FormNonVisual
	extends FormComponent
{
	/**
	 * Constructs a non-visual form component for the specified class.
	 */
	public FormNonVisual( String className ) {
		super( className );
	}

	FormNonVisual( FormNonVisual obj, int dummy ) {
		super( obj, dummy );
	}

	/**
	 * Clones this form component.
	 */
	@Override
	public Object clone() {
		return new FormNonVisual( this, 0 );
	}

	@Override
	void setParent( FormContainer parent ) {
		if( parent != null && !(parent instanceof FormRoot) )
			throw new IllegalArgumentException();

		super.setParent( parent );
	}
}
