/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.SwingTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCloner {
    public static Object cloneObject(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        if (ObjectCloner.isImmutable(cls)) {
            return o;
        }
        if (cls.isArray()) {
            Class<?> componentType = cls.getComponentType();
            int arrayLength = Array.getLength(o);
            Object newArray = Array.newInstance(componentType, arrayLength);
            if (ObjectCloner.isImmutable(componentType) || componentType.isPrimitive()) {
                System.arraycopy(o, 0, newArray, 0, arrayLength);
            } else {
                for (int i = 0; i < arrayLength; ++i) {
                    Array.set(newArray, i, ObjectCloner.cloneObject(Array.get(o, i)));
                }
            }
            return newArray;
        }
        if (cls == Dimension.class) {
            return new Dimension((Dimension)o);
        }
        if (cls == Insets.class) {
            return new Insets(((Insets)o).top, ((Insets)o).left, ((Insets)o).bottom, ((Insets)o).right);
        }
        if (cls == Point.class) {
            return new Point((Point)o);
        }
        if (cls == Rectangle.class) {
            return new Rectangle((Rectangle)o);
        }
        if (cls == DefaultComboBoxModel.class) {
            DefaultComboBoxModel m = (DefaultComboBoxModel)o;
            int size = m.getSize();
            Vector v = new Vector(size);
            for (int i = 0; i < size; ++i) {
                v.add(m.getElementAt(i));
            }
            return new DefaultComboBoxModel(v);
        }
        if (cls == SwingTableModel.class) {
            SwingTableModel m = (SwingTableModel)o;
            return new SwingTableModel(m);
        }
        if (cls == SpinnerNumberModel.class) {
            SpinnerNumberModel m = (SpinnerNumberModel)o;
            return new SpinnerNumberModel(m.getNumber(), m.getMinimum(), m.getMaximum(), m.getStepSize());
        }
        if (cls == SpinnerDateModel.class) {
            SpinnerDateModel m = (SpinnerDateModel)o;
            Date value = m.getDate();
            Date start = m.getStart();
            Date end = m.getEnd();
            long now = System.currentTimeMillis() / 60000L * 60000L;
            if (value.getTime() == Long.MIN_VALUE) {
                value = new Date(now);
            }
            if (start instanceof Date && ((Date)start).getTime() == Long.MIN_VALUE) {
                start = new Date(now);
            }
            if (end instanceof Date && ((Date)end).getTime() == Long.MIN_VALUE) {
                end = new Date(now);
            }
            return new SpinnerDateModel(value, start, end, m.getCalendarField());
        }
        if (cls == SpinnerListModel.class) {
            SpinnerListModel m = (SpinnerListModel)o;
            SpinnerListModel m2 = new SpinnerListModel(m.getList());
            m2.setValue(m.getValue());
            return m2;
        }
        return o;
    }

    public static boolean isImmutable(Class<?> cls) {
        return cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Double.class || cls == Float.class || cls == Integer.class || cls == Long.class || cls == Short.class || cls == String.class || cls == Void.class || cls == Color.class || cls == Font.class;
    }
}

