/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FormSpecCoder {
    public static Boolean useLayoutMap;
    private static final Object[] columnSpecs;
    private static final Object[] rowSpecs;
    private static HashMap<String, ColumnSpec> columnSpecMap;
    private static HashMap<String, RowSpec> rowSpecMap;
    static /* synthetic */ Class class$com$jgoodies$forms$layout$ColumnSpec;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$jgoodies$forms$layout$RowSpec;

    public static ColumnSpec[] decodeColumnSpecs(String encodedColumnSpecs) {
        if (encodedColumnSpecs == null) {
            throw new NullPointerException("The column description must not be null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(encodedColumnSpecs, ", ");
        int columnCount = tokenizer.countTokens();
        ColumnSpec[] columnSpecs = new ColumnSpec[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnSpecs[i] = FormSpecCoder.decodeColumnSpec(tokenizer.nextToken());
        }
        return columnSpecs;
    }

    public static RowSpec[] decodeRowSpecs(String encodedRowSpecs) {
        if (encodedRowSpecs == null) {
            throw new NullPointerException("The row description must not be null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(encodedRowSpecs, ", ");
        int rowCount = tokenizer.countTokens();
        RowSpec[] rowSpecs = new RowSpec[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowSpecs[i] = FormSpecCoder.decodeRowSpec(tokenizer.nextToken());
        }
        return rowSpecs;
    }

    public static ColumnSpec decodeColumnSpec(String encodedColumnSpec) {
        ColumnSpec columnSpec;
        String spec = encodedColumnSpec.toLowerCase();
        if (spec.startsWith("id.")) {
            int sepIndex = spec.indexOf(61);
            if (FormSpecCoder.isUseLayoutMap()) {
                String id = spec.substring("id.".length(), sepIndex);
                try {
                    Class<?> clazz = class$com$jgoodies$forms$layout$ColumnSpec;
                    if (clazz == null) {
                        clazz = class$com$jgoodies$forms$layout$ColumnSpec = new ColumnSpec[0].getClass().getComponentType();
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$java$lang$String;
                    if (clazz2 == null) {
                        clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
                    }
                    classArray[0] = clazz2;
                    return (ColumnSpec)clazz.getMethod("decode", classArray).invoke(null, "${" + id + "}");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            spec = spec.substring(sepIndex + 1);
        }
        if ((columnSpec = columnSpecMap.get(spec)) != null) {
            return columnSpec;
        }
        return FormSpecCoder.newColumnSpec(spec);
    }

    public static ColumnSpec newColumnSpec(String spec) {
        if (spec.indexOf(60) >= 0) {
            return (ColumnSpec)FormSpecCoder.parseAndInitValues(spec, true);
        }
        return new ColumnSpec(spec);
    }

    public static RowSpec decodeRowSpec(String encodedRowSpec) {
        RowSpec rowSpec;
        String spec = encodedRowSpec.toLowerCase();
        if (spec.startsWith("id.")) {
            int sepIndex = spec.indexOf(61);
            if (FormSpecCoder.isUseLayoutMap()) {
                String id = spec.substring("id.".length(), sepIndex);
                try {
                    Class<?> clazz = class$com$jgoodies$forms$layout$RowSpec;
                    if (clazz == null) {
                        clazz = class$com$jgoodies$forms$layout$RowSpec = new RowSpec[0].getClass().getComponentType();
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$java$lang$String;
                    if (clazz2 == null) {
                        clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
                    }
                    classArray[0] = clazz2;
                    return (RowSpec)clazz.getMethod("decode", classArray).invoke(null, "${" + id + "}");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            spec = spec.substring(sepIndex + 1);
        }
        if ((rowSpec = rowSpecMap.get(spec)) != null) {
            return rowSpec;
        }
        return FormSpecCoder.newRowSpec(spec);
    }

    public static RowSpec newRowSpec(String spec) {
        if (spec.indexOf(60) >= 0) {
            return (RowSpec)FormSpecCoder.parseAndInitValues(spec, false);
        }
        return new RowSpec(spec);
    }

    public static String encodeColumnSpecs(ColumnSpec[] columnSpecs) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < columnSpecs.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(FormSpecCoder.encodeColumnSpec(columnSpecs[i]));
        }
        return buffer.toString();
    }

    public static String encodeRowSpecs(RowSpec[] rowSpecs) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rowSpecs.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(FormSpecCoder.encodeRowSpec(rowSpecs[i]));
        }
        return buffer.toString();
    }

    public static String encodeColumnSpec(ColumnSpec columnSpec) {
        return FormSpecCoder.encodeColumnSpec(columnSpec, false);
    }

    public static String encodeColumnSpec(ColumnSpec columnSpec, boolean newBoundedStyle) {
        for (int i = 0; i < columnSpecs.length; i += 2) {
            if (columnSpec != columnSpecs[i + 1]) continue;
            return (String)columnSpecs[i];
        }
        return FormSpecCoder.encodeFormSpec((FormSpec)columnSpec, ColumnSpec.DEFAULT, newBoundedStyle);
    }

    public static String encodeRowSpec(RowSpec rowSpec) {
        return FormSpecCoder.encodeRowSpec(rowSpec, false);
    }

    public static String encodeRowSpec(RowSpec rowSpec, boolean newBoundedStyle) {
        for (int i = 0; i < rowSpecs.length; i += 2) {
            if (rowSpec != rowSpecs[i + 1]) continue;
            return (String)rowSpecs[i];
        }
        return FormSpecCoder.encodeFormSpec((FormSpec)rowSpec, RowSpec.DEFAULT, newBoundedStyle);
    }

    public static String encodeFormSpec(FormSpec spec, FormSpec.DefaultAlignment def) {
        return FormSpecCoder.encodeFormSpec(spec, def, false);
    }

    public static String encodeFormSpec(FormSpec spec, FormSpec.DefaultAlignment def, boolean newBoundedStyle) {
        StringBuffer buffer = new StringBuffer();
        FormSpec.DefaultAlignment defaultAlignment = spec.getDefaultAlignment();
        if (defaultAlignment != def) {
            buffer.append(defaultAlignment);
            buffer.append(':');
        }
        buffer.append(FormSpecCoder.encodeSize(spec.getSize(), newBoundedStyle));
        double resizeWeight = spec.getResizeWeight();
        if (resizeWeight != 0.0) {
            buffer.append(':');
            if (resizeWeight == 1.0) {
                buffer.append("grow");
            } else {
                buffer.append("grow(");
                buffer.append(resizeWeight);
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    public static String encodeSize(Size size) {
        return FormSpecCoder.encodeSize(size, false);
    }

    public static String encodeSize(Size size, boolean newBoundedStyle) {
        if (size == Sizes.MINIMUM) {
            return "min";
        }
        if (size == Sizes.PREFERRED) {
            return "pref";
        }
        if (size == Sizes.DEFAULT) {
            return "default";
        }
        if (size instanceof ConstantSize) {
            ConstantSize constSize = (ConstantSize)size;
            double value = constSize.getValue();
            ConstantSize.Unit unit = constSize.getUnit();
            String abbreviation = unit.abbreviation();
            if (unit == ConstantSize.DIALOG_UNITS_X || unit == ConstantSize.DIALOG_UNITS_Y) {
                abbreviation = "dlu";
            }
            if (unit == ConstantSize.MILLIMETER || unit == ConstantSize.CENTIMETER || unit == ConstantSize.INCH) {
                return Double.toString(value) + abbreviation;
            }
            return Integer.toString((int)value) + abbreviation;
        }
        if (FormSpecCoder.isPrototypeSize(size)) {
            try {
                return (String)size.getClass().getMethod("encode", null).invoke((Object)size, (Object[])null);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Prototype size specification requires JGoodies Forms 1.2 or later.");
            }
        }
        if (size instanceof BoundedSize) {
            BoundedSize boundedSize = (BoundedSize)size;
            Size basis = boundedSize.getBasis();
            Size lowerBound = boundedSize.getLowerBound();
            Size upperBound = boundedSize.getUpperBound();
            StringBuffer buffer = new StringBuffer();
            if (newBoundedStyle) {
                buffer.append('[');
                if (lowerBound != null) {
                    buffer.append(FormSpecCoder.encodeSize(lowerBound));
                    buffer.append(',');
                }
                buffer.append(FormSpecCoder.encodeSize(basis));
                if (upperBound != null) {
                    buffer.append(',');
                    buffer.append(FormSpecCoder.encodeSize(upperBound));
                }
                buffer.append(']');
            } else if (lowerBound != null && upperBound != null) {
                buffer.append('(');
                if (lowerBound != null) {
                    buffer.append(FormSpecCoder.encodeSize(lowerBound));
                    buffer.append('<');
                }
                buffer.append(FormSpecCoder.encodeSize(basis));
                if (upperBound != null) {
                    buffer.append('<');
                    buffer.append(FormSpecCoder.encodeSize(upperBound));
                }
                buffer.append(')');
            } else if (lowerBound != null) {
                buffer.append("max(");
                buffer.append(FormSpecCoder.encodeSize(basis));
                buffer.append(';');
                buffer.append(FormSpecCoder.encodeSize(lowerBound));
                buffer.append(')');
            } else if (upperBound != null) {
                buffer.append("min(");
                buffer.append(FormSpecCoder.encodeSize(basis));
                buffer.append(';');
                buffer.append(FormSpecCoder.encodeSize(upperBound));
                buffer.append(')');
            } else {
                buffer.append(FormSpecCoder.encodeSize(basis));
            }
            return buffer.toString();
        }
        try {
            return (String)size.getClass().getMethod("encode", null).invoke((Object)size, (Object[])null);
        }
        catch (Exception ex) {
            return size.toString();
        }
    }

    public static int[][] decodeGroupIndices(String encodedGroupIds) {
        int[] groupIds = FormSpecCoder.decodeIntArray(encodedGroupIds);
        return FormSpecCoder.groupIds2Indices(groupIds);
    }

    public static int[][] groupIds2Indices(int[] groupIds) {
        int[] ids = (int[])groupIds.clone();
        ArrayList<int[]> arr = null;
        for (int i = 0; i < ids.length; ++i) {
            int groupId = groupIds[i];
            if (groupId == 0) continue;
            int count = 1;
            for (int j = i + 1; j < ids.length; ++j) {
                if (ids[j] != groupId) continue;
                ++count;
            }
            if (count == 1) continue;
            int[] group = new int[count];
            int k = 0;
            for (int j = i; j < ids.length; ++j) {
                if (ids[j] != groupId) continue;
                group[k++] = j + 1;
                ids[j] = 0;
            }
            if (arr == null) {
                arr = new ArrayList<int[]>();
            }
            arr.add(group);
        }
        return arr != null ? (int[][])arr.toArray((T[])new int[arr.size()][]) : (int[][])null;
    }

    public static int[] decodeIntArray(String str) {
        if (str == null) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(str, ", ");
        int count = st.countTokens();
        int[] array = new int[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = Integer.parseInt(st.nextToken());
        }
        return array;
    }

    private static FormSpec parseAndInitValues(String encodedDescription, boolean horizontal) {
        StringTokenizer tokenizer = new StringTokenizer(encodedDescription, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String token = tokenizer.nextToken();
        FormSpec.DefaultAlignment defaultAlignment = horizontal ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
        Sizes.ComponentSize size = Sizes.DEFAULT;
        double resizeWeight = 0.0;
        FormSpec.DefaultAlignment alignment = FormSpecCoder.valueOf(token, horizontal);
        if (alignment != null) {
            defaultAlignment = alignment;
            if (!tokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            token = tokenizer.nextToken();
        }
        size = FormSpecCoder.parseAndInitSize(token, horizontal);
        if (tokenizer.hasMoreTokens()) {
            resizeWeight = FormSpecCoder.decodeResize(tokenizer.nextToken());
        }
        if (horizontal) {
            return new ColumnSpec(defaultAlignment, (Size)size, resizeWeight);
        }
        return new RowSpec(defaultAlignment, (Size)size, resizeWeight);
    }

    private static Size parseAndInitSize(String token, boolean horizontal) {
        if (token.startsWith("max(") && token.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(token, false, horizontal);
        }
        if (token.startsWith("min(") && token.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(token, true, horizontal);
        }
        if (token.startsWith("(") && token.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(token.substring(1, token.length() - 1), horizontal);
        }
        if (token.indexOf("<") >= 0) {
            return FormSpecCoder.parseAndInitBoundedSize(token, horizontal);
        }
        return FormSpecCoder.decodeAtomicSize(token, horizontal);
    }

    private static Size parseAndInitBoundedSize(String token, boolean horizontal) {
        Size size3;
        int delim1Index = token.indexOf(60);
        int delim2Index = token.indexOf(60, delim1Index + 1);
        String sizeToken1 = delim1Index > 0 ? token.substring(0, delim1Index) : "";
        String sizeToken2 = delim2Index > 0 ? token.substring(delim1Index + 1, delim2Index) : token.substring(delim1Index + 1);
        String sizeToken3 = delim2Index > 0 ? token.substring(delim2Index + 1) : "";
        Size size1 = sizeToken1.length() > 0 ? FormSpecCoder.decodeAtomicSize(sizeToken1, horizontal) : null;
        Size size2 = FormSpecCoder.decodeAtomicSize(sizeToken2, horizontal);
        Size size = size3 = sizeToken3.length() > 0 ? FormSpecCoder.decodeAtomicSize(sizeToken3, horizontal) : null;
        if (FormSpecCoder.isComponentSize(size1) && size3 == null) {
            size3 = size2;
            size2 = size1;
            size1 = null;
        }
        if (size1 != null && !FormSpecCoder.isConstant(size1)) {
            throw new IllegalArgumentException("Lower size must be a constant.");
        }
        if (!FormSpecCoder.isComponentSize(size2)) {
            throw new IllegalArgumentException("Basis size must be a component size.");
        }
        if (size3 != null && !FormSpecCoder.isConstant(size3)) {
            throw new IllegalArgumentException("Upper size must be a constant.");
        }
        return Sizes.bounded((Size)size2, (Size)size1, (Size)size3);
    }

    private static Size parseAndInitBoundedSize(String token, boolean setMax, boolean horizontal) {
        int semicolonIndex = token.indexOf(59);
        String sizeToken1 = token.substring(4, semicolonIndex);
        String sizeToken2 = token.substring(semicolonIndex + 1, token.length() - 1);
        Size size1 = FormSpecCoder.decodeAtomicSize(sizeToken1, horizontal);
        Size size2 = FormSpecCoder.decodeAtomicSize(sizeToken2, horizontal);
        if (FormSpecCoder.isConstant(size1)) {
            if (FormSpecCoder.isComponentSize(size2)) {
                return Sizes.bounded((Size)size2, (Size)(setMax ? null : size1), (Size)(setMax ? size1 : null));
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (FormSpecCoder.isConstant(size2)) {
            return Sizes.bounded((Size)size1, (Size)(setMax ? null : size2), (Size)(setMax ? size2 : null));
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private static Size decodeAtomicSize(String token, boolean horizontal) {
        Size componentSize = FormSpecCoder.valueOf(token);
        if (componentSize != null) {
            return componentSize;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            if (token.length() < 2) {
                throw new IllegalArgumentException("Missing closing \"'\" for prototype.");
            }
            return FormSpecCoder.newPrototypeSize(token.substring(1, token.length() - 1));
        }
        return Sizes.constant((String)token, (boolean)horizontal);
    }

    private static Size newPrototypeSize(String prototype) {
        try {
            Class<?> cls = Class.forName("com.jgoodies.forms.layout.PrototypeSize");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz;
            return (Size)cls.getConstructor(classArray).newInstance(prototype);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Prototype size specification requires JGoodies Forms 1.2 or later.");
        }
    }

    private static double decodeResize(String token) {
        if (token.equals("g") || token.equals("grow")) {
            return 1.0;
        }
        if (token.equals("n") || token.equals("nogrow") || token.equals("none")) {
            return 0.0;
        }
        if ((token.startsWith("grow(") || token.startsWith("g(")) && token.endsWith(")")) {
            int leftParen = token.indexOf(40);
            int rightParen = token.indexOf(41);
            String substring = token.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private static FormSpec.DefaultAlignment valueOf(String str, boolean isHorizontal) {
        if (str.equals("f") || str.equals("fill")) {
            return ColumnSpec.FILL;
        }
        if (str.equals("c") || str.equals("center")) {
            return ColumnSpec.CENTER;
        }
        if (isHorizontal) {
            if (str.equals("r") || str.equals("right")) {
                return ColumnSpec.RIGHT;
            }
            if (str.equals("l") || str.equals("left")) {
                return ColumnSpec.LEFT;
            }
            return null;
        }
        if (str.equals("t") || str.equals("top")) {
            return RowSpec.TOP;
        }
        if (str.equals("b") || str.equals("bottom")) {
            return RowSpec.BOTTOM;
        }
        return null;
    }

    private static Size valueOf(String str) {
        if (str.equals("m") || str.equals("min")) {
            return Sizes.MINIMUM;
        }
        if (str.equals("p") || str.equals("pref")) {
            return Sizes.PREFERRED;
        }
        if (str.equals("d") || str.equals("default")) {
            return Sizes.DEFAULT;
        }
        return null;
    }

    private static boolean isComponentSize(Size size) {
        return size == Sizes.DEFAULT || size == Sizes.PREFERRED || size == Sizes.MINIMUM;
    }

    private static boolean isConstant(Size size) {
        return size instanceof ConstantSize || FormSpecCoder.isPrototypeSize(size);
    }

    private static boolean isPrototypeSize(Size size) {
        if (size == null) {
            return false;
        }
        for (Class<?> cls = size.getClass(); cls != null; cls = cls.getSuperclass()) {
            if (!cls.getName().equals("com.jgoodies.forms.layout.PrototypeSize")) continue;
            return true;
        }
        return false;
    }

    private static boolean isUseLayoutMap() {
        if (useLayoutMap == null) {
            try {
                Class.forName("com.jgoodies.forms.layout.PrototypeSize");
                useLayoutMap = Boolean.TRUE;
            }
            catch (Exception ex) {
                useLayoutMap = Boolean.FALSE;
            }
        }
        return useLayoutMap;
    }

    static {
        int i;
        columnSpecs = new Object[]{"min", FormFactory.MIN_COLSPEC, "m", FormFactory.MIN_COLSPEC, "pref", FormFactory.PREF_COLSPEC, "p", FormFactory.PREF_COLSPEC, "default", FormFactory.DEFAULT_COLSPEC, "d", FormFactory.DEFAULT_COLSPEC, "glue", FormFactory.GLUE_COLSPEC, "relgap", FormFactory.RELATED_GAP_COLSPEC, "rgap", FormFactory.RELATED_GAP_COLSPEC, "gap", FormFactory.RELATED_GAP_COLSPEC, "unrelgap", FormFactory.UNRELATED_GAP_COLSPEC, "ugap", FormFactory.UNRELATED_GAP_COLSPEC, "labelcompgap", FormFactory.LABEL_COMPONENT_GAP_COLSPEC, "lcgap", FormFactory.LABEL_COMPONENT_GAP_COLSPEC, "button", FormFactory.BUTTON_COLSPEC, "growbutton", FormFactory.GROWING_BUTTON_COLSPEC, "gbutton", FormFactory.GROWING_BUTTON_COLSPEC};
        rowSpecs = new Object[]{"min", FormFactory.MIN_ROWSPEC, "m", FormFactory.MIN_ROWSPEC, "pref", FormFactory.PREF_ROWSPEC, "p", FormFactory.PREF_ROWSPEC, "default", FormFactory.DEFAULT_ROWSPEC, "d", FormFactory.DEFAULT_ROWSPEC, "glue", FormFactory.GLUE_ROWSPEC, "relgap", FormFactory.RELATED_GAP_ROWSPEC, "rgap", FormFactory.RELATED_GAP_ROWSPEC, "gap", FormFactory.RELATED_GAP_ROWSPEC, "unrelgap", FormFactory.UNRELATED_GAP_ROWSPEC, "ugap", FormFactory.UNRELATED_GAP_ROWSPEC, "narrowlinegap", FormFactory.NARROW_LINE_GAP_ROWSPEC, "nlinegap", FormFactory.NARROW_LINE_GAP_ROWSPEC, "linegap", FormFactory.LINE_GAP_ROWSPEC, "pargap", FormFactory.PARAGRAPH_GAP_ROWSPEC};
        columnSpecMap = new HashMap(columnSpecs.length);
        for (i = 0; i < columnSpecs.length; i += 2) {
            columnSpecMap.put((String)columnSpecs[i], (ColumnSpec)columnSpecs[i + 1]);
        }
        rowSpecMap = new HashMap(rowSpecs.length);
        for (i = 0; i < rowSpecs.length; i += 2) {
            rowSpecMap.put((String)rowSpecs[i], (RowSpec)rowSpecs[i + 1]);
        }
    }
}

