/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.windows.WindowsArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public final class WindowsSpinnerUI
extends com.sun.java.swing.plaf.windows.WindowsSpinnerUI {
    Insets defaultEditorInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsSpinnerUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.defaultEditorInsets = UIManager.getInsets("Spinner.defaultEditorInsets");
    }

    protected Component createPreviousButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createPreviousButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(5);
        this.installPreviousButtonListenersFromSuper(windowsArrowButton);
        return windowsArrowButton;
    }

    protected Component createNextButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createNextButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(1);
        this.installNextButtonListenersFromSuper(windowsArrowButton);
        return windowsArrowButton;
    }

    protected void installPreviousButtonListenersFromSuper(Component component) {
        AbstractButton abstractButton = (AbstractButton)super.createPreviousButton();
        ActionListener[] actionListenerArray = abstractButton.getActionListeners();
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(actionListenerArray[0]);
        }
        component.addMouseListener(mouseListenerArray[0]);
    }

    protected void installNextButtonListenersFromSuper(Component component) {
        AbstractButton abstractButton = (AbstractButton)super.createNextButton();
        ActionListener[] actionListenerArray = abstractButton.getActionListeners();
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(actionListenerArray[0]);
        }
        component.addMouseListener(mouseListenerArray[0]);
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditorBorder(jComponent);
        return jComponent;
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditorBorder(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditorBorder(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = this.defaultEditorInsets;
            jFormattedTextField.setBorder(new EmptyBorder(insets));
        } else if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(0);
            Insets insets = this.defaultEditorInsets;
            jComponent2.setBorder(new EmptyBorder(insets));
        }
    }
}

