/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public final class PlasticTextAreaUI
extends BasicTextAreaUI {
    private Color disabledBackground;
    private Color inactiveBackground;
    private Color defaultBackground;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTextAreaUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateBackground((JTextComponent)jComponent);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.disabledBackground = UIManager.getColor("TextArea.disabledBackground");
        this.inactiveBackground = UIManager.getColor("TextArea.inactiveBackground");
        this.defaultBackground = UIManager.getColor("TextArea.background");
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("editable".equals(string) || "enabled".equals(string)) {
            this.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private void updateBackground(JTextComponent jTextComponent) {
        Color color = jTextComponent.getBackground();
        if (!(color instanceof UIResource)) {
            return;
        }
        Color color2 = null;
        if (!jTextComponent.isEnabled()) {
            color2 = this.disabledBackground;
        }
        if (color2 == null && !jTextComponent.isEditable()) {
            color2 = this.inactiveBackground;
        }
        if (color2 == null) {
            color2 = this.defaultBackground;
        }
        if (color2 != null && color2 != color) {
            jTextComponent.setBackground(color2);
        }
    }
}

