/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.FontPolicies$CustomSettingsPolicy;
import com.jgoodies.looks.FontPolicies$DefaultPlasticOnWindowsPolicy;
import com.jgoodies.looks.FontPolicies$DefaultWindowsPolicy;
import com.jgoodies.looks.FontPolicies$FixedPolicy;
import com.jgoodies.looks.FontPolicies$Looks1xWindowsPolicy;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FontPolicies$FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy fontPolicy) {
        return new FontPolicies$CustomSettingsPolicy(fontPolicy);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new FontPolicies$DefaultPlasticOnWindowsPolicy(null);
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (LookUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new FontPolicies$DefaultWindowsPolicy(null);
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    public static FontPolicy getLooks1xPlasticPolicy() {
        Font font;
        Font font2 = font = Fonts.getDefaultGUIFontWesternModernWindowsNormal();
        Font font3 = font.deriveFont(1);
        FontSet fontSet = FontSets.createDefaultFontSet(font, font2, font3);
        return FontPolicies.createFixedPolicy(fontSet);
    }

    public static FontPolicy getLooks1xWindowsPolicy() {
        return new FontPolicies$Looks1xWindowsPolicy(null);
    }

    public static FontPolicy getTransitionalPlasticPolicy() {
        return LookUtils.IS_OS_WINDOWS ? FontPolicies.getDefaultPlasticOnWindowsPolicy() : FontPolicies.getLooks1xPlasticPolicy();
    }

    private static FontSet getCustomFontSet(String string) {
        String string2 = string + ".controlFont";
        String string3 = string + ".menuFont";
        String string4 = LookUtils.getSystemProperty(string2);
        if (string4 == null) {
            return null;
        }
        Font font = Font.decode(string4);
        String string5 = LookUtils.getSystemProperty(string3);
        Font font2 = string5 != null ? Font.decode(string5) : null;
        Font font3 = "Plastic".equals(string) ? font.deriveFont(1) : font;
        return FontSets.createDefaultFontSet(font, font2, font3);
    }

    private static FontPolicy getCustomPolicy(String string) {
        return null;
    }

    static /* synthetic */ FontPolicy access$300(String string) {
        return FontPolicies.getCustomPolicy(string);
    }

    static /* synthetic */ FontSet access$400(String string) {
        return FontPolicies.getCustomFontSet(string);
    }
}

