/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public final class BorderStyle {
    public static final BorderStyle EMPTY = new BorderStyle("Empty");
    public static final BorderStyle SEPARATOR = new BorderStyle("Separator");
    public static final BorderStyle ETCHED = new BorderStyle("Etched");
    private final String name;

    private BorderStyle(String string) {
        this.name = string;
    }

    public static BorderStyle from(JToolBar jToolBar, String string) {
        return BorderStyle.from0(jToolBar, string);
    }

    public static BorderStyle from(JMenuBar jMenuBar, String string) {
        return BorderStyle.from0(jMenuBar, string);
    }

    private static BorderStyle from0(JComponent jComponent, String string) {
        Object object = jComponent.getClientProperty(string);
        if (object instanceof BorderStyle) {
            return (BorderStyle)object;
        }
        if (object instanceof String) {
            return BorderStyle.valueOf((String)object);
        }
        return null;
    }

    private static BorderStyle valueOf(String string) {
        if (string.equalsIgnoreCase(BorderStyle.EMPTY.name)) {
            return EMPTY;
        }
        if (string.equalsIgnoreCase(BorderStyle.SEPARATOR.name)) {
            return SEPARATOR;
        }
        if (string.equalsIgnoreCase(BorderStyle.ETCHED.name)) {
            return ETCHED;
        }
        throw new IllegalArgumentException("Invalid BorderStyle name " + string);
    }

    public String toString() {
        return this.name;
    }
}

