/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.DefaultUnitConverter;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class FormUtils {
    private static LookAndFeel cachedLookAndFeel;
    private static Boolean cachedIsLafAqua;

    private FormUtils() {
    }

    public static void assertNotBlank(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("The " + string2 + " must not be null.");
        }
        if (FormUtils.isBlank(string)) {
            throw new IllegalArgumentException("The " + string2 + " must not be empty, or whitespace. " + "See FormUtils.isBlank(String)");
        }
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The " + string + " must not be null.");
        }
    }

    public static boolean equals(Object object, Object object2) {
        return object != null && object2 != null && object.equals(object2) || object == null && object2 == null;
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return false;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isLafAqua() {
        FormUtils.ensureValidCache();
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = FormUtils.computeIsLafAqua();
        }
        return cachedIsLafAqua;
    }

    public static void clearLookAndFeelBasedCaches() {
        cachedIsLafAqua = null;
        DefaultUnitConverter.getInstance().clearCache();
    }

    private static boolean computeIsLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    static void ensureValidCache() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != cachedLookAndFeel) {
            FormUtils.clearLookAndFeelBasedCaches();
            cachedLookAndFeel = lookAndFeel;
        }
    }
}

