/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;

public class TornadoSprite
extends Sprite {
    static int[] CDx = new int[]{2, 3, 2, 0, -2, -3};
    static int[] CDy = new int[]{-2, 0, 2, 3, 2, 0};
    boolean flag;
    int count;

    public TornadoSprite(Micropolis engine, int xpos, int ypos) {
        super(engine, SpriteKind.TOR);
        this.x = xpos * 16 + 8;
        this.y = ypos * 16 + 8;
        this.width = 48;
        this.height = 48;
        this.offx = -24;
        this.offy = -40;
        this.frame = 1;
        this.count = 200;
    }

    @Override
    public void moveImpl() {
        int z = this.frame;
        if (z == 2) {
            z = this.flag ? 3 : 1;
        } else {
            this.flag = z == 1;
            z = 2;
        }
        if (this.count > 0) {
            --this.count;
        }
        this.frame = z;
        for (Sprite s : this.city.allSprites()) {
            if (!this.checkSpriteCollision(s) || s.kind != SpriteKind.AIR && s.kind != SpriteKind.COP && s.kind != SpriteKind.SHI && s.kind != SpriteKind.TRA) continue;
            s.explodeSprite();
        }
        int zz = this.city.PRNG.nextInt(CDx.length);
        this.x += CDx[zz];
        this.y += CDy[zz];
        if (!this.city.testBounds(this.x / 16, this.y / 16)) {
            this.frame = 0;
            return;
        }
        if (this.count == 0 && this.city.PRNG.nextInt(501) == 0) {
            this.frame = 0;
            return;
        }
        this.destroyTile(this.x / 16, this.y / 16);
    }
}

