/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TileBehavior;
import micropolisj.engine.TileConstants;

class TerrainBehavior
extends TileBehavior {
    final B behavior;
    static int[] TRAFFIC_DENSITY_TAB = new int[]{64, 80, 144};

    TerrainBehavior(Micropolis city, B behavior) {
        super(city);
        this.behavior = behavior;
    }

    @Override
    public void apply() {
        switch (this.behavior) {
            case FIRE: {
                this.doFire();
                return;
            }
            case FLOOD: {
                this.doFlood();
                return;
            }
            case RADIOACTIVE: {
                this.doRadioactiveTile();
                return;
            }
            case ROAD: {
                this.doRoad();
                return;
            }
            case RAIL: {
                this.doRail();
                return;
            }
            case EXPLOSION: {
                this.doExplosion();
                return;
            }
        }
        assert (false);
    }

    void doFire() {
        int rate;
        ++this.city.firePop;
        if (this.PRNG.nextInt(4) != 0) {
            return;
        }
        int[] DX = new int[]{0, 1, 0, -1};
        int[] DY = new int[]{-1, 0, 1, 0};
        for (int dir = 0; dir < 4; ++dir) {
            char c;
            int ytem;
            int xtem;
            if (this.PRNG.nextInt(8) != 0 || !this.city.testBounds(xtem = this.xpos + DX[dir], ytem = this.ypos + DY[dir]) || !TileConstants.isCombustible(c = this.city.getTile(xtem, ytem))) continue;
            if (TileConstants.isZoneCenter(c)) {
                this.city.killZone(xtem, ytem, c);
                if (c > '\u0271') {
                    this.city.makeExplosion(xtem, ytem);
                }
            }
            this.city.setTile(xtem, ytem, (char)(56 + this.PRNG.nextInt(4)));
        }
        int cov = this.city.getFireStationCoverage(this.xpos, this.ypos);
        int n = cov > 100 ? 1 : (cov > 20 ? 2 : (rate = cov != 0 ? 3 : 10));
        if (this.PRNG.nextInt(rate + 1) == 0) {
            this.city.setTile(this.xpos, this.ypos, (char)(44 + this.PRNG.nextInt(4)));
        }
    }

    void doFlood() {
        int[] DX = new int[]{0, 1, 0, -1};
        int[] DY = new int[]{-1, 0, 1, 0};
        if (this.city.floodCnt != 0) {
            for (int z = 0; z < 4; ++z) {
                char t;
                int yy;
                int xx;
                if (this.PRNG.nextInt(8) != 0 || !this.city.testBounds(xx = this.xpos + DX[z], yy = this.ypos + DY[z]) || !TileConstants.isCombustible(t = this.city.getTile(xx, yy)) && t != '\u0000' && (t < '+' || t >= '0')) continue;
                if (TileConstants.isZoneCenter(t)) {
                    this.city.killZone(xx, yy, t);
                }
                this.city.setTile(xx, yy, (char)(48 + this.PRNG.nextInt(3)));
            }
        } else if (this.PRNG.nextInt(16) == 0) {
            this.city.setTile(this.xpos, this.ypos, '\u0000');
        }
    }

    void doRadioactiveTile() {
        if (this.PRNG.nextInt(4096) == 0) {
            this.city.setTile(this.xpos, this.ypos, '\u0000');
        }
    }

    void doRoad() {
        int newLevel;
        int tden;
        ++this.city.roadTotal;
        if (this.city.roadEffect < 30 && this.PRNG.nextInt(512) == 0 && !TileConstants.isConductive(this.tile) && this.city.roadEffect < this.PRNG.nextInt(32)) {
            if (TileConstants.isOverWater(this.tile)) {
                this.city.setTile(this.xpos, this.ypos, '\u0002');
            } else {
                this.city.setTile(this.xpos, this.ypos, (char)(44 + this.PRNG.nextInt(4)));
            }
            return;
        }
        if (!TileConstants.isCombustible(this.tile)) {
            this.city.roadTotal += 4;
            if (this.doBridge()) {
                return;
            }
        }
        if (this.tile < 80) {
            tden = 0;
        } else if (this.tile < 144) {
            tden = 1;
        } else {
            ++this.city.roadTotal;
            tden = 2;
        }
        int trafficDensity = this.city.getTrafficDensity(this.xpos, this.ypos);
        int n = trafficDensity < 64 ? 0 : (newLevel = trafficDensity < 192 ? 1 : 2);
        assert (newLevel >= 0 && newLevel < TRAFFIC_DENSITY_TAB.length);
        if (tden != newLevel) {
            int z = (this.tile - 64 & 0xF) + TRAFFIC_DENSITY_TAB[newLevel];
            this.city.setTile(this.xpos, this.ypos, (char)z);
        }
    }

    void doRail() {
        ++this.city.railTotal;
        this.city.generateTrain(this.xpos, this.ypos);
        if (this.city.roadEffect < 30 && this.PRNG.nextInt(512) == 0 && !TileConstants.isConductive(this.tile) && this.city.roadEffect < this.PRNG.nextInt(32)) {
            if (TileConstants.isOverWater(this.tile)) {
                this.city.setTile(this.xpos, this.ypos, '\u0002');
            } else {
                this.city.setTile(this.xpos, this.ypos, (char)(44 + this.PRNG.nextInt(4)));
            }
        }
    }

    boolean doBridge() {
        int[] HDx = new int[]{-2, 2, -2, -1, 0, 1, 2};
        int[] HDy = new int[]{-1, -1, 0, 0, 0, 0, 0};
        char[] HBRTAB = new char[]{'\u033d', '\u033f', '\u033c', '\u0002', 'O', '\u0002', '\u033e'};
        char[] HBRTAB2 = new char[]{'\u0002', '\u0002', '@', '@', '@', '@', '@'};
        int[] VDx = new int[]{0, 1, 0, 0, 0, 0, 1};
        int[] VDy = new int[]{-2, -2, -1, 0, 1, 2, 2};
        char[] VBRTAB = new char[]{'\u03b4', '\u03b5', '\u0002', '_', '\u0002', '\u03b6', '\u03b7'};
        char[] VBRTAB2 = new char[]{'A', '\u0002', 'A', 'A', 'A', 'A', '\u0002'};
        if (this.tile == 95) {
            if (this.PRNG.nextInt(4) == 0 && this.getBoatDis() > 21) {
                this.applyBridgeChange(VDx, VDy, VBRTAB, VBRTAB2);
            }
            return true;
        }
        if (this.tile == 79) {
            if (this.PRNG.nextInt(4) == 0 && this.getBoatDis() > 21) {
                this.applyBridgeChange(HDx, HDy, HBRTAB, HBRTAB2);
            }
            return true;
        }
        if (this.getBoatDis() < 18 && this.PRNG.nextInt(8) == 0) {
            if ((this.tile & 1) != 0) {
                if (this.xpos < this.city.getWidth() - 1 && this.city.getTile(this.xpos + 1, this.ypos) == '\u0004') {
                    this.applyBridgeChange(VDx, VDy, VBRTAB2, VBRTAB);
                    return true;
                }
                return false;
            }
            if (this.ypos > 0 && this.city.getTile(this.xpos, this.ypos - 1) == '\u0004') {
                this.applyBridgeChange(HDx, HDy, HBRTAB2, HBRTAB);
                return true;
            }
            return false;
        }
        return false;
    }

    private void applyBridgeChange(int[] Dx, int[] Dy, char[] fromTab, char[] toTab) {
        for (int z = 0; z < 7; ++z) {
            int x = this.xpos + Dx[z];
            int y = this.ypos + Dy[z];
            if (!this.city.testBounds(x, y) || this.city.getTile(x, y) != fromTab[z] && this.city.getTile(x, y) != '\u0004') continue;
            this.city.setTile(x, y, toTab[z]);
        }
    }

    int getBoatDis() {
        int dist = 99999;
        for (Sprite s : this.city.sprites) {
            if (!s.isVisible() || s.kind != SpriteKind.SHI) continue;
            int x = s.x / 16;
            int y = s.y / 16;
            int d = Math.abs(this.xpos - x) + Math.abs(this.ypos - y);
            dist = Math.min(d, dist);
        }
        return dist;
    }

    void doExplosion() {
        this.city.setTile(this.xpos, this.ypos, (char)(44 + this.PRNG.nextInt(4)));
    }

    static enum B {
        FIRE,
        FLOOD,
        RADIOACTIVE,
        ROAD,
        RAIL,
        EXPLOSION;

    }
}

