/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TileBehavior;
import micropolisj.engine.TileConstants;
import micropolisj.engine.TileSpec;
import micropolisj.engine.Tiles;
import micropolisj.engine.TrafficGen;

class MapScanner
extends TileBehavior {
    final B behavior;
    TrafficGen traffic;

    MapScanner(Micropolis city, B behavior) {
        super(city);
        this.behavior = behavior;
        this.traffic = new TrafficGen(city);
    }

    @Override
    public void apply() {
        switch (this.behavior) {
            case RESIDENTIAL: {
                this.doResidential();
                return;
            }
            case HOSPITAL_CHURCH: {
                this.doHospitalChurch();
                return;
            }
            case COMMERCIAL: {
                this.doCommercial();
                return;
            }
            case INDUSTRIAL: {
                this.doIndustrial();
                return;
            }
            case COAL: {
                this.doCoalPower();
                return;
            }
            case NUCLEAR: {
                this.doNuclearPower();
                return;
            }
            case FIRESTATION: {
                this.doFireStation();
                return;
            }
            case POLICESTATION: {
                this.doPoliceStation();
                return;
            }
            case STADIUM_EMPTY: {
                this.doStadiumEmpty();
                return;
            }
            case STADIUM_FULL: {
                this.doStadiumFull();
                return;
            }
            case AIRPORT: {
                this.doAirport();
                return;
            }
            case SEAPORT: {
                this.doSeaport();
                return;
            }
        }
        assert (false);
    }

    boolean checkZonePower() {
        boolean zonePwrFlag = this.setZonePower();
        if (zonePwrFlag) {
            ++this.city.poweredZoneCount;
        } else {
            ++this.city.unpoweredZoneCount;
        }
        return zonePwrFlag;
    }

    boolean setZonePower() {
        boolean newPower;
        boolean oldPower = this.city.isTilePowered(this.xpos, this.ypos);
        boolean bl = newPower = this.tile == 816 || this.tile == 750 || this.city.hasPower(this.xpos, this.ypos);
        if (newPower && !oldPower) {
            this.city.setTilePower(this.xpos, this.ypos, true);
            this.city.powerZone(this.xpos, this.ypos, TileConstants.getZoneSizeFor(this.tile));
        } else if (!newPower && oldPower) {
            this.city.setTilePower(this.xpos, this.ypos, false);
            this.city.shutdownZone(this.xpos, this.ypos, TileConstants.getZoneSizeFor(this.tile));
        }
        return newPower;
    }

    boolean zonePlop(int base) {
        assert (TileConstants.isZoneCenter(base));
        TileSpec.BuildingInfo bi = Tiles.get(base).getBuildingInfo();
        assert (bi != null);
        if (bi == null) {
            return false;
        }
        for (int y = this.ypos - 1; y < this.ypos - 1 + bi.height; ++y) {
            for (int x = this.xpos - 1; x < this.xpos - 1 + bi.width; ++x) {
                if (!this.city.testBounds(x, y)) {
                    return false;
                }
                if (!TileConstants.isIndestructible2(this.city.getTile(x, y))) continue;
                return false;
            }
        }
        assert (bi.members.length == bi.width * bi.height);
        int i = 0;
        for (int y = this.ypos - 1; y < this.ypos - 1 + bi.height; ++y) {
            for (int x = this.xpos - 1; x < this.xpos - 1 + bi.width; ++x) {
                this.city.setTile(x, y, (char)bi.members[i]);
                ++i;
            }
        }
        this.tile = this.city.getTile(this.xpos, this.ypos);
        this.setZonePower();
        return true;
    }

    void doCoalPower() {
        boolean powerOn = this.checkZonePower();
        ++this.city.coalCount;
        if (this.city.cityTime % 8 == 0) {
            this.repairZone('\u02ee', 4);
        }
        this.city.powerPlants.add(new CityLocation(this.xpos, this.ypos));
    }

    void doNuclearPower() {
        boolean powerOn = this.checkZonePower();
        if (!this.city.noDisasters) {
            if (this.PRNG.nextInt(Micropolis.MltdwnTab[this.city.gameLevel] + 1) == 0) {
                this.city.doMeltdown(this.xpos, this.ypos);
                return;
            }
        }
        ++this.city.nuclearCount;
        if (this.city.cityTime % 8 == 0) {
            this.repairZone('\u0330', 4);
        }
        this.city.powerPlants.add(new CityLocation(this.xpos, this.ypos));
    }

    void doFireStation() {
        boolean powerOn = this.checkZonePower();
        ++this.city.fireStationCount;
        if (this.city.cityTime % 8 == 0) {
            this.repairZone('\u02fd', 3);
        }
        int z = powerOn ? this.city.fireEffect : this.city.fireEffect / 2;
        this.traffic.mapX = this.xpos;
        this.traffic.mapY = this.ypos;
        if (!this.traffic.findPerimeterRoad()) {
            z /= 2;
        }
        int[] nArray = this.city.fireStMap[this.ypos / 8];
        int n = this.xpos / 8;
        nArray[n] = nArray[n] + z;
    }

    void doPoliceStation() {
        boolean powerOn = this.checkZonePower();
        ++this.city.policeCount;
        if (this.city.cityTime % 8 == 0) {
            this.repairZone('\u0306', 3);
        }
        int z = powerOn ? this.city.policeEffect : this.city.policeEffect / 2;
        this.traffic.mapX = this.xpos;
        this.traffic.mapY = this.ypos;
        if (!this.traffic.findPerimeterRoad()) {
            z /= 2;
        }
        int[] nArray = this.city.policeMap[this.ypos / 8];
        int n = this.xpos / 8;
        nArray[n] = nArray[n] + z;
    }

    void doStadiumEmpty() {
        boolean powerOn = this.checkZonePower();
        ++this.city.stadiumCount;
        if (this.city.cityTime % 16 == 0) {
            this.repairZone('\u0310', 4);
        }
        if (powerOn && (this.city.cityTime + this.xpos + this.ypos) % 32 == 0) {
            this.drawStadium(800);
            this.city.setTile(this.xpos + 1, this.ypos, '\u03a4');
            this.city.setTile(this.xpos + 1, this.ypos + 1, '\u03ac');
        }
    }

    void doStadiumFull() {
        boolean powerOn = this.checkZonePower();
        ++this.city.stadiumCount;
        if ((this.city.cityTime + this.xpos + this.ypos) % 8 == 0) {
            this.drawStadium(784);
        }
    }

    void doAirport() {
        boolean powerOn = this.checkZonePower();
        ++this.city.airportCount;
        if (this.city.cityTime % 8 == 0) {
            this.repairZone('\u02cc', 6);
        }
        if (powerOn) {
            if (this.PRNG.nextInt(6) == 0) {
                this.city.generatePlane(this.xpos, this.ypos);
            }
            if (this.PRNG.nextInt(13) == 0) {
                this.city.generateCopter(this.xpos, this.ypos);
            }
        }
    }

    void doSeaport() {
        boolean powerOn = this.checkZonePower();
        ++this.city.seaportCount;
        if (this.city.cityTime % 16 == 0) {
            this.repairZone('\u02ba', 4);
        }
        if (powerOn && !this.city.hasSprite(SpriteKind.SHI)) {
            this.city.generateShip();
        }
    }

    void makeHospital() {
        if (this.city.needHospital > 0) {
            this.zonePlop(409);
            this.city.needHospital = 0;
        }
        if (this.city.needChurch > 0) {
            this.zonePlop(418);
            this.city.needChurch = 0;
        }
    }

    void doHospitalChurch() {
        boolean powerOn = this.checkZonePower();
        if (this.tile == 409) {
            ++this.city.hospitalCount;
            if (this.city.cityTime % 16 == 0) {
                this.repairZone('\u0199', 3);
            }
            if (this.city.needHospital == -1 && this.PRNG.nextInt(21) == 0) {
                this.zonePlop(244);
            }
        } else if (this.tile == 418) {
            ++this.city.churchCount;
            if (this.city.cityTime % 16 == 0) {
                this.repairZone('\u01a2', 3);
            }
            if (this.city.needChurch == -1 && this.PRNG.nextInt(21) == 0) {
                this.zonePlop(244);
            }
        }
    }

    void repairZone(char zoneCenter, int zoneSize) {
        int zoneBase = zoneCenter - '\u0001' - zoneSize;
        for (int y = 0; y < zoneSize; ++y) {
            int x = 0;
            while (x < zoneSize) {
                char thCh;
                int xx = this.xpos - 1 + x;
                int yy = this.ypos - 1 + y;
                if (this.city.testBounds(xx, yy) && !TileConstants.isZoneCenter(thCh = this.city.getTile(xx, yy)) && !TileConstants.isAnimated(thCh) && !TileConstants.isIndestructible(thCh)) {
                    this.city.setTile(xx, yy, (char)zoneBase);
                }
                ++x;
                ++zoneBase;
            }
        }
    }

    void doCommercial() {
        boolean powerOn = this.checkZonePower();
        ++this.city.comZoneCount;
        int tpop = TileConstants.commercialZonePop(this.tile);
        this.city.comPop += tpop;
        int trafficGood = tpop > this.PRNG.nextInt(6) ? this.makeTraffic(TrafficGen.ZoneType.COMMERCIAL) : 1;
        if (trafficGood == -1) {
            int value = this.getCRValue();
            this.doCommercialOut(tpop, value);
            return;
        }
        if (this.PRNG.nextInt(8) == 0) {
            int locValve = this.evalCommercial(trafficGood);
            int zscore = this.city.comValve + locValve;
            if (!powerOn) {
                zscore = -500;
            }
            if (trafficGood != 0 && zscore > -350 && zscore - 26380 > this.PRNG.nextInt(65536) - 32768) {
                int value = this.getCRValue();
                this.doCommercialIn(tpop, value);
                return;
            }
            if (zscore < 350 && zscore + 26380 < this.PRNG.nextInt(65536) - 32768) {
                int value = this.getCRValue();
                this.doCommercialOut(tpop, value);
            }
        }
    }

    void doIndustrial() {
        boolean powerOn = this.checkZonePower();
        ++this.city.indZoneCount;
        int tpop = TileConstants.industrialZonePop(this.tile);
        this.city.indPop += tpop;
        int trafficGood = tpop > this.PRNG.nextInt(6) ? this.makeTraffic(TrafficGen.ZoneType.INDUSTRIAL) : 1;
        if (trafficGood == -1) {
            this.doIndustrialOut(tpop, this.PRNG.nextInt(2));
            return;
        }
        if (this.PRNG.nextInt(8) == 0) {
            int locValve = this.evalIndustrial(trafficGood);
            int zscore = this.city.indValve + locValve;
            if (!powerOn) {
                zscore = -500;
            }
            if (zscore > -350 && zscore - 26380 > this.PRNG.nextInt(65536) - 32768) {
                int value = this.PRNG.nextInt(2);
                this.doIndustrialIn(tpop, value);
                return;
            }
            if (zscore < 350 && zscore + 26380 < this.PRNG.nextInt(65536) - 32768) {
                int value = this.PRNG.nextInt(2);
                this.doIndustrialOut(tpop, value);
            }
        }
    }

    void doResidential() {
        boolean powerOn = this.checkZonePower();
        ++this.city.resZoneCount;
        int tpop = this.tile == 244 ? this.city.doFreePop(this.xpos, this.ypos) : TileConstants.residentialZonePop(this.tile);
        this.city.resPop += tpop;
        int trafficGood = tpop > this.PRNG.nextInt(36) ? this.makeTraffic(TrafficGen.ZoneType.RESIDENTIAL) : 1;
        if (trafficGood == -1) {
            int value = this.getCRValue();
            this.doResidentialOut(tpop, value);
            return;
        }
        if (this.tile == 244 || this.PRNG.nextInt(8) == 0) {
            int locValve = this.evalResidential(trafficGood);
            int zscore = this.city.resValve + locValve;
            if (!powerOn) {
                zscore = -500;
            }
            if (zscore > -350 && zscore - 26380 > this.PRNG.nextInt(65536) - 32768) {
                if (tpop == 0 && this.PRNG.nextInt(4) == 0) {
                    this.makeHospital();
                    return;
                }
                int value = this.getCRValue();
                this.doResidentialIn(tpop, value);
                return;
            }
            if (zscore < 350 && zscore + 26380 < this.PRNG.nextInt(65536) - 32768) {
                int value = this.getCRValue();
                this.doResidentialOut(tpop, value);
            }
        }
    }

    int evalLot(int x, int y) {
        char aTile = this.city.getTile(x, y);
        if (aTile != '\u0000' && !TileConstants.isResidentialClear(aTile)) {
            return -1;
        }
        int score = 1;
        int[] DX = new int[]{0, 1, 0, -1};
        int[] DY = new int[]{-1, 0, 1, 0};
        for (int z = 0; z < 4; ++z) {
            char tmp;
            int xx = x + DX[z];
            int yy = y + DY[z];
            if (!this.city.testBounds(xx, yy) || !TileConstants.isRoadAny(tmp = this.city.getTile(xx, yy)) && !TileConstants.isRail(tmp)) continue;
            ++score;
        }
        return score;
    }

    private void buildHouse(int value) {
        assert (value >= 0 && value <= 3);
        int[] ZeX = new int[]{0, -1, 0, 1, -1, 1, -1, 0, 1};
        int[] ZeY = new int[]{0, -1, -1, -1, 0, 0, 1, 1, 1};
        int bestLoc = 0;
        int hscore = 0;
        for (int z = 1; z < 9; ++z) {
            int score;
            int xx = this.xpos + ZeX[z];
            int yy = this.ypos + ZeY[z];
            if (!this.city.testBounds(xx, yy) || (score = this.evalLot(xx, yy)) == 0) continue;
            if (score > hscore) {
                hscore = score;
                bestLoc = z;
            }
            if (score != hscore || this.PRNG.nextInt(8) != 0) continue;
            bestLoc = z;
        }
        if (bestLoc != 0) {
            int xx = this.xpos + ZeX[bestLoc];
            int yy = this.ypos + ZeY[bestLoc];
            int houseNumber = value * 3 + this.PRNG.nextInt(3);
            assert (houseNumber >= 0 && houseNumber < 12);
            assert (this.city.testBounds(xx, yy));
            this.city.setTile(xx, yy, (char)(249 + houseNumber));
        }
    }

    private void doCommercialIn(int pop, int value) {
        int z = this.city.getLandValue(this.xpos, this.ypos) / 32;
        if (pop > z) {
            return;
        }
        if (pop < 5) {
            this.comPlop(pop, value);
            this.adjustROG(8);
        }
    }

    private void doIndustrialIn(int pop, int value) {
        if (pop < 4) {
            this.indPlop(pop, value);
            this.adjustROG(8);
        }
    }

    private void doResidentialIn(int pop, int value) {
        assert (value >= 0 && value <= 3);
        int z = this.city.pollutionMem[this.ypos / 2][this.xpos / 2];
        if (z > 128) {
            return;
        }
        if (this.tile == 244) {
            if (pop < 8) {
                this.buildHouse(value);
                this.adjustROG(1);
                return;
            }
            if (this.city.getPopulationDensity(this.xpos, this.ypos) > 64) {
                this.residentialPlop(0, value);
                this.adjustROG(8);
                return;
            }
            return;
        }
        if (pop < 40) {
            this.residentialPlop(pop / 8 - 1, value);
            this.adjustROG(8);
        }
    }

    void comPlop(int density, int value) {
        int base = (value * 5 + density) * 9 + 436;
        this.zonePlop(base);
    }

    void indPlop(int density, int value) {
        int base = (value * 4 + density) * 9 + 625;
        this.zonePlop(base);
    }

    void residentialPlop(int density, int value) {
        int base = (value * 4 + density) * 9 + 265;
        this.zonePlop(base);
    }

    private void doCommercialOut(int pop, int value) {
        if (pop > 1) {
            this.comPlop(pop - 2, value);
            this.adjustROG(-8);
        } else if (pop == 1) {
            this.zonePlop(427);
            this.adjustROG(-8);
        }
    }

    private void doIndustrialOut(int pop, int value) {
        if (pop > 1) {
            this.indPlop(pop - 2, value);
            this.adjustROG(-8);
        } else if (pop == 1) {
            this.zonePlop(616);
            this.adjustROG(-8);
        }
    }

    private void doResidentialOut(int pop, int value) {
        assert (value >= 0 && value < 4);
        char[] Brdr = new char[]{'\u0000', '\u0003', '\u0006', '\u0001', '\u0004', '\u0007', '\u0002', '\u0005', '\b'};
        if (pop == 0) {
            return;
        }
        if (pop > 16) {
            this.residentialPlop((pop - 24) / 8, value);
            this.adjustROG(-8);
            return;
        }
        if (pop == 16) {
            boolean pwr = this.city.isTilePowered(this.xpos, this.ypos);
            this.city.setTile(this.xpos, this.ypos, '\u00f4');
            this.city.setTilePower(this.xpos, this.ypos, pwr);
            for (int x = this.xpos - 1; x <= this.xpos + 1; ++x) {
                for (int y = this.ypos - 1; y <= this.ypos + 1; ++y) {
                    if (!this.city.testBounds(x, y) || x == this.xpos && y == this.ypos) continue;
                    int houseNumber = value * 3 + this.PRNG.nextInt(3);
                    this.city.setTile(x, y, (char)(249 + houseNumber));
                }
            }
            this.adjustROG(-8);
            return;
        }
        if (pop < 16) {
            this.adjustROG(-1);
            int z = 0;
            for (int x = this.xpos - 1; x <= this.xpos + 1; ++x) {
                for (int y = this.ypos - 1; y <= this.ypos + 1; ++y) {
                    int loc;
                    if (this.city.testBounds(x, y) && (loc = this.city.map[y][x] & 0x3FF) >= 249 && loc <= 260) {
                        this.city.setTile(x, y, (char)(Brdr[z] + 244 - 4));
                        return;
                    }
                    ++z;
                }
            }
        }
    }

    int evalCommercial(int traf) {
        if (traf < 0) {
            return -3000;
        }
        return this.city.comRate[this.ypos / 8][this.xpos / 8];
    }

    int evalIndustrial(int traf) {
        if (traf < 0) {
            return -1000;
        }
        return 0;
    }

    int evalResidential(int traf) {
        if (traf < 0) {
            return -3000;
        }
        int value = this.city.getLandValue(this.xpos, this.ypos);
        value = (value -= this.city.pollutionMem[this.ypos / 2][this.xpos / 2]) < 0 ? 0 : (value *= 32);
        if (value > 6000) {
            value = 6000;
        }
        return value - 3000;
    }

    int getCRValue() {
        int lval = this.city.getLandValue(this.xpos, this.ypos);
        if ((lval -= this.city.pollutionMem[this.ypos / 2][this.xpos / 2]) < 30) {
            return 0;
        }
        if (lval < 80) {
            return 1;
        }
        if (lval < 150) {
            return 2;
        }
        return 3;
    }

    void adjustROG(int amount) {
        int[] nArray = this.city.rateOGMem[this.ypos / 8];
        int n = this.xpos / 8;
        nArray[n] = nArray[n] + 4 * amount;
    }

    void drawStadium(int zoneCenter) {
        int zoneBase = zoneCenter - 1 - 4;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.city.setTile(this.xpos - 1 + x, this.ypos - 1 + y, (char)zoneBase);
                ++zoneBase;
            }
        }
        this.city.setTilePower(this.xpos, this.ypos, true);
    }

    int makeTraffic(TrafficGen.ZoneType zoneType) {
        this.traffic.mapX = this.xpos;
        this.traffic.mapY = this.ypos;
        this.traffic.sourceZone = zoneType;
        return this.traffic.makeTraffic();
    }

    public static enum B {
        RESIDENTIAL,
        HOSPITAL_CHURCH,
        COMMERCIAL,
        INDUSTRIAL,
        COAL,
        NUCLEAR,
        FIRESTATION,
        POLICESTATION,
        STADIUM_EMPTY,
        STADIUM_FULL,
        AIRPORT,
        SEAPORT;

    }
}

