/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Connection;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.NetServerThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NetConnectionsWindow
extends JDialog {
    private static final long serialVersionUID = 700L;
    protected MainWindow mainWindow;
    private JTextField ipText;
    private JTextField portText;
    private JPanel connectionsPanel;
    private JScrollPane connectionsScroll;

    public String getPortText() {
        return this.portText.getText();
    }

    public String getIPText() {
        return this.ipText.getText();
    }

    public NetConnectionsWindow(MainWindow parent) {
        super(parent);
        this.mainWindow = parent;
        this.setTitle(Messages.getString("T_NETWORK_CONNECTIONS"));
        this.setDefaultCloseOperation(2);
        this.setComponents();
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private void setComponents() {
        JPanel newConnectionPanel = new JPanel();
        newConnectionPanel.add(new JLabel(Messages.getString("T_IP")));
        this.ipText = new JTextField(15);
        newConnectionPanel.add(this.ipText);
        newConnectionPanel.add(new JLabel(Messages.getString("T_PORT")));
        this.portText = new JTextField(5);
        newConnectionPanel.add(this.portText);
        JButton newConnectionButton = new JButton(Messages.getString("T_NEW_CONNECTION"));
        newConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    int port = Integer.parseInt(NetConnectionsWindow.this.getPortText());
                    if (port > 0) {
                        try {
                            InetAddress address = InetAddress.getByName(NetConnectionsWindow.this.getIPText());
                            NetServerThread netServer = NetConnectionsWindow.this.mainWindow.startServer();
                            Connection connection = netServer.newConnection(address, port);
                            if (connection != null) {
                                connection.connect();
                            }
                            NetConnectionsWindow.this.refreshConnectionsPanel();
                        }
                        catch (UnknownHostException e) {
                            JOptionPane.showMessageDialog(null, Messages.getString("T_CONNECTION_FAILED"), String.valueOf(Messages.getString("T_CANT_STABLISH_CONNECTION")) + e.getLocalizedMessage(), 0);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, Messages.getString("T_CONNECTION_FAILED"), Messages.getString("T_PORT_MUST_BE_A_NUMBER"), 0);
                }
            }
        });
        newConnectionPanel.add(newConnectionButton);
        this.connectionsPanel = new JPanel();
        this.connectionsScroll = new JScrollPane(this.connectionsPanel);
        this.connectionsScroll.setPreferredSize(new Dimension(440, 300));
        this.refreshConnectionsPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)newConnectionPanel, "North");
        this.getContentPane().add((Component)this.connectionsScroll, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConnectionsPanel() {
        this.connectionsPanel.removeAll();
        NetServerThread netServer = this.mainWindow.getNetServer();
        if (netServer != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(2, 4, 2, 4);
            List<Connection> connections = netServer.getConnections();
            this.connectionsPanel.setLayout(new GridBagLayout());
            List<Connection> list = connections;
            synchronized (list) {
                int i = 0;
                for (Connection c : connections) {
                    constraints.gridx = 0;
                    constraints.gridy = i++;
                    this.connectionsPanel.add((Component)new JLabel(c.getRemoteAddress().toString()), constraints);
                    constraints.gridx = 1;
                    this.connectionsPanel.add((Component)new JLabel(Integer.toString(c.getRemotePort())), constraints);
                    JButton button = new JButton(Messages.getString("T_DISCONNECT"));
                    button.addActionListener(new disconnectAction(c));
                    constraints.gridx = 2;
                    this.connectionsPanel.add((Component)button, constraints);
                }
            }
        }
        this.validate();
        this.repaint();
    }

    private class disconnectAction
    implements ActionListener {
        private Connection connection;

        public disconnectAction(Connection c) {
            this.connection = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.connection.send(5);
            this.connection.setState(50);
            NetConnectionsWindow.this.refreshConnectionsPanel();
        }
    }
}

