/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.BareBonesBrowserLaunch;
import biogenesis.BioFileFilter;
import biogenesis.BioXMLParser;
import biogenesis.CheckVersionThread;
import biogenesis.GeneticCode;
import biogenesis.InfoToolbar;
import biogenesis.LabWindow;
import biogenesis.Messages;
import biogenesis.NetConfigWindow;
import biogenesis.NetConnectionsWindow;
import biogenesis.NetServerThread;
import biogenesis.Organism;
import biogenesis.ParamDialog;
import biogenesis.StatisticsWindow;
import biogenesis.StdAction;
import biogenesis.Utils;
import biogenesis.VisibleWorld;
import biogenesis.World;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 700L;
    protected VisibleWorld _visibleWorld;
    protected World _world;
    protected boolean _isProcessActive = false;
    protected transient Timer _timer;
    protected transient TimerTask updateTask = null;
    protected JFileChooser worldChooser = new JFileChooser();
    protected JFileChooser geneticCodeChooser = new JFileChooser();
    protected File _gameFile = null;
    protected JScrollPane scrollPane;
    protected StdAction newGameAction;
    protected StartStopAction startStopAction;
    protected StdAction saveGameAction;
    protected StdAction increaseCO2Action;
    protected StdAction decreaseCO2Action;
    protected StdAction manageConnectionsAction;
    protected StdAction abortTrackingAction;
    protected StdAction openGameAction;
    protected StdAction saveGameAsAction;
    protected StdAction quitAction;
    protected StdAction statisticsAction;
    protected StdAction labAction;
    protected StdAction killAllAction;
    protected StdAction disperseAllAction;
    protected StdAction parametersAction;
    protected StdAction aboutAction;
    protected StdAction manualAction;
    protected StdAction checkLastVersionAction;
    protected StdAction netConfigAction;
    protected JMenuItem _menuStartStopGame;
    protected JMenu _menuGame;
    protected JMenu _menuWorld;
    protected JMenu _menuHelp;
    protected JMenu _menuNet;
    protected NumberFormat _nf;
    protected JLabel _statusLabel;
    protected JToolBar toolBar = new JToolBar(Messages.getString("T_PROGRAM_NAME"));
    protected InfoToolbar infoToolbar;
    private String statusMessage = "";
    private StringBuilder statusLabelText = new StringBuilder(100);
    protected Organism _trackedOrganism = null;
    protected transient NetServerThread serverThread = null;
    protected StatisticsWindow _statisticsWindow = null;
    protected long nFrames = 0L;
    private ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/bullet.jpg"));
    final transient Runnable lifeProcess = new Runnable(){

        @Override
        public void run() {
            if (MainWindow.this._isProcessActive) {
                MainWindow.this._world.time();
                ++MainWindow.this.nFrames;
                if (MainWindow.this.nFrames % 20L == 0L) {
                    MainWindow.this.updateStatusLabel();
                }
                MainWindow.this._world.setPaintingRegion();
                if (MainWindow.this._trackedOrganism != null) {
                    if (!MainWindow.this._trackedOrganism.isAlive()) {
                        MainWindow.this._trackedOrganism = null;
                        MainWindow.this.abortTrackingAction.setEnabled(false);
                    } else {
                        JScrollBar bar = MainWindow.this.scrollPane.getHorizontalScrollBar();
                        bar.setValue(Utils.between(MainWindow.this._trackedOrganism._centerX - MainWindow.this.scrollPane.getWidth() / 2, bar.getValue() - 2 * (int)Utils.MAX_VEL, bar.getValue() + 2 * (int)Utils.MAX_VEL));
                        bar = MainWindow.this.scrollPane.getVerticalScrollBar();
                        bar.setValue(Utils.between(MainWindow.this._trackedOrganism._centerY - MainWindow.this.scrollPane.getHeight() / 2, bar.getValue() - 2 * (int)Utils.MAX_VEL, bar.getValue() + 2 * (int)Utils.MAX_VEL));
                    }
                }
            }
        }
    };
    protected int currentDelay = Utils.DELAY;
    protected int failedTime = 0;
    protected long lastPaintTime;

    public JFileChooser getWorldChooser() {
        return this.worldChooser;
    }

    public JFileChooser getGeneticCodeChooser() {
        return this.geneticCodeChooser;
    }

    public void setStatusMessage(String str) {
        this.statusMessage = str;
        this.updateStatusLabel();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public World getWorld() {
        return this._world;
    }

    public VisibleWorld getVisibleWorld() {
        return this._visibleWorld;
    }

    public boolean isProcessActive() {
        return this._isProcessActive;
    }

    public InfoToolbar getInfoPanel() {
        return this.infoToolbar;
    }

    public MainWindow() {
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.setControls();
        this.configureApp();
        this._world = new World(this._visibleWorld);
        this.startApp();
        this._world.genesis();
        this.scrollPane.setViewportView(this._visibleWorld);
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("java -jar biogenesis.jar [random seed]");
        } else if (args.length == 1) {
            try {
                long seed = Long.parseLong(args[0]);
                Utils.random.setSeed(seed);
            }
            catch (NumberFormatException e) {
                System.err.println("java -jar biogenesis.jar [random seed]");
            }
        }
        Utils.readPreferences();
        new MainWindow();
    }

    private void createActions() {
        this.newGameAction = new NewGameAction("T_NEW", "images/menu_new.png", "T_NEW_WORLD");
        this.startStopAction = new StartStopAction("T_RESUME", "T_PAUSE", "images/menu_start.png", "images/menu_stop.png", "T_RESUME_PROCESS", "T_PAUSE_PROCESS");
        this.saveGameAction = new SaveGameAction("T_SAVE", "images/menu_save.png", "T_SAVE_WORLD");
        this.increaseCO2Action = new IncreaseCO2Action("T_INCREASE_CO2", "images/menu_increase_co2.png", "T_INCREASE_CO2");
        this.decreaseCO2Action = new DecreaseCO2Action("T_DECREASE_CO2", "images/menu_decrease_co2.png", "T_DECREASE_CO2");
        this.manageConnectionsAction = new ManageConnectionsAction("T_MANAGE_CONNECTIONS", "images/menu_manage_connections.png", "T_MANAGE_CONNECTIONS");
        this.abortTrackingAction = new AbortTrackingAction("T_ABORT_TRACKING", "images/menu_stop_tracking.png", "T_ABORT_TRACKING");
        this.openGameAction = new OpenGameAction("T_OPEN", null, "T_OPEN_WORLD");
        this.saveGameAsAction = new SaveGameAsAction("T_SAVE_AS", null, "T_SAVE_WORLD_AS");
        this.quitAction = new QuitAction("T_QUIT", null, "T_QUIT_PROGRAM");
        this.statisticsAction = new StatisticsAction("T_STATISTICS", null, "T_WORLD_STATISTICS");
        this.labAction = new LabAction("T_GENETIC_LABORATORY", null, "T_GENETIC_LABORATORY");
        this.killAllAction = new KillAllAction("T_KILL_ALL", null, "T_KILL_ALL_ORGANISMS");
        this.disperseAllAction = new DisperseAllAction("T_DISPERSE_ALL", null, "T_DISPERSE_ALL_DEAD_ORGANISMS");
        this.parametersAction = new ParametersAction("T_PARAMETERS", null, "T_EDIT_PARAMETERS");
        this.aboutAction = new AboutAction("T_ABOUT", null, "T_ABOUT");
        this.manualAction = new ManualAction("T_USER_MANUAL", null, "T_USER_MANUAL");
        this.checkLastVersionAction = new CheckLastVersionAction("T_CHECK_LAST_VERSION", null, "T_CHECK_LAST_VERSION");
        this.netConfigAction = new NetConfigAction("T_CONFIGURE_NETWORK", null, "T_CONFIGURE_NETWORK");
    }

    public void createToolBar() {
        this.toolBar.removeAll();
        this.toolBar.add(this.newGameAction);
        this.toolBar.add(this.startStopAction);
        this.toolBar.add(this.saveGameAction);
        this.toolBar.add(this.increaseCO2Action);
        this.toolBar.add(this.decreaseCO2Action);
        this.toolBar.add(this.manageConnectionsAction);
        this.toolBar.add(this.abortTrackingAction);
        this.abortTrackingAction.setEnabled(this._trackedOrganism != null);
        this.toolBar.invalidate();
        this.toolBar.repaint();
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        this._menuGame = new JMenu(Messages.getString("T_GAME"));
        this._menuGame.setMnemonic(Messages.getMnemonic("T_GAME"));
        menuBar.add(this._menuGame);
        JMenuItem menuItem = new JMenuItem(this.newGameAction);
        menuItem.setIcon(null);
        this._menuGame.add(menuItem);
        this._menuStartStopGame = new JMenuItem(this.startStopAction);
        this._menuStartStopGame.setIcon(null);
        this._menuGame.add(this._menuStartStopGame);
        this._menuGame.add(new JMenuItem(this.openGameAction));
        menuItem = new JMenuItem(this.saveGameAction);
        menuItem.setIcon(null);
        this._menuGame.add(menuItem);
        this._menuGame.add(new JMenuItem(this.saveGameAsAction));
        this._menuGame.add(new JMenuItem(this.quitAction));
        this._menuWorld = new JMenu(Messages.getString("T_WORLD"));
        this._menuWorld.setMnemonic(Messages.getMnemonic("T_WORLD"));
        menuBar.add(this._menuWorld);
        this._menuWorld.add(new JMenuItem(this.statisticsAction));
        this._menuWorld.add(new JMenuItem(this.labAction));
        menuItem = new JMenuItem(this.increaseCO2Action);
        menuItem.setIcon(null);
        this._menuWorld.add(menuItem);
        menuItem = new JMenuItem(this.decreaseCO2Action);
        menuItem.setIcon(null);
        this._menuWorld.add(menuItem);
        this._menuWorld.add(new JMenuItem(this.killAllAction));
        this._menuWorld.add(new JMenuItem(this.disperseAllAction));
        this._menuWorld.add(new JMenuItem(this.parametersAction));
        this._menuNet = new JMenu(Messages.getString("T_NETWORK"));
        this._menuNet.setMnemonic(Messages.getMnemonic("T_NETWORK"));
        menuBar.add(this._menuNet);
        this._menuNet.add(new JMenuItem(this.netConfigAction));
        menuItem = new JMenuItem(this.manageConnectionsAction);
        menuItem.setIcon(null);
        this._menuNet.add(menuItem);
        this._menuHelp = new JMenu(Messages.getString("T_HELP"));
        this._menuHelp.setMnemonic(Messages.getMnemonic("T_HELP"));
        menuBar.add(this._menuHelp);
        this._menuHelp.add(new JMenuItem(this.manualAction));
        this._menuHelp.add(new JMenuItem(this.checkLastVersionAction));
        this._menuHelp.add(new JMenuItem(this.aboutAction));
        SecurityManager sec = System.getSecurityManager();
        try {
            if (sec != null) {
                sec.checkPropertyAccess("user.home");
            }
        }
        catch (SecurityException ex) {
            this.openGameAction.setEnabled(false);
            this.saveGameAsAction.setEnabled(false);
            this.saveGameAction.setEnabled(false);
            this.manualAction.setEnabled(false);
            this.netConfigAction.setEnabled(false);
            this.manageConnectionsAction.setEnabled(false);
        }
        this.setJMenuBar(menuBar);
    }

    protected void checkLastVersion() {
        CheckVersionThread thread = new CheckVersionThread(this);
        thread.start();
    }

    protected void netConfig() {
        new NetConfigWindow(this);
    }

    public void setAcceptConnections(boolean newAcceptConnections) {
        if (newAcceptConnections != Utils.ACCEPT_CONNECTIONS) {
            Utils.ACCEPT_CONNECTIONS = newAcceptConnections;
            if (newAcceptConnections) {
                this.startServer();
            } else if (this.serverThread.getConnections().isEmpty()) {
                this.stopServer();
            }
        }
    }

    public boolean isAcceptingConnections() {
        return Utils.ACCEPT_CONNECTIONS;
    }

    public NetServerThread getNetServer() {
        return this.serverThread;
    }

    public NetServerThread startServer() {
        if (this.serverThread == null || !this.serverThread.isActive()) {
            this.serverThread = new NetServerThread(this);
            this.serverThread.start();
        }
        return this.serverThread;
    }

    public void stopServer() {
        if (this.serverThread != null) {
            this.serverThread.closeServer();
        }
    }

    public void quit() {
        int save = JOptionPane.showConfirmDialog(this, Messages.getString("T_SAVE_BEFORE_QUIT"), Messages.getString("T_SAVE_WORLD"), 1, 3);
        if (save != 2) {
            if (save == 0) {
                if (this._gameFile != null) {
                    this.saveObject(this._world, this._gameFile);
                } else if (this.saveGameAs() == null) {
                    return;
                }
            }
            Utils.quitProgram(this);
            if (this.serverThread != null) {
                this.serverThread.closeServer();
            }
            try {
                System.exit(0);
            }
            catch (SecurityException ex) {
                this.dispose();
            }
        }
    }

    protected void paramDialog() {
        new ParamDialog(this);
    }

    public void setTrackedOrganism(Organism org) {
        this._trackedOrganism = org;
        this.abortTrackingAction.setEnabled(this._trackedOrganism != null);
    }

    protected void netConnectionsWindow() {
        new NetConnectionsWindow(this);
    }

    public void pauseGame() {
        this._isProcessActive = false;
        this.startStopAction.toogle();
        this._menuStartStopGame.setIcon(null);
        this.setStatusMessage(Messages.getString("T_GAME_PAUSED"));
    }

    public void playGame() {
        this._isProcessActive = true;
        this.startStopAction.toogle();
        this._menuStartStopGame.setIcon(null);
        this.setStatusMessage(Messages.getString("T_GAME_RESUMED"));
    }

    protected File saveGameAs() {
        File savedFile = this.saveObjectAs(this._world);
        if (savedFile != null) {
            this._gameFile = savedFile;
        }
        return savedFile;
    }

    protected void about() {
        String aboutString = String.valueOf(Messages.getString("T_PROGRAM_NAME")) + "http://biogenesis.sourceforge.net/" + Messages.getString("T_VERSION") + Messages.getString("T_COPYRIGHT") + "joanq@users.sourceforge.net\n" + Messages.getString("T_ARTWORK_BY") + " Ananda Daydream, Florian Haag (http://toolbaricons.sourceforge.net/)";
        JOptionPane.showMessageDialog(this, aboutString, Messages.getString("T_ABOUT"), 1, this.imageIcon);
    }

    private void setControls() {
        this.setIconImage(this.imageIcon.getImage());
        JPanel centralPanel = new JPanel();
        centralPanel.setLayout(new BorderLayout());
        this._visibleWorld = new VisibleWorld(this);
        this.scrollPane = new JScrollPane(this._visibleWorld);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.setLocation(Utils.WINDOW_X, Utils.WINDOW_Y);
        this.setExtendedState(Utils.WINDOW_STATE);
        this.getContentPane().setLayout(new BorderLayout());
        this.infoToolbar = new InfoToolbar(null, this);
        centralPanel.add((Component)this.scrollPane, "Center");
        centralPanel.add((Component)this.infoToolbar, "South");
        this.getContentPane().add((Component)centralPanel, "Center");
        this._statusLabel = new JLabel(" ");
        this._statusLabel.setBorder(new EtchedBorder());
        this._nf = NumberFormat.getInstance();
        this._nf.setMaximumFractionDigits(1);
        this.getContentPane().add((Component)this._statusLabel, "South");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.worldChooser.setFileFilter(new BioFileFilter("bgw"));
        this.geneticCodeChooser.setFileFilter(new BioFileFilter("bgg"));
    }

    public File saveObjectAs(Object obj) {
        File resultFile = null;
        boolean processState = this._isProcessActive;
        this._isProcessActive = false;
        try {
            JFileChooser chooser = obj instanceof GeneticCode ? this.getGeneticCodeChooser() : this.getWorldChooser();
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                String ext;
                int canWrite = 0;
                File f = chooser.getSelectedFile();
                String filename = f.getName();
                String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                if (ext.equals("")) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + "." + ((BioFileFilter)chooser.getFileFilter()).getValidExtension());
                    chooser.setSelectedFile(f);
                }
                if (f.exists()) {
                    canWrite = JOptionPane.showConfirmDialog(null, Messages.getString("T_CONFIRM_FILE_OVERRIDE"), Messages.getString("T_FILE_EXISTS"), 0, 2);
                }
                if (canWrite == 0) {
                    if (obj instanceof GeneticCode) {
                        try {
                            BioXMLParser.writeGeneticCode(new PrintStream(f), (GeneticCode)obj);
                            resultFile = f;
                        }
                        catch (FileNotFoundException ex) {
                            System.err.println(ex.getLocalizedMessage());
                        }
                    } else if (this.saveObject(obj, f)) {
                        resultFile = f;
                    }
                }
            }
        }
        catch (SecurityException ex) {
            System.err.println(ex.getMessage());
            JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
        }
        this._isProcessActive = processState;
        return resultFile;
    }

    public boolean saveObject(Object obj, File f) {
        try {
            FileOutputStream fileStream = new FileOutputStream(f);
            ObjectOutputStream outputStream = new ObjectOutputStream(fileStream);
            outputStream.writeObject(obj);
            outputStream.close();
            this.setStatusMessage(Messages.getString("T_WRITING_COMPLETED"));
            return true;
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (SecurityException ex) {
            System.err.println(ex.getMessage());
            JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
        }
        return false;
    }

    public void configureApp() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.quit();
            }
        });
        this.setTitle(Messages.getString("T_BIOGENESIS"));
        UIManager.put("OptionPane.yesButtonText", Messages.getString("T_YES"));
        UIManager.put("OptionPane.noButtonText", Messages.getString("T_NO"));
        UIManager.put("OptionPane.cancelButtonText", Messages.getString("T_CANCEL"));
    }

    public void updateStatusLabel() {
        this.statusLabelText.setLength(0);
        this.statusLabelText.append(Messages.getString("T_FPS"));
        this.statusLabelText.append(this.getFPS());
        this.statusLabelText.append("     ");
        this.statusLabelText.append(Messages.getString("T_TIME"));
        this.statusLabelText.append(this._world.getTime());
        this.statusLabelText.append("     ");
        this.statusLabelText.append(Messages.getString("T_CURRENT_POPULATION"));
        this.statusLabelText.append(this._world.getPopulation());
        this.statusLabelText.append("     ");
        this.statusLabelText.append(Messages.getString("T_O2"));
        this.statusLabelText.append(this._nf.format(this._world.getO2()));
        this.statusLabelText.append("     ");
        this.statusLabelText.append(Messages.getString("T_CO2"));
        this.statusLabelText.append(this._nf.format(this._world.getCO2()));
        this.statusLabelText.append("     ");
        this.statusLabelText.append(this.getStatusMessage());
        this._statusLabel.setText(this.statusLabelText.toString());
    }

    public int getFPS() {
        return 1000 / this.currentDelay;
    }

    public void startApp() {
        this.setResizable(true);
        this.setSize(new Dimension(Utils.WINDOW_WIDTH, Utils.WINDOW_HEIGHT));
        this.setVisible(true);
        this._timer = new Timer();
        this.startLifeProcess(Utils.DELAY);
        if (this.isAcceptingConnections()) {
            this.startServer();
        }
    }

    public void startLifeProcess(int delay) {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    EventQueue.invokeAndWait(MainWindow.this.lifeProcess);
                    long actualTime = System.currentTimeMillis();
                    if ((double)(actualTime - MainWindow.this.lastPaintTime) > (double)MainWindow.this.currentDelay * 1.5 || MainWindow.this.currentDelay < Utils.DELAY) {
                        MainWindow.this.failedTime = Math.max(MainWindow.this.failedTime + 1, 0);
                        if (MainWindow.this.failedTime >= 2) {
                            MainWindow.this.failedTime = 0;
                            MainWindow.this.currentDelay = (int)((double)MainWindow.this.currentDelay * 1.5);
                            MainWindow.this.startLifeProcess(MainWindow.this.currentDelay);
                        }
                    } else if ((double)(actualTime - MainWindow.this.lastPaintTime) < (double)MainWindow.this.currentDelay * 1.2 && MainWindow.this.currentDelay > Utils.DELAY) {
                        MainWindow.this.failedTime = Math.min(MainWindow.this.failedTime - 1, 0);
                        if (MainWindow.this.failedTime <= -10) {
                            MainWindow.this.currentDelay = Math.max(Utils.DELAY, MainWindow.this.currentDelay - 1);
                            MainWindow.this.startLifeProcess(MainWindow.this.currentDelay);
                        }
                    } else {
                        MainWindow.this.failedTime = 0;
                    }
                    if (MainWindow.this.currentDelay > 1000) {
                        MainWindow.this.pauseGame();
                    }
                    MainWindow.this.lastPaintTime = actualTime;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        this._timer.schedule(this.updateTask, delay, (long)delay);
    }

    public void changeLocale() {
        UIManager.put("OptionPane.yesButtonText", Messages.getString("T_YES"));
        UIManager.put("OptionPane.noButtonText", Messages.getString("T_NO"));
        UIManager.put("OptionPane.cancelButtonText", Messages.getString("T_CANCEL"));
        this._menuGame.setText(Messages.getString("T_GAME"));
        this._menuGame.setMnemonic(Messages.getMnemonic("T_GAME"));
        this.newGameAction.changeLocale();
        this.startStopAction.changeLocale();
        this.openGameAction.changeLocale();
        this.saveGameAction.changeLocale();
        this.saveGameAsAction.changeLocale();
        this.quitAction.changeLocale();
        this._menuWorld.setText(Messages.getString("T_WORLD"));
        this._menuWorld.setMnemonic(Messages.getMnemonic("T_WORLD"));
        this.statisticsAction.changeLocale();
        this.increaseCO2Action.changeLocale();
        this.decreaseCO2Action.changeLocale();
        this.parametersAction.changeLocale();
        this.labAction.changeLocale();
        this.killAllAction.changeLocale();
        this.disperseAllAction.changeLocale();
        this._menuHelp.setText(Messages.getString("T_HELP"));
        this._menuHelp.setMnemonic(Messages.getMnemonic("T_HELP"));
        this.manualAction.changeLocale();
        this.checkLastVersionAction.changeLocale();
        this.aboutAction.changeLocale();
        this._menuNet.setText(Messages.getString("T_NETWORK"));
        this._menuNet.setMnemonic(Messages.getMnemonic("T_NETWORK"));
        this.netConfigAction.changeLocale();
        this.manageConnectionsAction.changeLocale();
        this.setTitle(Messages.getString("T_BIOGENESIS"));
        this.createMenu();
        this._visibleWorld.changeLocale();
        this.infoToolbar.changeLocale();
    }

    class AbortTrackingAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public AbortTrackingAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.setTrackedOrganism(null);
        }
    }

    class AboutAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public AboutAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.about();
        }
    }

    class CheckLastVersionAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public CheckLastVersionAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.checkLastVersion();
        }
    }

    class DecreaseCO2Action
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public DecreaseCO2Action(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this._world.decreaseCO2(500.0);
        }
    }

    class DisperseAllAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public DisperseAllAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this._world.disperseAll();
        }
    }

    class IncreaseCO2Action
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public IncreaseCO2Action(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this._world.addCO2(500.0);
        }
    }

    class KillAllAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public KillAllAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this._world.killAll();
        }
    }

    class LabAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public LabAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new LabWindow(MainWindow.this);
        }
    }

    class ManageConnectionsAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ManageConnectionsAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.netConnectionsWindow();
        }
    }

    class ManualAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ManualAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BareBonesBrowserLaunch.openURL("http://biogenesis.sourceforge.net/manual.php." + Messages.getLanguage());
        }
    }

    class NetConfigAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public NetConfigAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.netConfig();
        }
    }

    class NewGameAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public NewGameAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this._trackedOrganism = null;
            MainWindow.this._world.genesis();
            MainWindow.this.scrollPane.setViewportView(MainWindow.this._visibleWorld);
            MainWindow.this._isProcessActive = true;
            MainWindow.this.startStopAction.setActive(true);
            MainWindow.this._menuStartStopGame.setIcon(null);
            MainWindow.this.setStatusMessage(Messages.getString("T_NEW_WORLD_CREATED"));
        }
    }

    class OpenGameAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public OpenGameAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean processState;
            block7: {
                processState = MainWindow.this._isProcessActive;
                MainWindow.this._isProcessActive = false;
                try {
                    int returnVal = MainWindow.this.getWorldChooser().showOpenDialog(null);
                    if (returnVal != 0) break block7;
                    if (MainWindow.this._statisticsWindow != null) {
                        MainWindow.this._statisticsWindow.dispose();
                        MainWindow.this._statisticsWindow = null;
                    }
                    try {
                        File f = MainWindow.this.getWorldChooser().getSelectedFile();
                        FileInputStream fileStream = new FileInputStream(f);
                        ObjectInputStream inputStream = new ObjectInputStream(fileStream);
                        MainWindow.this._world = (World)inputStream.readObject();
                        inputStream.close();
                        MainWindow.this._gameFile = f;
                        MainWindow.this._trackedOrganism = null;
                        processState = true;
                        MainWindow.this.setStatusMessage(Messages.getString("T_WORLD_LOADED_SUCCESSFULLY"));
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("T_CANT_READ_FILE"), Messages.getString("T_READ_ERROR"), 0);
                    }
                    catch (ClassNotFoundException ex) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("T_WRONG_FILE_TYPE"), Messages.getString("T_READ_ERROR"), 0);
                    }
                    catch (ClassCastException ex) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("T_WRONG_FILE_VERSION"), Messages.getString("T_READ_ERROR"), 0);
                    }
                    MainWindow.this._world.init(MainWindow.this._visibleWorld);
                    MainWindow.this.scrollPane.setViewportView(MainWindow.this._visibleWorld);
                    MainWindow.this._visibleWorld.repaint();
                }
                catch (SecurityException ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
                }
            }
            MainWindow.this._isProcessActive = processState;
        }
    }

    class ParametersAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ParametersAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.paramDialog();
        }
    }

    class QuitAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public QuitAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.quit();
        }
    }

    class SaveGameAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public SaveGameAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(Messages.getString("T_SAVE_ACCELERATOR")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this._gameFile != null) {
                MainWindow.this.saveObject(MainWindow.this._world, MainWindow.this._gameFile);
            } else {
                MainWindow.this.saveGameAs();
            }
        }

        @Override
        public void changeLocale() {
            super.changeLocale();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(Messages.getString("T_SAVE_ACCELERATOR")));
        }
    }

    class SaveGameAsAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public SaveGameAsAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.saveGameAs();
        }
    }

    class StartStopAction
    extends StdAction {
        private static final long serialVersionUID = 1L;
        protected String name2;
        protected String description2;
        protected Integer mnemonic2;
        protected ImageIcon icon2;
        protected String name2_key;
        protected String desc2_key;
        protected boolean active;

        public StartStopAction(String text1, String text2, String icon_path1, String icon_path2, String desc1, String desc2) {
            super(text1, icon_path1, desc1);
            this.name2 = Messages.getString(text2);
            this.description2 = Messages.getString(desc2);
            this.icon2 = this.createIcon(icon_path2);
            this.mnemonic2 = Messages.getMnemonic(text2);
            this.name2_key = text2;
            this.desc2_key = desc2;
            this.active = false;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(Messages.getString("T_PAUSE_ACCELERATOR")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this._isProcessActive) {
                MainWindow.this.pauseGame();
            } else {
                MainWindow.this.playGame();
            }
        }

        public void toogle() {
            String aux = (String)this.getValue("Name");
            this.putValue("Name", this.name2);
            this.name2 = aux;
            aux = (String)this.getValue("ShortDescription");
            this.putValue("ShortDescription", this.description2);
            this.description2 = aux;
            ImageIcon auxicon = (ImageIcon)this.getValue("SmallIcon");
            this.putValue("SmallIcon", this.icon2);
            this.icon2 = auxicon;
            Integer auxmnemonic = (Integer)this.getValue("MnemonicKey");
            this.putValue("MnemonicKey", this.mnemonic2);
            this.mnemonic2 = auxmnemonic;
            this.active = !this.active;
        }

        @Override
        public void changeLocale() {
            super.changeLocale();
            this.name2 = Messages.getString(this.name2_key);
            this.description2 = Messages.getString(this.desc2_key);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(Messages.getString("T_PAUSE_ACCELERATOR")));
        }

        public void setActive(boolean newState) {
            if (newState != this.active) {
                this.toogle();
                this.active = newState;
            }
        }

        public boolean isActive() {
            return this.active;
        }
    }

    class StatisticsAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public StatisticsAction(String text, String icon_path, String desc) {
            super(text, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this._statisticsWindow != null) {
                MainWindow.this._statisticsWindow.dispose();
            }
            MainWindow.this._statisticsWindow = MainWindow.this._world.createStatisticsWindow();
        }
    }
}

