/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Gene;
import biogenesis.Utils;
import biogenesis.Vector2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.List;

public class GeneticCode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 700L;
    static final int MAX_SEGMENTS = 64;
    static final int MIN_SEGMENTS = 4;
    protected Gene[] _genes;
    protected int _symmetry;
    protected int _mirror;
    protected boolean _disperseChildren;
    protected int _reproduceEnergy;
    protected int _max_age;

    public int getSymmetry() {
        return this._symmetry;
    }

    public int getMirror() {
        return this._mirror;
    }

    public boolean getDisperseChildren() {
        return this._disperseChildren;
    }

    public int getReproduceEnergy() {
        return this._reproduceEnergy;
    }

    public int getMaxAge() {
        return this._max_age;
    }

    public Gene getGene(int i) {
        return this._genes[i];
    }

    public int getNGenes() {
        return this._genes.length;
    }

    private void randomMirror() {
        this._mirror = Utils.random.nextInt(2);
    }

    private void randomSymmetry() {
        this._symmetry = Utils.random.nextInt(8) + 1;
    }

    private void randomGenes() {
        int nSegments = 4 + Utils.random.nextInt(61);
        if (nSegments % this._symmetry != 0) {
            nSegments += this._symmetry - nSegments % this._symmetry;
        }
        int nGenes = nSegments / this._symmetry;
        this._genes = new Gene[nGenes];
        int i = 0;
        while (i < nGenes) {
            this._genes[i] = new Gene();
            this._genes[i].randomize();
            ++i;
        }
    }

    private void randomDisperseChildren() {
        this._disperseChildren = Utils.random.nextBoolean();
    }

    private void calculateReproduceEnergy() {
        this._reproduceEnergy = 40 + 3 * this._genes.length * this._symmetry;
    }

    public GeneticCode() {
        this.randomMirror();
        this.randomSymmetry();
        this.randomGenes();
        this.randomDisperseChildren();
        this.calculateReproduceEnergy();
        this._max_age = Utils.MAX_AGE;
    }

    public GeneticCode(List<Gene> genes, int symmetry, int mirror, boolean disperseChildren) {
        int nGenes = genes.size();
        this._genes = new Gene[nGenes];
        genes.toArray(this._genes);
        this._max_age = Utils.MAX_AGE;
        this._mirror = mirror;
        this._symmetry = symmetry;
        this._disperseChildren = disperseChildren;
        this.calculateReproduceEnergy();
    }

    public GeneticCode(GeneticCode parentCode) {
        int nGenes;
        int addedGene = -1;
        int removedGene = -1;
        if (Utils.randomMutation()) {
            this.randomMirror();
        } else {
            this._mirror = parentCode.getMirror();
        }
        if (Utils.randomMutation()) {
            if (Utils.random.nextInt(10) < 2) {
                this.randomSymmetry();
            } else {
                this._symmetry = Utils.between(this._symmetry + Utils.randomSign(), 1, 8);
            }
            nGenes = parentCode.getNGenes();
            if (nGenes * this._symmetry > 64) {
                this._symmetry = parentCode.getSymmetry();
            }
        } else {
            this._symmetry = parentCode.getSymmetry();
            if (Utils.randomMutation()) {
                if (Utils.random.nextBoolean()) {
                    if (parentCode.getNGenes() * parentCode.getSymmetry() >= 64) {
                        nGenes = parentCode.getNGenes();
                    } else {
                        nGenes = parentCode.getNGenes() + 1;
                        addedGene = Utils.random.nextInt(nGenes);
                    }
                } else if (parentCode.getNGenes() * parentCode.getSymmetry() <= 4) {
                    nGenes = parentCode.getNGenes();
                } else {
                    nGenes = parentCode.getNGenes() - 1;
                    removedGene = Utils.random.nextInt(parentCode.getNGenes());
                }
            } else {
                nGenes = parentCode.getNGenes();
            }
        }
        this._genes = new Gene[nGenes];
        int i = 0;
        int j = 0;
        while (i < nGenes) {
            if (removedGene == j) {
                --i;
            } else if (addedGene == i) {
                this._genes[i] = new Gene();
                this._genes[i].randomize();
                --j;
            } else {
                boolean randomBack = false;
                boolean randomColor = false;
                boolean randomTheta = false;
                boolean randomLength = false;
                if (Utils.randomMutation()) {
                    randomLength = true;
                }
                if (Utils.randomMutation()) {
                    randomTheta = true;
                }
                if (Utils.randomMutation()) {
                    randomColor = true;
                }
                if (Utils.randomMutation()) {
                    randomBack = true;
                }
                if (randomLength || randomTheta || randomColor || randomBack) {
                    this._genes[i] = new Gene();
                    if (randomLength) {
                        this._genes[i].randomizeLength();
                    } else {
                        this._genes[i].setLength(parentCode.getGene(j).getLength());
                    }
                    if (randomTheta) {
                        this._genes[i].randomizeTheta();
                    } else {
                        this._genes[i].setTheta(parentCode.getGene(j).getTheta());
                    }
                    if (randomColor) {
                        this._genes[i].randomizeColor();
                    } else {
                        this._genes[i].setColor(parentCode.getGene(j).getColor());
                    }
                } else {
                    this._genes[i] = parentCode.getGene(j);
                }
            }
            ++i;
            ++j;
        }
        if (Utils.randomMutation()) {
            this.randomDisperseChildren();
        } else {
            this._disperseChildren = parentCode.getDisperseChildren();
        }
        this.calculateReproduceEnergy();
        this._max_age = Utils.MAX_AGE;
    }

    public Object clone() {
        GeneticCode newCode = null;
        try {
            newCode = (GeneticCode)super.clone();
            newCode._genes = new Gene[this._genes.length];
            int i = 0;
            while (i < this._genes.length) {
                newCode._genes[i] = (Gene)this._genes[i].clone();
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newCode;
    }

    public void draw(Graphics g, int width, int height) {
        int j;
        int[][] x0 = new int[this._symmetry][this._genes.length];
        int[][] y0 = new int[this._symmetry][this._genes.length];
        int[][] x1 = new int[this._symmetry][this._genes.length];
        int[][] y1 = new int[this._symmetry][this._genes.length];
        int maxX = 0;
        int minX = 0;
        int maxY = 0;
        int minY = 0;
        double scale = 1.0;
        Vector2D v = new Vector2D();
        Graphics2D g2 = (Graphics2D)g;
        int i = 0;
        while (i < this._symmetry) {
            j = 0;
            while (j < this._genes.length) {
                v.setModulus(this._genes[j].getLength());
                if (j == 0) {
                    y0[i][j] = 0;
                    x0[i][j] = 0;
                    if (this._mirror == 0 || i % 2 == 0) {
                        v.setTheta(this._genes[j].getTheta() + (double)(i * 2) * Math.PI / (double)this._symmetry);
                    } else {
                        v.setTheta(this._genes[j].getTheta() + (double)((i - 1) * 2) * Math.PI / (double)this._symmetry);
                        v.invertX();
                    }
                } else {
                    x0[i][j] = x1[i][j - 1];
                    y0[i][j] = y1[i][j - 1];
                    if (this._mirror == 0 || i % 2 == 0) {
                        v.addDegree(this._genes[j].getTheta());
                    } else {
                        v.addDegree(-this._genes[j].getTheta());
                    }
                }
                x1[i][j] = (int)Math.round(v.getX() + (double)x0[i][j]);
                y1[i][j] = (int)Math.round(v.getY() + (double)y0[i][j]);
                maxX = Math.max(maxX, Math.max(x0[i][j], x1[i][j]));
                maxY = Math.max(maxY, Math.max(y0[i][j], y1[i][j]));
                minX = Math.min(minX, Math.min(x0[i][j], x1[i][j]));
                minY = Math.min(minY, Math.min(y0[i][j], y1[i][j]));
                ++j;
            }
            ++i;
        }
        g2.translate(width / 2, height / 2);
        if (maxX - minX > width) {
            scale = (double)width / (double)(maxX - minX);
        }
        if (maxY - minY > height) {
            scale = Math.min(scale, (double)height / (double)(maxY - minY));
        }
        g2.scale(scale, scale);
        i = 0;
        while (i < this._symmetry) {
            j = 0;
            while (j < this._genes.length) {
                int[] nArray = x0[i];
                int n = j;
                nArray[n] = nArray[n] + (-minX - maxX) / 2;
                int[] nArray2 = x1[i];
                int n2 = j;
                nArray2[n2] = nArray2[n2] + (-minX - maxX) / 2;
                int[] nArray3 = y0[i];
                int n3 = j;
                nArray3[n3] = nArray3[n3] + (-minY - maxY) / 2;
                int[] nArray4 = y1[i];
                int n4 = j;
                nArray4[n4] = nArray4[n4] + (-minY - maxY) / 2;
                g2.setColor(this._genes[j].getColor());
                g2.drawLine(x0[i][j], y0[i][j], x1[i][j], y1[i][j]);
                ++j;
            }
            ++i;
        }
    }
}

