/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.CloseListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ProgressBar
extends Component
implements AdjustmentListener {
    int min = 1;
    int max = 100;
    int value = 1;
    Dimension size = new Dimension(100, 20);

    public ProgressBar(int n, int n2) {
        this.setLimits(n, n2);
    }

    public void setLimits(int n, int n2) {
        if (n == n2) {
            n2 = n + 1;
        } else if (n < n2) {
            this.min = n;
            this.max = n2;
        } else {
            this.min = n2;
            this.max = n;
        }
        this.setValue(this.value);
    }

    public void setValue(int n) {
        this.value = n;
        if (this.value < this.min) {
            this.value = this.min;
        } else if (this.value > this.max) {
            this.value = this.max;
        }
        this.repaint();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        return this.value;
    }

    public void addNotify() {
        super.addNotify();
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(1, 1, n, 1);
        graphics.drawLine(1, 1, 1, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
        graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
        graphics.setColor(this.getForeground());
        graphics.fillRect(4, 4, (n - 4 - 4) * (this.value - this.min) / (this.max - this.min) - 1, n2 - 4 - 4);
    }

    public void setPreferredSize(int n, int n2) {
        this.size = new Dimension(n, n2);
        this.invalidate();
    }

    public void setPreferredSize(Dimension dimension) {
        this.size = dimension;
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test program for ProgressBar");
        ((Component)frame).setBackground(SystemColor.control);
        frame.setForeground(Color.blue);
        ProgressBar progressBar = new ProgressBar(0, 255);
        frame.add("Center", progressBar);
        frame.pack();
        frame.show();
        frame.addWindowListener(new CloseListener());
        int n = 0;
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            progressBar.setValue(n);
            if ((n += 5) <= 255) continue;
            n = 0;
        }
    }
}

