/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.net.URL;

public class ImageCanvas
extends Component
implements AdjustmentListener {
    private transient Image image;
    int w;
    int h;
    boolean tryLoadingAsResource = false;
    String filename;

    public ImageCanvas() {
    }

    public ImageCanvas(String string) {
        this.setImage(string);
    }

    public ImageCanvas(URL uRL) {
        this.setImage(uRL);
    }

    public ImageCanvas(File file) {
        this.setImage(file);
    }

    public ImageCanvas(Image image) {
        this.setImage(image);
    }

    public void setImage(String string) {
        File file;
        try {
            file = new File(string);
            if (file.exists()) {
                this.image = this.getToolkit().getImage(file.getAbsolutePath());
                this.setupImage();
                return;
            }
        }
        catch (Exception exception) {}
        try {
            file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
            if (file.exists()) {
                this.image = this.getToolkit().getImage(file.getAbsolutePath());
                this.setupImage();
                return;
            }
        }
        catch (Exception exception) {}
        this.tryLoadingAsResource = true;
        this.filename = string;
        this.setupImage();
    }

    public void setImage(URL uRL) {
        this.image = this.getToolkit().getImage(uRL);
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    public void setImage(File file) {
        this.image = this.getToolkit().getImage(file.getAbsolutePath());
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    public void setImage(Image image) {
        this.image = image;
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    private void setupImage() {
        if (this.image == null) {
            this.image = this.createImage(20, 20);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            return;
        }
        this.h = this.image.getHeight(this);
        this.w = this.image.getWidth(this);
        this.setSize(this.getPreferredSize());
        try {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void addNotify() {
        super.addNotify();
        if (this.image == null) {
            this.setupImage();
        }
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (this.tryLoadingAsResource) {
            try {
                URL uRL = Util.getTopPanel(this).getClass().getResource(this.filename);
                this.image = this.getToolkit().getImage(uRL);
                this.tryLoadingAsResource = false;
                this.setupImage();
            }
            catch (Exception exception) {}
        }
        super.update(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, (this.getSize().width - this.w) / 2, (this.getSize().height - this.h) / 2, this.getBackground(), this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }
}

