/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.CloseListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class Flyer
extends Container
implements Runnable,
ComponentListener {
    private double xps;
    private double yps;
    private double fps;
    private double currentX;
    private double currentY;
    private Component child = new Canvas();
    private boolean bounceX = true;
    private boolean bounceY = true;
    private boolean offX = false;
    private boolean offY = false;
    int maxX = 1;
    int maxY = 1;
    int minX = 1;
    int minY = 1;
    private Dimension size;
    private boolean running = false;
    transient Thread flyThread;

    public Flyer(int n, int n2) {
        this(n, n2, 10, 0, 10);
    }

    public Flyer(int n, int n2, int n3, int n4, int n5) {
        this.size = new Dimension(n, n2);
        this.xps = n3;
        this.yps = n4;
        this.fps = n5;
        this.addComponentListener(this);
        super.setLayout(null);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void setPreferredSize(Dimension dimension) {
        this.size = dimension;
        this.invalidate();
    }

    public void setPreferredSize(int n, int n2) {
        this.size = new Dimension(n, n2);
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public void setPosition(Point point) {
        this.setPosition(point.x, point.y);
    }

    public synchronized void setPosition(int n, int n2) {
        this.currentX = n;
        this.currentY = n2;
        this.validateBounds();
    }

    public synchronized void setSpeed(double d, double d2, double d3) {
        this.xps = d;
        this.yps = d2;
        this.fps = d3;
    }

    public void setBounceX(boolean bl) {
        this.setBounce(bl, this.bounceY);
    }

    public void setBounceY(boolean bl) {
        this.setBounce(this.bounceX, bl);
    }

    public void setRunOffScreenX(boolean bl) {
        this.setRunOffScreen(bl, this.offY);
    }

    public void setRunOffScreenY(boolean bl) {
        this.setRunOffScreen(this.offX, bl);
    }

    public synchronized void setBounce(boolean bl, boolean bl2) {
        this.bounceX = bl;
        this.bounceY = bl2;
        if (this.currentX < (double)this.minX || this.currentX > (double)this.maxX) {
            this.currentX = 0.0;
        }
        if (this.currentY < (double)this.minY || this.currentY > (double)this.maxY) {
            this.currentY = 0.0;
        }
    }

    public synchronized void setRunOffScreen(boolean bl, boolean bl2) {
        this.offX = bl;
        this.offY = bl2;
        this.validateBounds();
    }

    public Point getPosition() {
        return new Point((int)this.currentX, (int)this.currentY);
    }

    public double getSpeedX() {
        return this.xps;
    }

    public double getSpeedY() {
        return this.yps;
    }

    public double getFrameRate() {
        return this.fps;
    }

    public boolean isBouncingX() {
        return this.bounceX;
    }

    public boolean isBouncingY() {
        return this.bounceY;
    }

    public boolean isRunningOffScreenX() {
        return this.offX;
    }

    public boolean isRunningOffScreenY() {
        return this.offY;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.validateBounds();
    }

    private void validateBounds() {
        if (this.offX) {
            this.minX = -this.child.getSize().width;
            this.maxX = this.getSize().width + 1;
        } else {
            this.minX = 0;
            this.maxX = this.getSize().width - this.child.getSize().width;
        }
        if (this.offY) {
            this.minY = -this.child.getSize().height;
            this.maxY = this.getSize().height + 1;
        } else {
            this.minY = 0;
            this.maxY = this.getSize().height - this.child.getSize().height;
        }
        if (this.currentX < (double)this.minX || this.currentX > (double)this.maxX) {
            this.currentX = 0.0;
        }
        if (this.currentY < (double)this.minY || this.currentY > (double)this.maxY) {
            this.currentY = 0.0;
        }
    }

    public Component add(Component component) {
        this.remove(this.child);
        this.child = component;
        super.add(this.child);
        this.child.addComponentListener(this);
        return this;
    }

    public void zeroComponent() {
        this.child.setLocation(0, 0);
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep((long)(1000.0 / this.fps));
                Flyer flyer = this;
                synchronized (flyer) {
                    this.currentX += this.xps / this.fps;
                    this.currentY += this.yps / this.fps;
                    if (this.currentX < (double)this.minX) {
                        if (this.bounceX) {
                            this.xps *= -1.0;
                            this.currentX = this.minX;
                        } else {
                            this.currentX = this.maxX;
                        }
                    } else if (this.currentX > (double)this.maxX) {
                        if (this.bounceX) {
                            this.xps *= -1.0;
                            this.currentX = this.maxX;
                        } else {
                            this.currentX = this.minX;
                        }
                    }
                    if (this.currentY < (double)this.minY) {
                        if (this.bounceY) {
                            this.yps *= -1.0;
                            this.currentY = this.minY;
                        } else {
                            this.currentY = this.maxY;
                        }
                    } else if (this.currentY > (double)this.maxY) {
                        if (this.bounceY) {
                            this.yps *= -1.0;
                            this.currentY = this.maxY;
                        } else {
                            this.currentY = this.minY;
                        }
                    }
                }
                this.child.setLocation((int)this.currentX, (int)this.currentY);
                this.child.setSize(this.child.getPreferredSize());
                this.validate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void start() {
        if (this.flyThread == null) {
            this.flyThread = new Thread((Runnable)this, "Flyer Thread");
        }
        try {
            if (this.flyThread.isAlive()) {
                this.flyThread.resume();
            } else {
                this.flyThread.start();
            }
            this.running = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void stop() {
        if (this.flyThread == null) {
            return;
        }
        try {
            this.flyThread.suspend();
            this.running = false;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void removeNotify() {
        this.stop();
        super.removeNotify();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test program for Flyer");
        Flyer flyer = new Flyer(200, 200);
        flyer.add(new Button("Flyee"));
        frame.setLayout(new BorderLayout());
        frame.add("Center", flyer);
        frame.add("South", new Button("South"));
        frame.pack();
        frame.show();
        frame.addWindowListener(new CloseListener());
        flyer.setSpeed(100.0, 30.0, 30.0);
        flyer.start();
    }
}

