/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class Email {
    String smtp;
    int port = 25;
    int timeout = 60000;
    String from;
    String to;
    String subject;
    String otherHeaders;
    String message;
    StringBuffer conversation;
    PrintWriter writer;
    BufferedReader reader;
    static String CR = System.getProperty("line.separator");

    public void setServer(String string) {
        this.smtp = string;
    }

    public void setServer(String string, int n) {
        this.smtp = string;
        this.port = n;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setAdditionalHeaders(String string) {
        this.otherHeaders = string;
    }

    public String getServer() {
        return this.smtp;
    }

    public int getPort() {
        return this.port;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLastConversation() {
        return this.conversation.toString();
    }

    private void writeln(String string) throws IOException {
        this.writer.print(String.valueOf(string) + "\r\n");
        this.writer.flush();
        this.conversation.append("< ").append(string).append(CR);
    }

    private void readln() throws IOException {
        try {
            this.conversation.append("> ").append(this.reader.readLine()).append(CR);
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            this.conversation.append("... timeout" + CR);
            throw interruptedIOException;
        }
    }

    private void talk(String string) throws IOException {
        this.writeln(string);
        this.readln();
    }

    public void send() throws IOException, UnknownHostException {
        if (this.smtp == null) {
            throw new UnknownHostException("null host");
        }
        Socket socket = new Socket(this.smtp, this.port);
        socket.setSoTimeout(this.timeout);
        this.writer = new PrintWriter(socket.getOutputStream());
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String string = null;
        this.conversation = new StringBuffer();
        this.readln();
        this.talk("HELO datarep_common_Email");
        this.talk("RSET");
        if (this.from != null) {
            this.talk("MAIL FROM:<" + this.from + ">");
        }
        if (this.to != null) {
            this.talk("RCPT TO:<" + this.to + ">");
        }
        this.talk("DATA");
        if (this.to != null) {
            this.writeln("To: <" + this.to + ">");
        }
        if (this.from != null) {
            this.writeln("From: <" + this.from + ">");
        }
        if (this.subject != null) {
            string = "Subject: " + this.subject;
            this.writeln(string);
        }
        if (this.otherHeaders != null) {
            this.writeln(this.otherHeaders);
        }
        this.writeln("");
        if (this.message != null) {
            this.writeln(this.message);
        }
        this.talk("\r\n.\r\n");
        this.talk("QUIT");
        if (this.writer.checkError()) {
            throw new IOException("Error found by PrintWriter");
        }
        this.writer.close();
        this.reader.close();
        socket.close();
    }
}

