/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Timer
extends Canvas
implements Runnable {
    Image timer;
    Image[] digit = new Image[10];
    int hour;
    int minutes;
    int seconds;
    Thread process;
    NumberFormat nf = new DecimalFormat("00");
    public Component parent;

    public Timer() {
        this.setBackground(Color.black);
        this.setForeground(Color.black);
        this.setSize(this.getPreferredSize());
        this.hour = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public void paint(Graphics g) {
        if (this.timer == null) {
            File file = new File("Images/Time.gif");
            try {
                this.timer = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
            }
            catch (Exception exception) {
                this.timer = ((Applet)this.parent).getImage(((Applet)this.parent).getCodeBase(), "Images/Time.gif");
            }
            if (this.timer == null) {
                return;
            }
        }
        if (this.digit[0] == null) {
            int width = this.timer.getWidth(this);
            int height = this.timer.getHeight(this);
            if (width < 1 || height < 1) {
                return;
            }
            int i = 0;
            int step = width / 10;
            i = 0;
            while (i < 10) {
                this.digit[i] = this.createImage(step, height);
                Graphics g1 = this.digit[i].getGraphics();
                g1.drawImage(this.timer, -i * step, 0, this);
                g1.dispose();
                ++i;
            }
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, 43, 13);
        g.setColor(Color.cyan);
        g.drawImage(this.digit[this.hour], 0, 0, this);
        g.fillRect(8, 4, 1, 1);
        g.fillRect(8, 9, 1, 1);
        g.drawImage(this.digit[this.minutes / 10], 10, 0, this);
        g.drawImage(this.digit[this.minutes % 10], 18, 0, this);
        g.fillRect(26, 4, 1, 1);
        g.fillRect(26, 9, 1, 1);
        g.drawImage(this.digit[this.seconds / 10], 28, 0, this);
        g.drawImage(this.digit[this.seconds % 10], 36, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(43, 13);
    }

    public void start() {
        if (this.process != null) {
            this.process = null;
        }
        this.seconds = 0;
        this.minutes = 0;
        this.hour = 0;
        this.process = new Thread(this);
        this.process.start();
    }

    public void stop() {
        this.process = null;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.process) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            if (me != this.process) break;
            ++this.seconds;
            if (this.seconds > 59) {
                this.seconds = 0;
                ++this.minutes;
            }
            if (this.minutes > 59) {
                this.minutes = 0;
                ++this.hour;
            }
            this.repaint();
        }
    }

    public String getTime() {
        String ret = new String(String.valueOf(new Integer(this.hour).toString()) + ":" + this.nf.format(this.minutes) + ":" + this.nf.format(this.seconds));
        return ret;
    }
}

