/*
 * Decompiled with CFR 0.152.
 */
package puzzle.pieces;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import puzzle.storeage.JigsawPuzzleException;

public class ShapeUtil {
    private static final Logger logger = Logger.getLogger(ShapeUtil.class);

    public static Shape createReversed(Shape shape) throws JigsawPuzzleException {
        logger.debug("attempting to reverse a shape");
        class PathSegment {
            final double[] pts;
            final int type;

            public PathSegment(double[] dArray, int n) {
                this.pts = dArray;
                this.type = n;
                logger.info("instantiting a PathSegment: " + dArray[0] + ", " + dArray[1] + "-type:" + n);
            }
        }
        ArrayList<PathSegment> arrayList = new ArrayList<PathSegment>();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            PathSegment pathSegment;
            switch (pathIterator.currentSegment(dArray)) {
                case 1: {
                    pathSegment = new PathSegment(ShapeUtil.copy(dArray, 2), 1);
                    break;
                }
                case 0: {
                    pathSegment = new PathSegment(ShapeUtil.copy(dArray, 2), 0);
                    break;
                }
                case 2: {
                    pathSegment = new PathSegment(ShapeUtil.copy(dArray, 4), 2);
                    break;
                }
                case 3: {
                    pathSegment = new PathSegment(ShapeUtil.copy(dArray, 6), 3);
                    break;
                }
                case 4: {
                    pathSegment = new PathSegment(ShapeUtil.copy(dArray, 0), 4);
                    break;
                }
                default: {
                    throw new JigsawPuzzleException("invalid");
                }
            }
            arrayList.add(pathSegment);
            pathIterator.next();
        }
        GeneralPath generalPath = new GeneralPath();
        int n = arrayList.size();
        block14: for (int i = n - 1; i >= 0; --i) {
            logger.info("i:" + i);
            PathSegment pathSegment = (PathSegment)arrayList.get(i);
            switch (pathSegment.type) {
                case 1: {
                    if (i == n - 1) {
                        generalPath.moveTo(pathSegment.pts[0], pathSegment.pts[1]);
                        continue block14;
                    }
                }
                case 0: {
                    generalPath.lineTo(pathSegment.pts[0], pathSegment.pts[1]);
                    continue block14;
                }
                case 2: {
                    generalPath.quadTo(pathSegment.pts[2], pathSegment.pts[3], pathSegment.pts[0], pathSegment.pts[1]);
                    continue block14;
                }
                case 3: {
                    generalPath.curveTo(pathSegment.pts[4], pathSegment.pts[5], pathSegment.pts[2], pathSegment.pts[3], pathSegment.pts[0], pathSegment.pts[1]);
                    continue block14;
                }
                default: {
                    throw new JigsawPuzzleException("invalid segment");
                }
            }
        }
        return generalPath;
    }

    protected static double[] copy(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }
}

